@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Traffic Mirror Filter.
 * @property status The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
 * @property trafficMirrorFilterDescription The description of the filter.
 * @property trafficMirrorFilterId The ID of the filter.
 * @property trafficMirrorFilterName The name of the filter.
 */
public data class GetTrafficMirrorFiltersFilter(
    public val id: String,
    public val status: String,
    public val trafficMirrorFilterDescription: String,
    public val trafficMirrorFilterId: String,
    public val trafficMirrorFilterName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetTrafficMirrorFiltersFilter): GetTrafficMirrorFiltersFilter = GetTrafficMirrorFiltersFilter(
            id = javaType.id(),
            status = javaType.status(),
            trafficMirrorFilterDescription = javaType.trafficMirrorFilterDescription(),
            trafficMirrorFilterId = javaType.trafficMirrorFilterId(),
            trafficMirrorFilterName = javaType.trafficMirrorFilterName(),
        )
    }
}
