@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTrafficMirrorSessions.
 * @property enabled
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property priority
 * @property sessions
 * @property status
 * @property trafficMirrorFilterId
 * @property trafficMirrorSessionName
 * @property trafficMirrorSourceId
 * @property trafficMirrorTargetId
 */
public data class GetTrafficMirrorSessionsResult(
    public val enabled: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val priority: Int? = null,
    public val sessions: List<GetTrafficMirrorSessionsSession>,
    public val status: String? = null,
    public val trafficMirrorFilterId: String? = null,
    public val trafficMirrorSessionName: String? = null,
    public val trafficMirrorSourceId: String? = null,
    public val trafficMirrorTargetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetTrafficMirrorSessionsResult): GetTrafficMirrorSessionsResult = GetTrafficMirrorSessionsResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            sessions = javaType.sessions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorSessionsSession.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            trafficMirrorFilterId = javaType.trafficMirrorFilterId().map({ args0 -> args0 }).orElse(null),
            trafficMirrorSessionName = javaType.trafficMirrorSessionName().map({ args0 -> args0 }).orElse(null),
            trafficMirrorSourceId = javaType.trafficMirrorSourceId().map({ args0 -> args0 }).orElse(null),
            trafficMirrorTargetId = javaType.trafficMirrorTargetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
