@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled Indicates whether traffic mirror sessions are enabled. default to `false`.
 * @property id The ID of the Traffic Mirror Session.
 * @property packetLength The maximum transmission unit (MTU).
 * @property priority The priority of the traffic mirror session. A smaller value indicates a higher priority.
 * @property status The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
 * @property trafficMirrorFilterId The ID of the filter.
 * @property trafficMirrorSessionBusinessStatus The state of the traffic mirror session. Valid values: `Normal` or `FinancialLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments.
 * @property trafficMirrorSessionDescription The description of the traffic mirror session.
 * @property trafficMirrorSessionId The first ID of the resource.
 * @property trafficMirrorSessionName The name of the traffic mirror session.
 * @property trafficMirrorSourceIds The ID of the mirror source.
 * @property trafficMirrorTargetId The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
 * @property trafficMirrorTargetType The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance
 * @property virtualNetworkId You can specify VNIs to distinguish different mirrored traffic.
 */
public data class GetTrafficMirrorSessionsSession(
    public val enabled: Boolean,
    public val id: String,
    public val packetLength: Int,
    public val priority: Int,
    public val status: String,
    public val trafficMirrorFilterId: String,
    public val trafficMirrorSessionBusinessStatus: String,
    public val trafficMirrorSessionDescription: String,
    public val trafficMirrorSessionId: String,
    public val trafficMirrorSessionName: String,
    public val trafficMirrorSourceIds: List<String>,
    public val trafficMirrorTargetId: String,
    public val trafficMirrorTargetType: String,
    public val virtualNetworkId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetTrafficMirrorSessionsSession): GetTrafficMirrorSessionsSession = GetTrafficMirrorSessionsSession(
            enabled = javaType.enabled(),
            id = javaType.id(),
            packetLength = javaType.packetLength(),
            priority = javaType.priority(),
            status = javaType.status(),
            trafficMirrorFilterId = javaType.trafficMirrorFilterId(),
            trafficMirrorSessionBusinessStatus = javaType.trafficMirrorSessionBusinessStatus(),
            trafficMirrorSessionDescription = javaType.trafficMirrorSessionDescription(),
            trafficMirrorSessionId = javaType.trafficMirrorSessionId(),
            trafficMirrorSessionName = javaType.trafficMirrorSessionName(),
            trafficMirrorSourceIds = javaType.trafficMirrorSourceIds().map({ args0 -> args0 }),
            trafficMirrorTargetId = javaType.trafficMirrorTargetId(),
            trafficMirrorTargetType = javaType.trafficMirrorTargetType(),
            virtualNetworkId = javaType.virtualNetworkId(),
        )
    }
}
