@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The Description of flow log.
 * @property flowLogId The flow log ID.
 * @property flowLogName The flow log name.
 * @property id The ID of the Flow Log.
 * @property logStoreName The log store name.
 * @property projectName The project name.
 * @property resourceId The resource id.
 * @property resourceType The resource type.
 * @property status The status of flow log.
 * @property trafficType The traffic type.
 */
public data class GetVpcFlowLogsLog(
    public val description: String,
    public val flowLogId: String,
    public val flowLogName: String,
    public val id: String,
    public val logStoreName: String,
    public val projectName: String,
    public val resourceId: String,
    public val resourceType: String,
    public val status: String,
    public val trafficType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetVpcFlowLogsLog): GetVpcFlowLogsLog = GetVpcFlowLogsLog(
            description = javaType.description(),
            flowLogId = javaType.flowLogId(),
            flowLogName = javaType.flowLogName(),
            id = javaType.id(),
            logStoreName = javaType.logStoreName(),
            projectName = javaType.projectName(),
            resourceId = javaType.resourceId(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
            trafficType = javaType.trafficType(),
        )
    }
}
