@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcFlowLogs.
 * @property description
 * @property flowLogName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property logStoreName
 * @property logs
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property projectName
 * @property resourceId
 * @property resourceType
 * @property status
 * @property trafficType
 */
public data class GetVpcFlowLogsResult(
    public val description: String? = null,
    public val flowLogName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val logStoreName: String? = null,
    public val logs: List<GetVpcFlowLogsLog>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val projectName: String? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val status: String? = null,
    public val trafficType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetVpcFlowLogsResult): GetVpcFlowLogsResult = GetVpcFlowLogsResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            flowLogName = javaType.flowLogName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            logStoreName = javaType.logStoreName().map({ args0 -> args0 }).orElse(null),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetVpcFlowLogsLog.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            projectName = javaType.projectName().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            trafficType = javaType.trafficType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
