@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceId The resource id that the network acl will associate with.
 * @property resourceType The resource id that the network acl will associate with. Only support `VSwitch` now.
 */
public data class NetworkAclAttachmentResource(
    public val resourceId: String,
    public val resourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.NetworkAclAttachmentResource): NetworkAclAttachmentResource = NetworkAclAttachmentResource(
            resourceId = javaType.resourceId(),
            resourceType = javaType.resourceType(),
        )
    }
}
