@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
 * @property destinationCidrIp The network of the destination address.
 * @property entryType The route entry type. The value can be `custom`, indicating custom.
 * @property ipVersion The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
 * @property networkAclEntryName Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
 * @property policy Authorization policy. Value:
 * - accept: Allow.
 * - drop: Refused.
 * @property port The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
 * @property protocol The protocol type. Value:
 * - icmp: Network Control Message Protocol.
 * - gre: Generic Routing Encapsulation Protocol.
 * - tcp: Transmission Control Protocol.
 * - udp: User Datagram Protocol.
 * - all: Supports all protocols.
 */
public data class NetworkAclEgressAclEntry(
    public val description: String? = null,
    public val destinationCidrIp: String? = null,
    public val entryType: String? = null,
    public val ipVersion: String? = null,
    public val networkAclEntryName: String? = null,
    public val policy: String? = null,
    public val port: String? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.NetworkAclEgressAclEntry): NetworkAclEgressAclEntry = NetworkAclEgressAclEntry(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationCidrIp = javaType.destinationCidrIp().map({ args0 -> args0 }).orElse(null),
            entryType = javaType.entryType().map({ args0 -> args0 }).orElse(null),
            ipVersion = javaType.ipVersion().map({ args0 -> args0 }).orElse(null),
            networkAclEntryName = javaType.networkAclEntryName().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
