@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description
 * @property entryType
 * @property name
 * @property policy
 * @property port
 * @property protocol
 * @property sourceCidrIp The source ip of the ingress entry.
 */
public data class NetworkAclEntriesIngress(
    public val description: String? = null,
    public val entryType: String? = null,
    public val name: String? = null,
    public val policy: String? = null,
    public val port: String? = null,
    public val protocol: String? = null,
    public val sourceCidrIp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.NetworkAclEntriesIngress): NetworkAclEntriesIngress = NetworkAclEntriesIngress(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            entryType = javaType.entryType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            sourceCidrIp = javaType.sourceCidrIp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
