@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipv6CidrBlock The IPv6 CIDR block of the default VPC.
 * > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
 * @property ipv6Isp The IPv6 address segment type of the VPC. Value:
 * - `BGP` (default): Alibaba Cloud BGP IPv6.
 * - `ChinaMobile`: China Mobile (single line).
 * - `ChinaUnicom`: China Unicom (single line).
 * - `ChinaTelecom`: China Telecom (single line).
 * > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
 */
public data class NetworkIpv6CidrBlock(
    public val ipv6CidrBlock: String? = null,
    public val ipv6Isp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.NetworkIpv6CidrBlock): NetworkIpv6CidrBlock = NetworkIpv6CidrBlock(
            ipv6CidrBlock = javaType.ipv6CidrBlock().map({ args0 -> args0 }).orElse(null),
            ipv6Isp = javaType.ipv6Isp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
