@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidr The CIDR address block of the prefix list.
 * @property description The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
 */
public data class PrefixListEntry(
    public val cidr: String? = null,
    public val description: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.PrefixListEntry): PrefixListEntry = PrefixListEntry(
            cidr = javaType.cidr().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
        )
    }
}
