@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ownerId The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
 * @property prefixListId The ID of the query Prefix List.
 * @property reason Reason when the association fails.
 * @property regionId The region ID of the prefix list to be queried.
 * @property resourceId The ID of the associated resource.
 * @property resourceType The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
 * @property resourceUid The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
 * @property status Resource attribute fields that represent the status of the resource.
 */
public data class PrefixListPrefixListAssociation(
    public val ownerId: String? = null,
    public val prefixListId: String? = null,
    public val reason: String? = null,
    public val regionId: String? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val resourceUid: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.PrefixListPrefixListAssociation): PrefixListPrefixListAssociation = PrefixListPrefixListAssociation(
            ownerId = javaType.ownerId().map({ args0 -> args0 }).orElse(null),
            prefixListId = javaType.prefixListId().map({ args0 -> args0 }).orElse(null),
            reason = javaType.reason().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            resourceUid = javaType.resourceUid().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
