@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action
 * @property destinationCidrBlock
 * @property destinationPortRange
 * @property priority
 * @property protocol
 * @property sourceCidrBlock
 * @property sourcePortRange
 * @property trafficMirrorFilterRuleStatus
 */
public data class TrafficMirrorFilterEgressRule(
    public val action: String,
    public val destinationCidrBlock: String? = null,
    public val destinationPortRange: String? = null,
    public val priority: Int? = null,
    public val protocol: String,
    public val sourceCidrBlock: String? = null,
    public val sourcePortRange: String? = null,
    public val trafficMirrorFilterRuleStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.TrafficMirrorFilterEgressRule): TrafficMirrorFilterEgressRule = TrafficMirrorFilterEgressRule(
            action = javaType.action(),
            destinationCidrBlock = javaType.destinationCidrBlock().map({ args0 -> args0 }).orElse(null),
            destinationPortRange = javaType.destinationPortRange().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            sourceCidrBlock = javaType.sourceCidrBlock().map({ args0 -> args0 }).orElse(null),
            sourcePortRange = javaType.sourcePortRange().map({ args0 -> args0 }).orElse(null),
            trafficMirrorFilterRuleStatus = javaType.trafficMirrorFilterRuleStatus().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
