@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionBgpConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionHealthCheckConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionIkeConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionIpsecConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionTunnelOptionsSpecification
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionBgpConfig.Companion.toKotlin as connectionBgpConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionHealthCheckConfig.Companion.toKotlin as connectionHealthCheckConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionIkeConfig.Companion.toKotlin as connectionIkeConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionIpsecConfig.Companion.toKotlin as connectionIpsecConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionTunnelOptionsSpecification.Companion.toKotlin as connectionTunnelOptionsSpecificationToKotlin

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource = com.pulumi.alicloud.vpn.Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connection(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * [IPsec-VPN connections support the dual-tunnel mode](https://www.alibabacloud.com/help/en/vpn/product-overview/ipsec-vpn-connections-support-the-dual-tunnel-mode)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const spec = config.get("spec") || "5";
 * const default = alicloud.vpn.getGatewayZones({
 *     spec: "5M",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const default0 = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const default1 = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[1],
 * }));
 * const HA_VPN = new alicloud.vpn.Gateway("HA-VPN", {
 *     vpnType: "Normal",
 *     disasterRecoveryVswitchId: default1.then(default1 => default1.ids?.[0]),
 *     vpnGatewayName: name,
 *     vswitchId: default0.then(default0 => default0.ids?.[0]),
 *     autoPay: true,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     networkType: "public",
 *     paymentType: "Subscription",
 *     enableIpsec: true,
 *     bandwidth: spec,
 * });
 * const defaultCustomerGateway = new alicloud.vpn.CustomerGateway("defaultCustomerGateway", {
 *     description: "defaultCustomerGateway",
 *     ipAddress: "2.2.2.5",
 *     asn: "2224",
 *     customerGatewayName: name,
 * });
 * const changeCustomerGateway = new alicloud.vpn.CustomerGateway("changeCustomerGateway", {
 *     description: "changeCustomerGateway",
 *     ipAddress: "2.2.2.6",
 *     asn: "2225",
 *     customerGatewayName: name,
 * });
 * const defaultConnection = new alicloud.vpn.Connection("default", {
 *     vpnGatewayId: HA_VPN.id,
 *     vpnConnectionName: name,
 *     localSubnets: ["3&#46;0&#46;0&#46;0/24"],
 *     remoteSubnets: [
 *         "10.0.0.0/24",
 *         "10.0.1.0/24",
 *     ],
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     enableTunnelsBgp: true,
 *     tunnelOptionsSpecifications: [
 *         {
 *             tunnelIpsecConfig: {
 *                 ipsecAuthAlg: "md5",
 *                 ipsecEncAlg: "aes256",
 *                 ipsecLifetime: 16400,
 *                 ipsecPfs: "group5",
 *             },
 *             customerGatewayId: defaultCustomerGateway.id,
 *             role: "master",
 *             tunnelBgpConfig: {
 *                 localAsn: "1219002",
 *                 tunnelCidr: "169.254.30.0/30",
 *                 localBgpIp: "169.254.30.1",
 *             },
 *             tunnelIkeConfig: {
 *                 ikeMode: "aggressive",
 *                 ikeVersion: "ikev2",
 *                 localId: "localid_tunnel2",
 *                 psk: "12345678",
 *                 remoteId: "remote2",
 *                 ikeAuthAlg: "md5",
 *                 ikeEncAlg: "aes256",
 *                 ikeLifetime: 3600,
 *                 ikePfs: "group14",
 *             },
 *         },
 *         {
 *             tunnelIkeConfig: {
 *                 remoteId: "remote24",
 *                 ikeEncAlg: "aes256",
 *                 ikeLifetime: 27000,
 *                 ikeMode: "aggressive",
 *                 ikePfs: "group5",
 *                 ikeAuthAlg: "md5",
 *                 ikeVersion: "ikev2",
 *                 localId: "localid_tunnel2",
 *                 psk: "12345678",
 *             },
 *             tunnelIpsecConfig: {
 *                 ipsecLifetime: 2700,
 *                 ipsecPfs: "group14",
 *                 ipsecAuthAlg: "md5",
 *                 ipsecEncAlg: "aes256",
 *             },
 *             customerGatewayId: defaultCustomerGateway.id,
 *             role: "slave",
 *             tunnelBgpConfig: {
 *                 localAsn: "1219002",
 *                 localBgpIp: "169.254.40.1",
 *                 tunnelCidr: "169.254.40.0/30",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * spec = config.get("spec")
 * if spec is None:
 *     spec = "5"
 * default = alicloud.vpn.get_gateway_zones(spec="5M")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="172.16.0.0/16")
 * default0 = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default1 = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[1])
 * h_a__vpn = alicloud.vpn.Gateway("HA-VPN",
 *     vpn_type="Normal",
 *     disaster_recovery_vswitch_id=default1.ids[0],
 *     vpn_gateway_name=name,
 *     vswitch_id=default0.ids[0],
 *     auto_pay=True,
 *     vpc_id=default_get_networks.ids[0],
 *     network_type="public",
 *     payment_type="Subscription",
 *     enable_ipsec=True,
 *     bandwidth=spec)
 * default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
 *     description="defaultCustomerGateway",
 *     ip_address="2.2.2.5",
 *     asn="2224",
 *     customer_gateway_name=name)
 * change_customer_gateway = alicloud.vpn.CustomerGateway("changeCustomerGateway",
 *     description="changeCustomerGateway",
 *     ip_address="2.2.2.6",
 *     asn="2225",
 *     customer_gateway_name=name)
 * default_connection = alicloud.vpn.Connection("default",
 *     vpn_gateway_id=h_a__vpn.id,
 *     vpn_connection_name=name,
 *     local_subnets=["3&#46;0&#46;0&#46;0/24"],
 *     remote_subnets=[
 *         "10.0.0.0/24",
 *         "10.0.1.0/24",
 *     ],
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     enable_tunnels_bgp=True,
 *     tunnel_options_specifications=[
 *         {
 *             "tunnel_ipsec_config": {
 *                 "ipsec_auth_alg": "md5",
 *                 "ipsec_enc_alg": "aes256",
 *                 "ipsec_lifetime": 16400,
 *                 "ipsec_pfs": "group5",
 *             },
 *             "customer_gateway_id": default_customer_gateway.id,
 *             "role": "master",
 *             "tunnel_bgp_config": {
 *                 "local_asn": "1219002",
 *                 "tunnel_cidr": "169.254.30.0/30",
 *                 "local_bgp_ip": "169.254.30.1",
 *             },
 *             "tunnel_ike_config": {
 *                 "ike_mode": "aggressive",
 *                 "ike_version": "ikev2",
 *                 "local_id": "localid_tunnel2",
 *                 "psk": "12345678",
 *                 "remote_id": "remote2",
 *                 "ike_auth_alg": "md5",
 *                 "ike_enc_alg": "aes256",
 *                 "ike_lifetime": 3600,
 *                 "ike_pfs": "group14",
 *             },
 *         },
 *         {
 *             "tunnel_ike_config": {
 *                 "remote_id": "remote24",
 *                 "ike_enc_alg": "aes256",
 *                 "ike_lifetime": 27000,
 *                 "ike_mode": "aggressive",
 *                 "ike_pfs": "group5",
 *                 "ike_auth_alg": "md5",
 *                 "ike_version": "ikev2",
 *                 "local_id": "localid_tunnel2",
 *                 "psk": "12345678",
 *             },
 *             "tunnel_ipsec_config": {
 *                 "ipsec_lifetime": 2700,
 *                 "ipsec_pfs": "group14",
 *                 "ipsec_auth_alg": "md5",
 *                 "ipsec_enc_alg": "aes256",
 *             },
 *             "customer_gateway_id": default_customer_gateway.id,
 *             "role": "slave",
 *             "tunnel_bgp_config": {
 *                 "local_asn": "1219002",
 *                 "local_bgp_ip": "169.254.40.1",
 *                 "tunnel_cidr": "169.254.40.0/30",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var spec = config.Get("spec") ?? "5";
 *     var @default = AliCloud.Vpn.GetGatewayZones.Invoke(new()
 *     {
 *         Spec = "5M",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var default0 = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getGatewayZonesResult => getGatewayZonesResult.Ids[0]),
 *     });
 *     var default1 = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getGatewayZonesResult => getGatewayZonesResult.Ids[1]),
 *     });
 *     var HA_VPN = new AliCloud.Vpn.Gateway("HA-VPN", new()
 *     {
 *         VpnType = "Normal",
 *         DisasterRecoveryVswitchId = default1.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         VpnGatewayName = name,
 *         VswitchId = default0.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         AutoPay = true,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         NetworkType = "public",
 *         PaymentType = "Subscription",
 *         EnableIpsec = true,
 *         Bandwidth = spec,
 *     });
 *     var defaultCustomerGateway = new AliCloud.Vpn.CustomerGateway("defaultCustomerGateway", new()
 *     {
 *         Description = "defaultCustomerGateway",
 *         IpAddress = "2.2.2.5",
 *         Asn = "2224",
 *         CustomerGatewayName = name,
 *     });
 *     var changeCustomerGateway = new AliCloud.Vpn.CustomerGateway("changeCustomerGateway", new()
 *     {
 *         Description = "changeCustomerGateway",
 *         IpAddress = "2.2.2.6",
 *         Asn = "2225",
 *         CustomerGatewayName = name,
 *     });
 *     var defaultConnection = new AliCloud.Vpn.Connection("default", new()
 *     {
 *         VpnGatewayId = HA_VPN.Id,
 *         VpnConnectionName = name,
 *         LocalSubnets = new[]
 *         {
 *             "3.0.0.0/24",
 *         },
 *         RemoteSubnets = new[]
 *         {
 *             "10.0.0.0/24",
 *             "10.0.1.0/24",
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         EnableTunnelsBgp = true,
 *         TunnelOptionsSpecifications = new[]
 *         {
 *             new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationArgs
 *             {
 *                 TunnelIpsecConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs
 *                 {
 *                     IpsecAuthAlg = "md5",
 *                     IpsecEncAlg = "aes256",
 *                     IpsecLifetime = 16400,
 *                     IpsecPfs = "group5",
 *                 },
 *                 CustomerGatewayId = defaultCustomerGateway.Id,
 *                 Role = "master",
 *                 TunnelBgpConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs
 *                 {
 *                     LocalAsn = "1219002",
 *                     TunnelCidr = "169.254.30.0/30",
 *                     LocalBgpIp = "169.254.30.1",
 *                 },
 *                 TunnelIkeConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs
 *                 {
 *                     IkeMode = "aggressive",
 *                     IkeVersion = "ikev2",
 *                     LocalId = "localid_tunnel2",
 *                     Psk = "12345678",
 *                     RemoteId = "remote2",
 *                     IkeAuthAlg = "md5",
 *                     IkeEncAlg = "aes256",
 *                     IkeLifetime = 3600,
 *                     IkePfs = "group14",
 *                 },
 *             },
 *             new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationArgs
 *             {
 *                 TunnelIkeConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs
 *                 {
 *                     RemoteId = "remote24",
 *                     IkeEncAlg = "aes256",
 *                     IkeLifetime = 27000,
 *                     IkeMode = "aggressive",
 *                     IkePfs = "group5",
 *                     IkeAuthAlg = "md5",
 *                     IkeVersion = "ikev2",
 *                     LocalId = "localid_tunnel2",
 *                     Psk = "12345678",
 *                 },
 *                 TunnelIpsecConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs
 *                 {
 *                     IpsecLifetime = 2700,
 *                     IpsecPfs = "group14",
 *                     IpsecAuthAlg = "md5",
 *                     IpsecEncAlg = "aes256",
 *                 },
 *                 CustomerGatewayId = defaultCustomerGateway.Id,
 *                 Role = "slave",
 *                 TunnelBgpConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs
 *                 {
 *                     LocalAsn = "1219002",
 *                     LocalBgpIp = "169.254.40.1",
 *                     TunnelCidr = "169.254.40.0/30",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		spec := "5"
 * 		if param := cfg.Get("spec"); param != "" {
 * 			spec = param
 * 		}
 * 		_default, err := vpn.GetGatewayZones(ctx, &vpn.GetGatewayZonesArgs{
 * 			Spec: "5M",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("172.16.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default0, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[1]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewGateway(ctx, "HA-VPN", &vpn.GatewayArgs{
 * 			VpnType:                   pulumi.String("Normal"),
 * 			DisasterRecoveryVswitchId: pulumi.String(default1.Ids[0]),
 * 			VpnGatewayName:            pulumi.String(name),
 * 			VswitchId:                 pulumi.String(default0.Ids[0]),
 * 			AutoPay:                   pulumi.Bool(true),
 * 			VpcId:                     pulumi.String(defaultGetNetworks.Ids[0]),
 * 			NetworkType:               pulumi.String("public"),
 * 			PaymentType:               pulumi.String("Subscription"),
 * 			EnableIpsec:               pulumi.Bool(true),
 * 			Bandwidth:                 pulumi.String(spec),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCustomerGateway, err := vpn.NewCustomerGateway(ctx, "defaultCustomerGateway", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String("defaultCustomerGateway"),
 * 			IpAddress:           pulumi.String("2.2.2.5"),
 * 			Asn:                 pulumi.String("2224"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewCustomerGateway(ctx, "changeCustomerGateway", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String("changeCustomerGateway"),
 * 			IpAddress:           pulumi.String("2.2.2.6"),
 * 			Asn:                 pulumi.String("2225"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewConnection(ctx, "default", &vpn.ConnectionArgs{
 * 			VpnGatewayId:      HA_VPN.ID(),
 * 			VpnConnectionName: pulumi.String(name),
 * 			LocalSubnets: pulumi.StringArray{
 * 				pulumi.String("3.0.0.0/24"),
 * 			},
 * 			RemoteSubnets: pulumi.StringArray{
 * 				pulumi.String("10.0.0.0/24"),
 * 				pulumi.String("10.0.1.0/24"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			EnableTunnelsBgp: pulumi.Bool(true),
 * 			TunnelOptionsSpecifications: vpn.ConnectionTunnelOptionsSpecificationArray{
 * 				&vpn.ConnectionTunnelOptionsSpecificationArgs{
 * 					TunnelIpsecConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs{
 * 						IpsecAuthAlg:  pulumi.String("md5"),
 * 						IpsecEncAlg:   pulumi.String("aes256"),
 * 						IpsecLifetime: pulumi.Int(16400),
 * 						IpsecPfs:      pulumi.String("group5"),
 * 					},
 * 					CustomerGatewayId: defaultCustomerGateway.ID(),
 * 					Role:              pulumi.String("master"),
 * 					TunnelBgpConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs{
 * 						LocalAsn:   pulumi.String("1219002"),
 * 						TunnelCidr: pulumi.String("169.254.30.0/30"),
 * 						LocalBgpIp: pulumi.String("169.254.30.1"),
 * 					},
 * 					TunnelIkeConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs{
 * 						IkeMode:     pulumi.String("aggressive"),
 * 						IkeVersion:  pulumi.String("ikev2"),
 * 						LocalId:     pulumi.String("localid_tunnel2"),
 * 						Psk:         pulumi.String("12345678"),
 * 						RemoteId:    pulumi.String("remote2"),
 * 						IkeAuthAlg:  pulumi.String("md5"),
 * 						IkeEncAlg:   pulumi.String("aes256"),
 * 						IkeLifetime: pulumi.Int(3600),
 * 						IkePfs:      pulumi.String("group14"),
 * 					},
 * 				},
 * 				&vpn.ConnectionTunnelOptionsSpecificationArgs{
 * 					TunnelIkeConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs{
 * 						RemoteId:    pulumi.String("remote24"),
 * 						IkeEncAlg:   pulumi.String("aes256"),
 * 						IkeLifetime: pulumi.Int(27000),
 * 						IkeMode:     pulumi.String("aggressive"),
 * 						IkePfs:      pulumi.String("group5"),
 * 						IkeAuthAlg:  pulumi.String("md5"),
 * 						IkeVersion:  pulumi.String("ikev2"),
 * 						LocalId:     pulumi.String("localid_tunnel2"),
 * 						Psk:         pulumi.String("12345678"),
 * 					},
 * 					TunnelIpsecConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs{
 * 						IpsecLifetime: pulumi.Int(2700),
 * 						IpsecPfs:      pulumi.String("group14"),
 * 						IpsecAuthAlg:  pulumi.String("md5"),
 * 						IpsecEncAlg:   pulumi.String("aes256"),
 * 					},
 * 					CustomerGatewayId: defaultCustomerGateway.ID(),
 * 					Role:              pulumi.String("slave"),
 * 					TunnelBgpConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs{
 * 						LocalAsn:   pulumi.String("1219002"),
 * 						LocalBgpIp: pulumi.String("169.254.40.1"),
 * 						TunnelCidr: pulumi.String("169.254.40.0/30"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.VpnFunctions;
 * import com.pulumi.alicloud.vpn.inputs.GetGatewayZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.vpn.Gateway;
 * import com.pulumi.alicloud.vpn.GatewayArgs;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.Connection;
 * import com.pulumi.alicloud.vpn.ConnectionArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var spec = config.get("spec").orElse("5");
 *         final var default = VpnFunctions.getGatewayZones(GetGatewayZonesArgs.builder()
 *             .spec("5M")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         final var default0 = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         final var default1 = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[1])
 *             .build());
 *         var hA_VPN = new Gateway("HA-VPN", GatewayArgs.builder()
 *             .vpnType("Normal")
 *             .disasterRecoveryVswitchId(default1.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpnGatewayName(name)
 *             .vswitchId(default0.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .autoPay(true)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .networkType("public")
 *             .paymentType("Subscription")
 *             .enableIpsec(true)
 *             .bandwidth(spec)
 *             .build());
 *         var defaultCustomerGateway = new CustomerGateway("defaultCustomerGateway", CustomerGatewayArgs.builder()
 *             .description("defaultCustomerGateway")
 *             .ipAddress("2.2.2.5")
 *             .asn("2224")
 *             .customerGatewayName(name)
 *             .build());
 *         var changeCustomerGateway = new CustomerGateway("changeCustomerGateway", CustomerGatewayArgs.builder()
 *             .description("changeCustomerGateway")
 *             .ipAddress("2.2.2.6")
 *             .asn("2225")
 *             .customerGatewayName(name)
 *             .build());
 *         var defaultConnection = new Connection("defaultConnection", ConnectionArgs.builder()
 *             .vpnGatewayId(HA_VPN.id())
 *             .vpnConnectionName(name)
 *             .localSubnets("3.0.0.0/24")
 *             .remoteSubnets(
 *                 "10.0.0.0/24",
 *                 "10.0.1.0/24")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .enableTunnelsBgp("true")
 *             .tunnelOptionsSpecifications(
 *                 ConnectionTunnelOptionsSpecificationArgs.builder()
 *                     .tunnelIpsecConfig(ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
 *                         .ipsecAuthAlg("md5")
 *                         .ipsecEncAlg("aes256")
 *                         .ipsecLifetime("16400")
 *                         .ipsecPfs("group5")
 *                         .build())
 *                     .customerGatewayId(defaultCustomerGateway.id())
 *                     .role("master")
 *                     .tunnelBgpConfig(ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
 *                         .localAsn("1219002")
 *                         .tunnelCidr("169.254.30.0/30")
 *                         .localBgpIp("169.254.30.1")
 *                         .build())
 *                     .tunnelIkeConfig(ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
 *                         .ikeMode("aggressive")
 *                         .ikeVersion("ikev2")
 *                         .localId("localid_tunnel2")
 *                         .psk("12345678")
 *                         .remoteId("remote2")
 *                         .ikeAuthAlg("md5")
 *                         .ikeEncAlg("aes256")
 *                         .ikeLifetime("3600")
 *                         .ikePfs("group14")
 *                         .build())
 *                     .build(),
 *                 ConnectionTunnelOptionsSpecificationArgs.builder()
 *                     .tunnelIkeConfig(ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
 *                         .remoteId("remote24")
 *                         .ikeEncAlg("aes256")
 *                         .ikeLifetime("27000")
 *                         .ikeMode("aggressive")
 *                         .ikePfs("group5")
 *                         .ikeAuthAlg("md5")
 *                         .ikeVersion("ikev2")
 *                         .localId("localid_tunnel2")
 *                         .psk("12345678")
 *                         .build())
 *                     .tunnelIpsecConfig(ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
 *                         .ipsecLifetime("2700")
 *                         .ipsecPfs("group14")
 *                         .ipsecAuthAlg("md5")
 *                         .ipsecEncAlg("aes256")
 *                         .build())
 *                     .customerGatewayId(defaultCustomerGateway.id())
 *                     .role("slave")
 *                     .tunnelBgpConfig(ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
 *                         .localAsn("1219002")
 *                         .localBgpIp("169.254.40.1")
 *                         .tunnelCidr("169.254.40.0/30")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   spec:
 *     type: string
 *     default: '5'
 * resources:
 *   HA-VPN:
 *     type: alicloud:vpn:Gateway
 *     properties:
 *       vpnType: Normal
 *       disasterRecoveryVswitchId: ${default1.ids[0]}
 *       vpnGatewayName: ${name}
 *       vswitchId: ${default0.ids[0]}
 *       autoPay: true
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       networkType: public
 *       paymentType: Subscription
 *       enableIpsec: true
 *       bandwidth: ${spec}
 *   defaultCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: defaultCustomerGateway
 *       ipAddress: 2.2.2.5
 *       asn: '2224'
 *       customerGatewayName: ${name}
 *   changeCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: changeCustomerGateway
 *       ipAddress: 2.2.2.6
 *       asn: '2225'
 *       customerGatewayName: ${name}
 *   defaultConnection:
 *     type: alicloud:vpn:Connection
 *     name: default
 *     properties:
 *       vpnGatewayId: ${["HA-VPN"].id}
 *       vpnConnectionName: ${name}
 *       localSubnets:
 *         - 3.0.0.0/24
 *       remoteSubnets:
 *         - 10.0.0.0/24
 *         - 10.0.1.0/24
 *       tags:
 *         Created: TF
 *         For: example
 *       enableTunnelsBgp: 'true'
 *       tunnelOptionsSpecifications:
 *         - tunnelIpsecConfig:
 *             ipsecAuthAlg: md5
 *             ipsecEncAlg: aes256
 *             ipsecLifetime: '16400'
 *             ipsecPfs: group5
 *           customerGatewayId: ${defaultCustomerGateway.id}
 *           role: master
 *           tunnelBgpConfig:
 *             localAsn: '1219002'
 *             tunnelCidr: 169.254.30.0/30
 *             localBgpIp: 169.254.30.1
 *           tunnelIkeConfig:
 *             ikeMode: aggressive
 *             ikeVersion: ikev2
 *             localId: localid_tunnel2
 *             psk: '12345678'
 *             remoteId: remote2
 *             ikeAuthAlg: md5
 *             ikeEncAlg: aes256
 *             ikeLifetime: '3600'
 *             ikePfs: group14
 *         - tunnelIkeConfig:
 *             remoteId: remote24
 *             ikeEncAlg: aes256
 *             ikeLifetime: '27000'
 *             ikeMode: aggressive
 *             ikePfs: group5
 *             ikeAuthAlg: md5
 *             ikeVersion: ikev2
 *             localId: localid_tunnel2
 *             psk: '12345678'
 *           tunnelIpsecConfig:
 *             ipsecLifetime: '2700'
 *             ipsecPfs: group14
 *             ipsecAuthAlg: md5
 *             ipsecEncAlg: aes256
 *           customerGatewayId: ${defaultCustomerGateway.id}
 *           role: slave
 *           tunnelBgpConfig:
 *             localAsn: '1219002'
 *             localBgpIp: 169.254.40.1
 *             tunnelCidr: 169.254.40.0/30
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpn:getGatewayZones
 *       Arguments:
 *         spec: 5M
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 172.16.0.0/16
 *   default0:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 *   default1:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[1]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/connection:Connection example <id>
 * ```
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * Whether to configure routing automatically. Value:
     * - **true**: Automatically configure routes.
     * - **false**: does not automatically configure routes.
     */
    public val autoConfigRoute: Output<Boolean>?
        get() = javaResource.autoConfigRoute().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * vpnBgp configuration. See `bgp_config` below.
     */
    public val bgpConfig: Output<ConnectionBgpConfig>
        get() = javaResource.bgpConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionBgpConfigToKotlin(args0)
            })
        })

    /**
     * The time when the IPsec-VPN connection was created.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the customer gateway.
     */
    public val customerGatewayId: Output<String>?
        get() = javaResource.customerGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
     */
    public val effectImmediately: Output<Boolean>?
        get() = javaResource.effectImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Wether enable Dpd detection.
     */
    public val enableDpd: Output<Boolean>
        get() = javaResource.enableDpd().applyValue({ args0 -> args0 })

    /**
     * enable nat traversal.
     */
    public val enableNatTraversal: Output<Boolean>
        get() = javaResource.enableNatTraversal().applyValue({ args0 -> args0 })

    /**
     * Enable tunnel bgp.
     */
    public val enableTunnelsBgp: Output<Boolean>
        get() = javaResource.enableTunnelsBgp().applyValue({ args0 -> args0 })

    /**
     * Health Check information. See `health_check_config` below.
     */
    public val healthCheckConfig: Output<ConnectionHealthCheckConfig>
        get() = javaResource.healthCheckConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionHealthCheckConfigToKotlin(args0)
            })
        })

    /**
     * The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    public val ikeConfig: Output<ConnectionIkeConfig>
        get() = javaResource.ikeConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionIkeConfigToKotlin(args0)
            })
        })

    /**
     * IPsec configuration. See `ipsec_config` below.
     */
    public val ipsecConfig: Output<ConnectionIpsecConfig>
        get() = javaResource.ipsecConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionIpsecConfigToKotlin(args0)
            })
        })

    /**
     * The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
     */
    public val localSubnets: Output<List<String>>
        get() = javaResource.localSubnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network type of the IPsec connection. Value:
     * - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
     * - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
     */
    public val networkType: Output<String>?
        get() = javaResource.networkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CIDR block of the local data center. This parameter is used for phase-two negotiation.
     */
    public val remoteSubnets: Output<List<String>>
        get() = javaResource.remoteSubnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The negotiation status of Tunnel.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    public val tunnelOptionsSpecifications: Output<List<ConnectionTunnelOptionsSpecification>>?
        get() = javaResource.tunnelOptionsSpecifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        connectionTunnelOptionsSpecificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the IPsec-VPN connection.
     */
    public val vpnConnectionName: Output<String>
        get() = javaResource.vpnConnectionName().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPN gateway.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vpnGatewayId: Output<String>
        get() = javaResource.vpnGatewayId().applyValue({ args0 -> args0 })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.alicloud.vpn.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
