@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.ConnectionArgs.builder
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionBgpConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionBgpConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionHealthCheckConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionHealthCheckConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionIkeConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionIkeConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionIpsecConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionIpsecConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionTunnelOptionsSpecificationArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.ConnectionTunnelOptionsSpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * [IPsec-VPN connections support the dual-tunnel mode](https://www.alibabacloud.com/help/en/vpn/product-overview/ipsec-vpn-connections-support-the-dual-tunnel-mode)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const spec = config.get("spec") || "5";
 * const default = alicloud.vpn.getGatewayZones({
 *     spec: "5M",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const default0 = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const default1 = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[1],
 * }));
 * const HA_VPN = new alicloud.vpn.Gateway("HA-VPN", {
 *     vpnType: "Normal",
 *     disasterRecoveryVswitchId: default1.then(default1 => default1.ids?.[0]),
 *     vpnGatewayName: name,
 *     vswitchId: default0.then(default0 => default0.ids?.[0]),
 *     autoPay: true,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     networkType: "public",
 *     paymentType: "Subscription",
 *     enableIpsec: true,
 *     bandwidth: spec,
 * });
 * const defaultCustomerGateway = new alicloud.vpn.CustomerGateway("defaultCustomerGateway", {
 *     description: "defaultCustomerGateway",
 *     ipAddress: "2.2.2.5",
 *     asn: "2224",
 *     customerGatewayName: name,
 * });
 * const changeCustomerGateway = new alicloud.vpn.CustomerGateway("changeCustomerGateway", {
 *     description: "changeCustomerGateway",
 *     ipAddress: "2.2.2.6",
 *     asn: "2225",
 *     customerGatewayName: name,
 * });
 * const defaultConnection = new alicloud.vpn.Connection("default", {
 *     vpnGatewayId: HA_VPN.id,
 *     vpnConnectionName: name,
 *     localSubnets: ["3&#46;0&#46;0&#46;0/24"],
 *     remoteSubnets: [
 *         "10.0.0.0/24",
 *         "10.0.1.0/24",
 *     ],
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     enableTunnelsBgp: true,
 *     tunnelOptionsSpecifications: [
 *         {
 *             tunnelIpsecConfig: {
 *                 ipsecAuthAlg: "md5",
 *                 ipsecEncAlg: "aes256",
 *                 ipsecLifetime: 16400,
 *                 ipsecPfs: "group5",
 *             },
 *             customerGatewayId: defaultCustomerGateway.id,
 *             role: "master",
 *             tunnelBgpConfig: {
 *                 localAsn: "1219002",
 *                 tunnelCidr: "169.254.30.0/30",
 *                 localBgpIp: "169.254.30.1",
 *             },
 *             tunnelIkeConfig: {
 *                 ikeMode: "aggressive",
 *                 ikeVersion: "ikev2",
 *                 localId: "localid_tunnel2",
 *                 psk: "12345678",
 *                 remoteId: "remote2",
 *                 ikeAuthAlg: "md5",
 *                 ikeEncAlg: "aes256",
 *                 ikeLifetime: 3600,
 *                 ikePfs: "group14",
 *             },
 *         },
 *         {
 *             tunnelIkeConfig: {
 *                 remoteId: "remote24",
 *                 ikeEncAlg: "aes256",
 *                 ikeLifetime: 27000,
 *                 ikeMode: "aggressive",
 *                 ikePfs: "group5",
 *                 ikeAuthAlg: "md5",
 *                 ikeVersion: "ikev2",
 *                 localId: "localid_tunnel2",
 *                 psk: "12345678",
 *             },
 *             tunnelIpsecConfig: {
 *                 ipsecLifetime: 2700,
 *                 ipsecPfs: "group14",
 *                 ipsecAuthAlg: "md5",
 *                 ipsecEncAlg: "aes256",
 *             },
 *             customerGatewayId: defaultCustomerGateway.id,
 *             role: "slave",
 *             tunnelBgpConfig: {
 *                 localAsn: "1219002",
 *                 localBgpIp: "169.254.40.1",
 *                 tunnelCidr: "169.254.40.0/30",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * spec = config.get("spec")
 * if spec is None:
 *     spec = "5"
 * default = alicloud.vpn.get_gateway_zones(spec="5M")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="172.16.0.0/16")
 * default0 = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default1 = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[1])
 * h_a__vpn = alicloud.vpn.Gateway("HA-VPN",
 *     vpn_type="Normal",
 *     disaster_recovery_vswitch_id=default1.ids[0],
 *     vpn_gateway_name=name,
 *     vswitch_id=default0.ids[0],
 *     auto_pay=True,
 *     vpc_id=default_get_networks.ids[0],
 *     network_type="public",
 *     payment_type="Subscription",
 *     enable_ipsec=True,
 *     bandwidth=spec)
 * default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
 *     description="defaultCustomerGateway",
 *     ip_address="2.2.2.5",
 *     asn="2224",
 *     customer_gateway_name=name)
 * change_customer_gateway = alicloud.vpn.CustomerGateway("changeCustomerGateway",
 *     description="changeCustomerGateway",
 *     ip_address="2.2.2.6",
 *     asn="2225",
 *     customer_gateway_name=name)
 * default_connection = alicloud.vpn.Connection("default",
 *     vpn_gateway_id=h_a__vpn.id,
 *     vpn_connection_name=name,
 *     local_subnets=["3&#46;0&#46;0&#46;0/24"],
 *     remote_subnets=[
 *         "10.0.0.0/24",
 *         "10.0.1.0/24",
 *     ],
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     enable_tunnels_bgp=True,
 *     tunnel_options_specifications=[
 *         {
 *             "tunnel_ipsec_config": {
 *                 "ipsec_auth_alg": "md5",
 *                 "ipsec_enc_alg": "aes256",
 *                 "ipsec_lifetime": 16400,
 *                 "ipsec_pfs": "group5",
 *             },
 *             "customer_gateway_id": default_customer_gateway.id,
 *             "role": "master",
 *             "tunnel_bgp_config": {
 *                 "local_asn": "1219002",
 *                 "tunnel_cidr": "169.254.30.0/30",
 *                 "local_bgp_ip": "169.254.30.1",
 *             },
 *             "tunnel_ike_config": {
 *                 "ike_mode": "aggressive",
 *                 "ike_version": "ikev2",
 *                 "local_id": "localid_tunnel2",
 *                 "psk": "12345678",
 *                 "remote_id": "remote2",
 *                 "ike_auth_alg": "md5",
 *                 "ike_enc_alg": "aes256",
 *                 "ike_lifetime": 3600,
 *                 "ike_pfs": "group14",
 *             },
 *         },
 *         {
 *             "tunnel_ike_config": {
 *                 "remote_id": "remote24",
 *                 "ike_enc_alg": "aes256",
 *                 "ike_lifetime": 27000,
 *                 "ike_mode": "aggressive",
 *                 "ike_pfs": "group5",
 *                 "ike_auth_alg": "md5",
 *                 "ike_version": "ikev2",
 *                 "local_id": "localid_tunnel2",
 *                 "psk": "12345678",
 *             },
 *             "tunnel_ipsec_config": {
 *                 "ipsec_lifetime": 2700,
 *                 "ipsec_pfs": "group14",
 *                 "ipsec_auth_alg": "md5",
 *                 "ipsec_enc_alg": "aes256",
 *             },
 *             "customer_gateway_id": default_customer_gateway.id,
 *             "role": "slave",
 *             "tunnel_bgp_config": {
 *                 "local_asn": "1219002",
 *                 "local_bgp_ip": "169.254.40.1",
 *                 "tunnel_cidr": "169.254.40.0/30",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var spec = config.Get("spec") ?? "5";
 *     var @default = AliCloud.Vpn.GetGatewayZones.Invoke(new()
 *     {
 *         Spec = "5M",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var default0 = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getGatewayZonesResult => getGatewayZonesResult.Ids[0]),
 *     });
 *     var default1 = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getGatewayZonesResult => getGatewayZonesResult.Ids[1]),
 *     });
 *     var HA_VPN = new AliCloud.Vpn.Gateway("HA-VPN", new()
 *     {
 *         VpnType = "Normal",
 *         DisasterRecoveryVswitchId = default1.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         VpnGatewayName = name,
 *         VswitchId = default0.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         AutoPay = true,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         NetworkType = "public",
 *         PaymentType = "Subscription",
 *         EnableIpsec = true,
 *         Bandwidth = spec,
 *     });
 *     var defaultCustomerGateway = new AliCloud.Vpn.CustomerGateway("defaultCustomerGateway", new()
 *     {
 *         Description = "defaultCustomerGateway",
 *         IpAddress = "2.2.2.5",
 *         Asn = "2224",
 *         CustomerGatewayName = name,
 *     });
 *     var changeCustomerGateway = new AliCloud.Vpn.CustomerGateway("changeCustomerGateway", new()
 *     {
 *         Description = "changeCustomerGateway",
 *         IpAddress = "2.2.2.6",
 *         Asn = "2225",
 *         CustomerGatewayName = name,
 *     });
 *     var defaultConnection = new AliCloud.Vpn.Connection("default", new()
 *     {
 *         VpnGatewayId = HA_VPN.Id,
 *         VpnConnectionName = name,
 *         LocalSubnets = new[]
 *         {
 *             "3.0.0.0/24",
 *         },
 *         RemoteSubnets = new[]
 *         {
 *             "10.0.0.0/24",
 *             "10.0.1.0/24",
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         EnableTunnelsBgp = true,
 *         TunnelOptionsSpecifications = new[]
 *         {
 *             new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationArgs
 *             {
 *                 TunnelIpsecConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs
 *                 {
 *                     IpsecAuthAlg = "md5",
 *                     IpsecEncAlg = "aes256",
 *                     IpsecLifetime = 16400,
 *                     IpsecPfs = "group5",
 *                 },
 *                 CustomerGatewayId = defaultCustomerGateway.Id,
 *                 Role = "master",
 *                 TunnelBgpConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs
 *                 {
 *                     LocalAsn = "1219002",
 *                     TunnelCidr = "169.254.30.0/30",
 *                     LocalBgpIp = "169.254.30.1",
 *                 },
 *                 TunnelIkeConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs
 *                 {
 *                     IkeMode = "aggressive",
 *                     IkeVersion = "ikev2",
 *                     LocalId = "localid_tunnel2",
 *                     Psk = "12345678",
 *                     RemoteId = "remote2",
 *                     IkeAuthAlg = "md5",
 *                     IkeEncAlg = "aes256",
 *                     IkeLifetime = 3600,
 *                     IkePfs = "group14",
 *                 },
 *             },
 *             new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationArgs
 *             {
 *                 TunnelIkeConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs
 *                 {
 *                     RemoteId = "remote24",
 *                     IkeEncAlg = "aes256",
 *                     IkeLifetime = 27000,
 *                     IkeMode = "aggressive",
 *                     IkePfs = "group5",
 *                     IkeAuthAlg = "md5",
 *                     IkeVersion = "ikev2",
 *                     LocalId = "localid_tunnel2",
 *                     Psk = "12345678",
 *                 },
 *                 TunnelIpsecConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs
 *                 {
 *                     IpsecLifetime = 2700,
 *                     IpsecPfs = "group14",
 *                     IpsecAuthAlg = "md5",
 *                     IpsecEncAlg = "aes256",
 *                 },
 *                 CustomerGatewayId = defaultCustomerGateway.Id,
 *                 Role = "slave",
 *                 TunnelBgpConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs
 *                 {
 *                     LocalAsn = "1219002",
 *                     LocalBgpIp = "169.254.40.1",
 *                     TunnelCidr = "169.254.40.0/30",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		spec := "5"
 * 		if param := cfg.Get("spec"); param != "" {
 * 			spec = param
 * 		}
 * 		_default, err := vpn.GetGatewayZones(ctx, &vpn.GetGatewayZonesArgs{
 * 			Spec: "5M",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("172.16.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default0, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[1]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewGateway(ctx, "HA-VPN", &vpn.GatewayArgs{
 * 			VpnType:                   pulumi.String("Normal"),
 * 			DisasterRecoveryVswitchId: pulumi.String(default1.Ids[0]),
 * 			VpnGatewayName:            pulumi.String(name),
 * 			VswitchId:                 pulumi.String(default0.Ids[0]),
 * 			AutoPay:                   pulumi.Bool(true),
 * 			VpcId:                     pulumi.String(defaultGetNetworks.Ids[0]),
 * 			NetworkType:               pulumi.String("public"),
 * 			PaymentType:               pulumi.String("Subscription"),
 * 			EnableIpsec:               pulumi.Bool(true),
 * 			Bandwidth:                 pulumi.String(spec),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCustomerGateway, err := vpn.NewCustomerGateway(ctx, "defaultCustomerGateway", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String("defaultCustomerGateway"),
 * 			IpAddress:           pulumi.String("2.2.2.5"),
 * 			Asn:                 pulumi.String("2224"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewCustomerGateway(ctx, "changeCustomerGateway", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String("changeCustomerGateway"),
 * 			IpAddress:           pulumi.String("2.2.2.6"),
 * 			Asn:                 pulumi.String("2225"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewConnection(ctx, "default", &vpn.ConnectionArgs{
 * 			VpnGatewayId:      HA_VPN.ID(),
 * 			VpnConnectionName: pulumi.String(name),
 * 			LocalSubnets: pulumi.StringArray{
 * 				pulumi.String("3.0.0.0/24"),
 * 			},
 * 			RemoteSubnets: pulumi.StringArray{
 * 				pulumi.String("10.0.0.0/24"),
 * 				pulumi.String("10.0.1.0/24"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			EnableTunnelsBgp: pulumi.Bool(true),
 * 			TunnelOptionsSpecifications: vpn.ConnectionTunnelOptionsSpecificationArray{
 * 				&vpn.ConnectionTunnelOptionsSpecificationArgs{
 * 					TunnelIpsecConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs{
 * 						IpsecAuthAlg:  pulumi.String("md5"),
 * 						IpsecEncAlg:   pulumi.String("aes256"),
 * 						IpsecLifetime: pulumi.Int(16400),
 * 						IpsecPfs:      pulumi.String("group5"),
 * 					},
 * 					CustomerGatewayId: defaultCustomerGateway.ID(),
 * 					Role:              pulumi.String("master"),
 * 					TunnelBgpConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs{
 * 						LocalAsn:   pulumi.String("1219002"),
 * 						TunnelCidr: pulumi.String("169.254.30.0/30"),
 * 						LocalBgpIp: pulumi.String("169.254.30.1"),
 * 					},
 * 					TunnelIkeConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs{
 * 						IkeMode:     pulumi.String("aggressive"),
 * 						IkeVersion:  pulumi.String("ikev2"),
 * 						LocalId:     pulumi.String("localid_tunnel2"),
 * 						Psk:         pulumi.String("12345678"),
 * 						RemoteId:    pulumi.String("remote2"),
 * 						IkeAuthAlg:  pulumi.String("md5"),
 * 						IkeEncAlg:   pulumi.String("aes256"),
 * 						IkeLifetime: pulumi.Int(3600),
 * 						IkePfs:      pulumi.String("group14"),
 * 					},
 * 				},
 * 				&vpn.ConnectionTunnelOptionsSpecificationArgs{
 * 					TunnelIkeConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs{
 * 						RemoteId:    pulumi.String("remote24"),
 * 						IkeEncAlg:   pulumi.String("aes256"),
 * 						IkeLifetime: pulumi.Int(27000),
 * 						IkeMode:     pulumi.String("aggressive"),
 * 						IkePfs:      pulumi.String("group5"),
 * 						IkeAuthAlg:  pulumi.String("md5"),
 * 						IkeVersion:  pulumi.String("ikev2"),
 * 						LocalId:     pulumi.String("localid_tunnel2"),
 * 						Psk:         pulumi.String("12345678"),
 * 					},
 * 					TunnelIpsecConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs{
 * 						IpsecLifetime: pulumi.Int(2700),
 * 						IpsecPfs:      pulumi.String("group14"),
 * 						IpsecAuthAlg:  pulumi.String("md5"),
 * 						IpsecEncAlg:   pulumi.String("aes256"),
 * 					},
 * 					CustomerGatewayId: defaultCustomerGateway.ID(),
 * 					Role:              pulumi.String("slave"),
 * 					TunnelBgpConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs{
 * 						LocalAsn:   pulumi.String("1219002"),
 * 						LocalBgpIp: pulumi.String("169.254.40.1"),
 * 						TunnelCidr: pulumi.String("169.254.40.0/30"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.VpnFunctions;
 * import com.pulumi.alicloud.vpn.inputs.GetGatewayZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.vpn.Gateway;
 * import com.pulumi.alicloud.vpn.GatewayArgs;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.Connection;
 * import com.pulumi.alicloud.vpn.ConnectionArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var spec = config.get("spec").orElse("5");
 *         final var default = VpnFunctions.getGatewayZones(GetGatewayZonesArgs.builder()
 *             .spec("5M")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         final var default0 = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         final var default1 = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[1])
 *             .build());
 *         var hA_VPN = new Gateway("HA-VPN", GatewayArgs.builder()
 *             .vpnType("Normal")
 *             .disasterRecoveryVswitchId(default1.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpnGatewayName(name)
 *             .vswitchId(default0.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .autoPay(true)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .networkType("public")
 *             .paymentType("Subscription")
 *             .enableIpsec(true)
 *             .bandwidth(spec)
 *             .build());
 *         var defaultCustomerGateway = new CustomerGateway("defaultCustomerGateway", CustomerGatewayArgs.builder()
 *             .description("defaultCustomerGateway")
 *             .ipAddress("2.2.2.5")
 *             .asn("2224")
 *             .customerGatewayName(name)
 *             .build());
 *         var changeCustomerGateway = new CustomerGateway("changeCustomerGateway", CustomerGatewayArgs.builder()
 *             .description("changeCustomerGateway")
 *             .ipAddress("2.2.2.6")
 *             .asn("2225")
 *             .customerGatewayName(name)
 *             .build());
 *         var defaultConnection = new Connection("defaultConnection", ConnectionArgs.builder()
 *             .vpnGatewayId(HA_VPN.id())
 *             .vpnConnectionName(name)
 *             .localSubnets("3.0.0.0/24")
 *             .remoteSubnets(
 *                 "10.0.0.0/24",
 *                 "10.0.1.0/24")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .enableTunnelsBgp("true")
 *             .tunnelOptionsSpecifications(
 *                 ConnectionTunnelOptionsSpecificationArgs.builder()
 *                     .tunnelIpsecConfig(ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
 *                         .ipsecAuthAlg("md5")
 *                         .ipsecEncAlg("aes256")
 *                         .ipsecLifetime("16400")
 *                         .ipsecPfs("group5")
 *                         .build())
 *                     .customerGatewayId(defaultCustomerGateway.id())
 *                     .role("master")
 *                     .tunnelBgpConfig(ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
 *                         .localAsn("1219002")
 *                         .tunnelCidr("169.254.30.0/30")
 *                         .localBgpIp("169.254.30.1")
 *                         .build())
 *                     .tunnelIkeConfig(ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
 *                         .ikeMode("aggressive")
 *                         .ikeVersion("ikev2")
 *                         .localId("localid_tunnel2")
 *                         .psk("12345678")
 *                         .remoteId("remote2")
 *                         .ikeAuthAlg("md5")
 *                         .ikeEncAlg("aes256")
 *                         .ikeLifetime("3600")
 *                         .ikePfs("group14")
 *                         .build())
 *                     .build(),
 *                 ConnectionTunnelOptionsSpecificationArgs.builder()
 *                     .tunnelIkeConfig(ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
 *                         .remoteId("remote24")
 *                         .ikeEncAlg("aes256")
 *                         .ikeLifetime("27000")
 *                         .ikeMode("aggressive")
 *                         .ikePfs("group5")
 *                         .ikeAuthAlg("md5")
 *                         .ikeVersion("ikev2")
 *                         .localId("localid_tunnel2")
 *                         .psk("12345678")
 *                         .build())
 *                     .tunnelIpsecConfig(ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
 *                         .ipsecLifetime("2700")
 *                         .ipsecPfs("group14")
 *                         .ipsecAuthAlg("md5")
 *                         .ipsecEncAlg("aes256")
 *                         .build())
 *                     .customerGatewayId(defaultCustomerGateway.id())
 *                     .role("slave")
 *                     .tunnelBgpConfig(ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
 *                         .localAsn("1219002")
 *                         .localBgpIp("169.254.40.1")
 *                         .tunnelCidr("169.254.40.0/30")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   spec:
 *     type: string
 *     default: '5'
 * resources:
 *   HA-VPN:
 *     type: alicloud:vpn:Gateway
 *     properties:
 *       vpnType: Normal
 *       disasterRecoveryVswitchId: ${default1.ids[0]}
 *       vpnGatewayName: ${name}
 *       vswitchId: ${default0.ids[0]}
 *       autoPay: true
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       networkType: public
 *       paymentType: Subscription
 *       enableIpsec: true
 *       bandwidth: ${spec}
 *   defaultCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: defaultCustomerGateway
 *       ipAddress: 2.2.2.5
 *       asn: '2224'
 *       customerGatewayName: ${name}
 *   changeCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: changeCustomerGateway
 *       ipAddress: 2.2.2.6
 *       asn: '2225'
 *       customerGatewayName: ${name}
 *   defaultConnection:
 *     type: alicloud:vpn:Connection
 *     name: default
 *     properties:
 *       vpnGatewayId: ${["HA-VPN"].id}
 *       vpnConnectionName: ${name}
 *       localSubnets:
 *         - 3.0.0.0/24
 *       remoteSubnets:
 *         - 10.0.0.0/24
 *         - 10.0.1.0/24
 *       tags:
 *         Created: TF
 *         For: example
 *       enableTunnelsBgp: 'true'
 *       tunnelOptionsSpecifications:
 *         - tunnelIpsecConfig:
 *             ipsecAuthAlg: md5
 *             ipsecEncAlg: aes256
 *             ipsecLifetime: '16400'
 *             ipsecPfs: group5
 *           customerGatewayId: ${defaultCustomerGateway.id}
 *           role: master
 *           tunnelBgpConfig:
 *             localAsn: '1219002'
 *             tunnelCidr: 169.254.30.0/30
 *             localBgpIp: 169.254.30.1
 *           tunnelIkeConfig:
 *             ikeMode: aggressive
 *             ikeVersion: ikev2
 *             localId: localid_tunnel2
 *             psk: '12345678'
 *             remoteId: remote2
 *             ikeAuthAlg: md5
 *             ikeEncAlg: aes256
 *             ikeLifetime: '3600'
 *             ikePfs: group14
 *         - tunnelIkeConfig:
 *             remoteId: remote24
 *             ikeEncAlg: aes256
 *             ikeLifetime: '27000'
 *             ikeMode: aggressive
 *             ikePfs: group5
 *             ikeAuthAlg: md5
 *             ikeVersion: ikev2
 *             localId: localid_tunnel2
 *             psk: '12345678'
 *           tunnelIpsecConfig:
 *             ipsecLifetime: '2700'
 *             ipsecPfs: group14
 *             ipsecAuthAlg: md5
 *             ipsecEncAlg: aes256
 *           customerGatewayId: ${defaultCustomerGateway.id}
 *           role: slave
 *           tunnelBgpConfig:
 *             localAsn: '1219002'
 *             localBgpIp: 169.254.40.1
 *             tunnelCidr: 169.254.40.0/30
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpn:getGatewayZones
 *       Arguments:
 *         spec: 5M
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 172.16.0.0/16
 *   default0:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 *   default1:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[1]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/connection:Connection example <id>
 * ```
 * @property autoConfigRoute Whether to configure routing automatically. Value:
 * - **true**: Automatically configure routes.
 * - **false**: does not automatically configure routes.
 * @property bgpConfig vpnBgp configuration. See `bgp_config` below.
 * @property customerGatewayId The ID of the customer gateway.
 * @property effectImmediately Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
 * @property enableDpd Wether enable Dpd detection.
 * @property enableNatTraversal enable nat traversal.
 * @property enableTunnelsBgp Enable tunnel bgp.
 * @property healthCheckConfig Health Check information. See `health_check_config` below.
 * @property ikeConfig The configuration of Phase 1 negotiations. See `ike_config` below.
 * @property ipsecConfig IPsec configuration. See `ipsec_config` below.
 * @property localSubnets The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
 * @property name . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
 * @property networkType The network type of the IPsec connection. Value:
 * - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
 * - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
 * @property remoteSubnets The CIDR block of the local data center. This parameter is used for phase-two negotiation.
 * @property tags Tags.
 * @property tunnelOptionsSpecifications The tunnel options of IPsec. See `tunnel_options_specification` below.
 * @property vpnConnectionName The name of the IPsec-VPN connection.
 * @property vpnGatewayId The ID of the VPN gateway.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class ConnectionArgs(
    public val autoConfigRoute: Output<Boolean>? = null,
    public val bgpConfig: Output<ConnectionBgpConfigArgs>? = null,
    public val customerGatewayId: Output<String>? = null,
    public val effectImmediately: Output<Boolean>? = null,
    public val enableDpd: Output<Boolean>? = null,
    public val enableNatTraversal: Output<Boolean>? = null,
    public val enableTunnelsBgp: Output<Boolean>? = null,
    public val healthCheckConfig: Output<ConnectionHealthCheckConfigArgs>? = null,
    public val ikeConfig: Output<ConnectionIkeConfigArgs>? = null,
    public val ipsecConfig: Output<ConnectionIpsecConfigArgs>? = null,
    public val localSubnets: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val remoteSubnets: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tunnelOptionsSpecifications: Output<List<ConnectionTunnelOptionsSpecificationArgs>>? =
        null,
    public val vpnConnectionName: Output<String>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.ConnectionArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.ConnectionArgs =
        com.pulumi.alicloud.vpn.ConnectionArgs.builder()
            .autoConfigRoute(autoConfigRoute?.applyValue({ args0 -> args0 }))
            .bgpConfig(bgpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerGatewayId(customerGatewayId?.applyValue({ args0 -> args0 }))
            .effectImmediately(effectImmediately?.applyValue({ args0 -> args0 }))
            .enableDpd(enableDpd?.applyValue({ args0 -> args0 }))
            .enableNatTraversal(enableNatTraversal?.applyValue({ args0 -> args0 }))
            .enableTunnelsBgp(enableTunnelsBgp?.applyValue({ args0 -> args0 }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ikeConfig(ikeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipsecConfig(ipsecConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localSubnets(localSubnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .remoteSubnets(remoteSubnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tunnelOptionsSpecifications(
                tunnelOptionsSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnConnectionName(vpnConnectionName?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var autoConfigRoute: Output<Boolean>? = null

    private var bgpConfig: Output<ConnectionBgpConfigArgs>? = null

    private var customerGatewayId: Output<String>? = null

    private var effectImmediately: Output<Boolean>? = null

    private var enableDpd: Output<Boolean>? = null

    private var enableNatTraversal: Output<Boolean>? = null

    private var enableTunnelsBgp: Output<Boolean>? = null

    private var healthCheckConfig: Output<ConnectionHealthCheckConfigArgs>? = null

    private var ikeConfig: Output<ConnectionIkeConfigArgs>? = null

    private var ipsecConfig: Output<ConnectionIpsecConfigArgs>? = null

    private var localSubnets: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var networkType: Output<String>? = null

    private var remoteSubnets: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tunnelOptionsSpecifications: Output<List<ConnectionTunnelOptionsSpecificationArgs>>? =
        null

    private var vpnConnectionName: Output<String>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value Whether to configure routing automatically. Value:
     * - **true**: Automatically configure routes.
     * - **false**: does not automatically configure routes.
     */
    @JvmName("ejabdqkuicqbhvdy")
    public suspend fun autoConfigRoute(`value`: Output<Boolean>) {
        this.autoConfigRoute = value
    }

    /**
     * @param value vpnBgp configuration. See `bgp_config` below.
     */
    @JvmName("ttiqtxcbmrtspdjk")
    public suspend fun bgpConfig(`value`: Output<ConnectionBgpConfigArgs>) {
        this.bgpConfig = value
    }

    /**
     * @param value The ID of the customer gateway.
     */
    @JvmName("isautvdnxwcjmnvd")
    public suspend fun customerGatewayId(`value`: Output<String>) {
        this.customerGatewayId = value
    }

    /**
     * @param value Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
     */
    @JvmName("dwpomxasggvyrdjx")
    public suspend fun effectImmediately(`value`: Output<Boolean>) {
        this.effectImmediately = value
    }

    /**
     * @param value Wether enable Dpd detection.
     */
    @JvmName("rgkcdohpynudddjl")
    public suspend fun enableDpd(`value`: Output<Boolean>) {
        this.enableDpd = value
    }

    /**
     * @param value enable nat traversal.
     */
    @JvmName("pysfabyvkwsjxbqt")
    public suspend fun enableNatTraversal(`value`: Output<Boolean>) {
        this.enableNatTraversal = value
    }

    /**
     * @param value Enable tunnel bgp.
     */
    @JvmName("gadcbxoepbbnsimd")
    public suspend fun enableTunnelsBgp(`value`: Output<Boolean>) {
        this.enableTunnelsBgp = value
    }

    /**
     * @param value Health Check information. See `health_check_config` below.
     */
    @JvmName("qaygliockirulmcd")
    public suspend fun healthCheckConfig(`value`: Output<ConnectionHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("wutripfknuhyqjoq")
    public suspend fun ikeConfig(`value`: Output<ConnectionIkeConfigArgs>) {
        this.ikeConfig = value
    }

    /**
     * @param value IPsec configuration. See `ipsec_config` below.
     */
    @JvmName("qwbnuahiumhridna")
    public suspend fun ipsecConfig(`value`: Output<ConnectionIpsecConfigArgs>) {
        this.ipsecConfig = value
    }

    /**
     * @param value The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("fheixfciretkyflp")
    public suspend fun localSubnets(`value`: Output<List<String>>) {
        this.localSubnets = value
    }

    @JvmName("iqgksnqwpwycjlrb")
    public suspend fun localSubnets(vararg values: Output<String>) {
        this.localSubnets = Output.all(values.asList())
    }

    /**
     * @param values The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("khptdvicqkbthdpd")
    public suspend fun localSubnets(values: List<Output<String>>) {
        this.localSubnets = Output.all(values)
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name'
      instead.
  """,
    )
    @JvmName("gncuakyalpxnxkef")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network type of the IPsec connection. Value:
     * - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
     * - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
     */
    @JvmName("hbgbufruhvdgiewe")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The CIDR block of the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("evyvfluabeiwkdjx")
    public suspend fun remoteSubnets(`value`: Output<List<String>>) {
        this.remoteSubnets = value
    }

    @JvmName("atuqodcckklrtrsw")
    public suspend fun remoteSubnets(vararg values: Output<String>) {
        this.remoteSubnets = Output.all(values.asList())
    }

    /**
     * @param values The CIDR block of the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("ksxqpcdrrftbwikk")
    public suspend fun remoteSubnets(values: List<Output<String>>) {
        this.remoteSubnets = Output.all(values)
    }

    /**
     * @param value Tags.
     */
    @JvmName("glyltcwhcjyrdjvy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("tkkqwmtbxeqhtyyn")
    public suspend fun tunnelOptionsSpecifications(`value`: Output<List<ConnectionTunnelOptionsSpecificationArgs>>) {
        this.tunnelOptionsSpecifications = value
    }

    @JvmName("fcyuxaiwwmcjhqtl")
    public suspend fun tunnelOptionsSpecifications(vararg values: Output<ConnectionTunnelOptionsSpecificationArgs>) {
        this.tunnelOptionsSpecifications = Output.all(values.asList())
    }

    /**
     * @param values The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("rqxjgaxuqxxqhkdd")
    public suspend fun tunnelOptionsSpecifications(values: List<Output<ConnectionTunnelOptionsSpecificationArgs>>) {
        this.tunnelOptionsSpecifications = Output.all(values)
    }

    /**
     * @param value The name of the IPsec-VPN connection.
     */
    @JvmName("ryymeahaxvjbkhlp")
    public suspend fun vpnConnectionName(`value`: Output<String>) {
        this.vpnConnectionName = value
    }

    /**
     * @param value The ID of the VPN gateway.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("hitgyuercwfscxhb")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value Whether to configure routing automatically. Value:
     * - **true**: Automatically configure routes.
     * - **false**: does not automatically configure routes.
     */
    @JvmName("sthltwyuxynotknt")
    public suspend fun autoConfigRoute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoConfigRoute = mapped
    }

    /**
     * @param value vpnBgp configuration. See `bgp_config` below.
     */
    @JvmName("qalhenhfvyacqyta")
    public suspend fun bgpConfig(`value`: ConnectionBgpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpConfig = mapped
    }

    /**
     * @param argument vpnBgp configuration. See `bgp_config` below.
     */
    @JvmName("pjvjpygpxebmuhgi")
    public suspend fun bgpConfig(argument: suspend ConnectionBgpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionBgpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpConfig = mapped
    }

    /**
     * @param value The ID of the customer gateway.
     */
    @JvmName("mceertgsbmafjjsg")
    public suspend fun customerGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerGatewayId = mapped
    }

    /**
     * @param value Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
     */
    @JvmName("vrggbapvnlfvwwqh")
    public suspend fun effectImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectImmediately = mapped
    }

    /**
     * @param value Wether enable Dpd detection.
     */
    @JvmName("lparstxxjflwqysx")
    public suspend fun enableDpd(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDpd = mapped
    }

    /**
     * @param value enable nat traversal.
     */
    @JvmName("jeqqxwqtxwpctkgc")
    public suspend fun enableNatTraversal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNatTraversal = mapped
    }

    /**
     * @param value Enable tunnel bgp.
     */
    @JvmName("whlfheosnmtmarpd")
    public suspend fun enableTunnelsBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTunnelsBgp = mapped
    }

    /**
     * @param value Health Check information. See `health_check_config` below.
     */
    @JvmName("mllbytylggmwpsmn")
    public suspend fun healthCheckConfig(`value`: ConnectionHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument Health Check information. See `health_check_config` below.
     */
    @JvmName("jvsgnybtopawnblk")
    public suspend fun healthCheckConfig(argument: suspend ConnectionHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionHealthCheckConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("nliqusyhlaqocekl")
    public suspend fun ikeConfig(`value`: ConnectionIkeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeConfig = mapped
    }

    /**
     * @param argument The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("kbxkqpsexnhpuckt")
    public suspend fun ikeConfig(argument: suspend ConnectionIkeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionIkeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ikeConfig = mapped
    }

    /**
     * @param value IPsec configuration. See `ipsec_config` below.
     */
    @JvmName("kddrilpvqtctayal")
    public suspend fun ipsecConfig(`value`: ConnectionIpsecConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecConfig = mapped
    }

    /**
     * @param argument IPsec configuration. See `ipsec_config` below.
     */
    @JvmName("acluhfrdrqerbmod")
    public suspend fun ipsecConfig(argument: suspend ConnectionIpsecConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionIpsecConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipsecConfig = mapped
    }

    /**
     * @param value The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("kineexgpshvkyhiq")
    public suspend fun localSubnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localSubnets = mapped
    }

    /**
     * @param values The CIDR block of the VPC to be connected with the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("dngimhjwrjpcyvkb")
    public suspend fun localSubnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localSubnets = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_connection_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.216.0. New field 'vpn_connection_name'
      instead.
  """,
    )
    @JvmName("wditbnsopppvnfij")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network type of the IPsec connection. Value:
     * - **public**: public network, indicating that the IPsec connection establishes an encrypted communication channel through the public network.
     * - **private**: private network, indicating that the IPsec connection establishes an encrypted communication channel through the private network.
     */
    @JvmName("trihqvsuqluwaaxs")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The CIDR block of the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("vyfwrcpcgttgdeye")
    public suspend fun remoteSubnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteSubnets = mapped
    }

    /**
     * @param values The CIDR block of the local data center. This parameter is used for phase-two negotiation.
     */
    @JvmName("nlqkbuumtawwgltb")
    public suspend fun remoteSubnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteSubnets = mapped
    }

    /**
     * @param value Tags.
     */
    @JvmName("jwhfrnbqkhqbjvdu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags.
     */
    @JvmName("tjdsqbpxhledjjwd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("ydjuoxyfyegylufc")
    public suspend fun tunnelOptionsSpecifications(`value`: List<ConnectionTunnelOptionsSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelOptionsSpecifications = mapped
    }

    /**
     * @param argument The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("fyaabkqbkbjdrxql")
    public suspend fun tunnelOptionsSpecifications(argument: List<suspend ConnectionTunnelOptionsSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionTunnelOptionsSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tunnelOptionsSpecifications = mapped
    }

    /**
     * @param argument The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("vqejopgvnpubhygr")
    public suspend fun tunnelOptionsSpecifications(vararg argument: suspend ConnectionTunnelOptionsSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionTunnelOptionsSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tunnelOptionsSpecifications = mapped
    }

    /**
     * @param argument The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("ylxbmgexmamtohxv")
    public suspend fun tunnelOptionsSpecifications(argument: suspend ConnectionTunnelOptionsSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionTunnelOptionsSpecificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tunnelOptionsSpecifications = mapped
    }

    /**
     * @param values The tunnel options of IPsec. See `tunnel_options_specification` below.
     */
    @JvmName("xlcugxmlhrbtgkpe")
    public suspend fun tunnelOptionsSpecifications(vararg values: ConnectionTunnelOptionsSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tunnelOptionsSpecifications = mapped
    }

    /**
     * @param value The name of the IPsec-VPN connection.
     */
    @JvmName("ulgyuiwjkfwwoaae")
    public suspend fun vpnConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionName = mapped
    }

    /**
     * @param value The ID of the VPN gateway.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("bsjxrgfqgorxabaa")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        autoConfigRoute = autoConfigRoute,
        bgpConfig = bgpConfig,
        customerGatewayId = customerGatewayId,
        effectImmediately = effectImmediately,
        enableDpd = enableDpd,
        enableNatTraversal = enableNatTraversal,
        enableTunnelsBgp = enableTunnelsBgp,
        healthCheckConfig = healthCheckConfig,
        ikeConfig = ikeConfig,
        ipsecConfig = ipsecConfig,
        localSubnets = localSubnets,
        name = name,
        networkType = networkType,
        remoteSubnets = remoteSubnets,
        tags = tags,
        tunnelOptionsSpecifications = tunnelOptionsSpecifications,
        vpnConnectionName = vpnConnectionName,
        vpnGatewayId = vpnGatewayId,
    )
}
