@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CustomerGateway].
 */
@PulumiTagMarker
public class CustomerGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomerGatewayArgs = CustomerGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomerGatewayArgsBuilder.() -> Unit) {
        val builder = CustomerGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomerGateway {
        val builtJavaResource = com.pulumi.alicloud.vpn.CustomerGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomerGateway(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpn.CustomerGateway("default", {
 *     description: name,
 *     ipAddress: "4.3.2.10",
 *     asn: "1219002",
 *     customerGatewayName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpn.CustomerGateway("default",
 *     description=name,
 *     ip_address="4.3.2.10",
 *     asn="1219002",
 *     customer_gateway_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpn.CustomerGateway("default", new()
 *     {
 *         Description = name,
 *         IpAddress = "4.3.2.10",
 *         Asn = "1219002",
 *         CustomerGatewayName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpn.NewCustomerGateway(ctx, "default", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String(name),
 * 			IpAddress:           pulumi.String("4.3.2.10"),
 * 			Asn:                 pulumi.String("1219002"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new CustomerGateway("default", CustomerGatewayArgs.builder()
 *             .description(name)
 *             .ipAddress("4.3.2.10")
 *             .asn("1219002")
 *             .customerGatewayName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: ${name}
 *       ipAddress: 4.3.2.10
 *       asn: '1219002'
 *       customerGatewayName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN customer gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/customerGateway:CustomerGateway example <id>
 * ```
 */
public class CustomerGateway internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.CustomerGateway,
) : KotlinCustomResource(javaResource, CustomerGatewayMapper) {
    /**
     * Asn.
     */
    public val asn: Output<String>?
        get() = javaResource.asn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time when the customer gateway was created.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The name of the customer gateway.
     */
    public val customerGatewayName: Output<String>
        get() = javaResource.customerGatewayName().applyValue({ args0 -> args0 })

    /**
     * The description of the customer gateway.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP address of the customer gateway.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * . Field 'name' has been deprecated from provider version 1.216.0. New field 'customer_gateway_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.210.0. New field 'customer_gateway_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object CustomerGatewayMapper : ResourceMapper<CustomerGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.CustomerGateway::class == javaResource::class

    override fun map(javaResource: Resource): CustomerGateway = CustomerGateway(
        javaResource as
            com.pulumi.alicloud.vpn.CustomerGateway,
    )
}

/**
 * @see [CustomerGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomerGateway].
 */
public suspend fun customerGateway(
    name: String,
    block: suspend CustomerGatewayResourceBuilder.() -> Unit,
): CustomerGateway {
    val builder = CustomerGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomerGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customerGateway(name: String): CustomerGateway {
    val builder = CustomerGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
