@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.CustomerGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpn.CustomerGateway("default", {
 *     description: name,
 *     ipAddress: "4.3.2.10",
 *     asn: "1219002",
 *     customerGatewayName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpn.CustomerGateway("default",
 *     description=name,
 *     ip_address="4.3.2.10",
 *     asn="1219002",
 *     customer_gateway_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpn.CustomerGateway("default", new()
 *     {
 *         Description = name,
 *         IpAddress = "4.3.2.10",
 *         Asn = "1219002",
 *         CustomerGatewayName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpn.NewCustomerGateway(ctx, "default", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String(name),
 * 			IpAddress:           pulumi.String("4.3.2.10"),
 * 			Asn:                 pulumi.String("1219002"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new CustomerGateway("default", CustomerGatewayArgs.builder()
 *             .description(name)
 *             .ipAddress("4.3.2.10")
 *             .asn("1219002")
 *             .customerGatewayName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: ${name}
 *       ipAddress: 4.3.2.10
 *       asn: '1219002'
 *       customerGatewayName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN customer gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/customerGateway:CustomerGateway example <id>
 * ```
 * @property asn Asn.
 * @property customerGatewayName The name of the customer gateway.
 * @property description The description of the customer gateway.
 * @property ipAddress The IP address of the customer gateway.
 * @property name . Field 'name' has been deprecated from provider version 1.216.0. New field 'customer_gateway_name' instead.
 * @property tags tag.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class CustomerGatewayArgs(
    public val asn: Output<String>? = null,
    public val customerGatewayName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.210.0. New field 'customer_gateway_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.CustomerGatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.CustomerGatewayArgs =
        com.pulumi.alicloud.vpn.CustomerGatewayArgs.builder()
            .asn(asn?.applyValue({ args0 -> args0 }))
            .customerGatewayName(customerGatewayName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomerGatewayArgs].
 */
@PulumiTagMarker
public class CustomerGatewayArgsBuilder internal constructor() {
    private var asn: Output<String>? = null

    private var customerGatewayName: Output<String>? = null

    private var description: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Asn.
     */
    @JvmName("xsjalkiacoflcyau")
    public suspend fun asn(`value`: Output<String>) {
        this.asn = value
    }

    /**
     * @param value The name of the customer gateway.
     */
    @JvmName("rjyedkxyfpmjmwtd")
    public suspend fun customerGatewayName(`value`: Output<String>) {
        this.customerGatewayName = value
    }

    /**
     * @param value The description of the customer gateway.
     */
    @JvmName("xtwrrunkxbpjqfgw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The IP address of the customer gateway.
     */
    @JvmName("cltojlxuhoqjoutg")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.216.0. New field 'customer_gateway_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.210.0. New field 'customer_gateway_name'
      instead.
  """,
    )
    @JvmName("fmlgcgnausutcnqa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("qnqypnasynmcfoee")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Asn.
     */
    @JvmName("danykfqnbiirdcjv")
    public suspend fun asn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asn = mapped
    }

    /**
     * @param value The name of the customer gateway.
     */
    @JvmName("tpuedfomhlqfjeib")
    public suspend fun customerGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerGatewayName = mapped
    }

    /**
     * @param value The description of the customer gateway.
     */
    @JvmName("pgfdqnmjovkvltfq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The IP address of the customer gateway.
     */
    @JvmName("gstrhmwfwgqggqds")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.216.0. New field 'customer_gateway_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.210.0. New field 'customer_gateway_name'
      instead.
  """,
    )
    @JvmName("qyrnhdxcseiolwlk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("rbhqkrxefixbjrva")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("lyjqgvxwjxfxgvhj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomerGatewayArgs = CustomerGatewayArgs(
        asn = asn,
        customerGatewayName = customerGatewayName,
        description = description,
        ipAddress = ipAddress,
        name = name,
        tags = tags,
    )
}
