@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.alicloud.vpn.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * VPN gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/gateway:Gateway example <id>
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * Whether to pay automatically. Default value: `true`. Valid values:
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
     */
    public val autoPropagate: Output<Boolean>?
        get() = javaResource.autoPropagate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The business status of the VPN gateway.
     */
    public val businessStatus: Output<String>
        get() = javaResource.businessStatus().applyValue({ args0 -> args0 })

    /**
     * The time when the VPN gateway was created.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the VPN gateway.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
     */
    public val disasterRecoveryInternetIp: Output<String>
        get() = javaResource.disasterRecoveryInternetIp().applyValue({ args0 -> args0 })

    /**
     * The ID of the backup VSwitch to which the VPN gateway is attached.
     */
    public val disasterRecoveryVswitchId: Output<String>
        get() = javaResource.disasterRecoveryVswitchId().applyValue({ args0 -> args0 })

    /**
     * Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
     */
    public val enableIpsec: Output<Boolean>?
        get() = javaResource.enableIpsec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val enableSsl: Output<Boolean>?
        get() = javaResource.enableSsl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field
      'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * The internet ip of the VPN.
     */
    public val internetIp: Output<String>
        get() = javaResource.internetIp().applyValue({ args0 -> args0 })

    /**
     * . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Maximum number of clients.
     */
    public val sslConnections: Output<Int>
        get() = javaResource.sslConnections().applyValue({ args0 -> args0 })

    /**
     * The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
     */
    public val sslVpnInternetIp: Output<String>
        get() = javaResource.sslVpnInternetIp().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The Tag of.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the VPC to which the VPN gateway belongs.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The name of the VPN gateway.
     */
    public val vpnGatewayName: Output<String>
        get() = javaResource.vpnGatewayName().applyValue({ args0 -> args0 })

    /**
     * The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
     */
    public val vpnType: Output<String>
        get() = javaResource.vpnType().applyValue({ args0 -> args0 })

    /**
     * The ID of the VSwitch to which the VPN gateway is attached.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.alicloud.vpn.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
