@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * VPN gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/gateway:Gateway example <id>
 * ```
 * @property autoPay Whether to pay automatically. Default value: `true`. Valid values:
 * @property autoPropagate Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
 * @property bandwidth The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
 * @property description The description of the VPN gateway.
 * @property disasterRecoveryVswitchId The ID of the backup VSwitch to which the VPN gateway is attached.
 * @property enableIpsec Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
 * @property enableSsl Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 * @property instanceChargeType . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
 * @property name . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
 * @property networkType The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
 * @property paymentType Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
 * @property period The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
 * @property resourceGroupId The ID of the resource group.
 * @property sslConnections Maximum number of clients.
 * @property tags The Tag of.
 * @property vpcId The ID of the VPC to which the VPN gateway belongs.
 * @property vpnGatewayName The name of the VPN gateway.
 * @property vpnType The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
 * @property vswitchId The ID of the VSwitch to which the VPN gateway is attached.
 */
public data class GatewayArgs(
    public val autoPay: Output<Boolean>? = null,
    public val autoPropagate: Output<Boolean>? = null,
    public val bandwidth: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val disasterRecoveryVswitchId: Output<String>? = null,
    public val enableIpsec: Output<Boolean>? = null,
    public val enableSsl: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field
      'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sslConnections: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vpnGatewayName: Output<String>? = null,
    public val vpnType: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.GatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.GatewayArgs =
        com.pulumi.alicloud.vpn.GatewayArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoPropagate(autoPropagate?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disasterRecoveryVswitchId(disasterRecoveryVswitchId?.applyValue({ args0 -> args0 }))
            .enableIpsec(enableIpsec?.applyValue({ args0 -> args0 }))
            .enableSsl(enableSsl?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sslConnections(sslConnections?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpnGatewayName(vpnGatewayName?.applyValue({ args0 -> args0 }))
            .vpnType(vpnType?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var autoPropagate: Output<Boolean>? = null

    private var bandwidth: Output<Int>? = null

    private var description: Output<String>? = null

    private var disasterRecoveryVswitchId: Output<String>? = null

    private var enableIpsec: Output<Boolean>? = null

    private var enableSsl: Output<Boolean>? = null

    private var instanceChargeType: Output<String>? = null

    private var name: Output<String>? = null

    private var networkType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var sslConnections: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vpnGatewayName: Output<String>? = null

    private var vpnType: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Whether to pay automatically. Default value: `true`. Valid values:
     */
    @JvmName("ymhaflurwnwqoqfd")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
     */
    @JvmName("dxjqdcfxhscuelte")
    public suspend fun autoPropagate(`value`: Output<Boolean>) {
        this.autoPropagate = value
    }

    /**
     * @param value The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
     */
    @JvmName("bkwrkcctojycdisj")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The description of the VPN gateway.
     */
    @JvmName("mmqulfvetgwflnfh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the backup VSwitch to which the VPN gateway is attached.
     */
    @JvmName("foajgwrdgasgarxl")
    public suspend fun disasterRecoveryVswitchId(`value`: Output<String>) {
        this.disasterRecoveryVswitchId = value
    }

    /**
     * @param value Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
     */
    @JvmName("cnkncylfxklrgboe")
    public suspend fun enableIpsec(`value`: Output<Boolean>) {
        this.enableIpsec = value
    }

    /**
     * @param value Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("hregtncdflylalrk")
    public suspend fun enableSsl(`value`: Output<Boolean>) {
        this.enableSsl = value
    }

    /**
     * @param value . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field
      'payment_type' instead.
  """,
    )
    @JvmName("ideorlphddnhragd")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name'
      instead.
  """,
    )
    @JvmName("vepkxhpeuxnfyxxp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
     */
    @JvmName("vssxhaptuphbkrrt")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
     */
    @JvmName("rqxgkgodljkqcxuf")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
     */
    @JvmName("mqiplrnkdkdotjhv")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("tnqmpfmduonygdbt")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Maximum number of clients.
     */
    @JvmName("bmjvdbyixlwaosct")
    public suspend fun sslConnections(`value`: Output<Int>) {
        this.sslConnections = value
    }

    /**
     * @param value The Tag of.
     */
    @JvmName("haltjrgjvqfhdckp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC to which the VPN gateway belongs.
     */
    @JvmName("apntjkivgyogqfma")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The name of the VPN gateway.
     */
    @JvmName("hvhytakcnnhgnyau")
    public suspend fun vpnGatewayName(`value`: Output<String>) {
        this.vpnGatewayName = value
    }

    /**
     * @param value The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
     */
    @JvmName("wkrdauqfvuuwjbgv")
    public suspend fun vpnType(`value`: Output<String>) {
        this.vpnType = value
    }

    /**
     * @param value The ID of the VSwitch to which the VPN gateway is attached.
     */
    @JvmName("rngvsopvhbtrhmcf")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Whether to pay automatically. Default value: `true`. Valid values:
     */
    @JvmName("rpdjucmuovrbribv")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Whether to automatically propagate the BGP route to the VPC. Value:  true: Propagate automatically.  false: does not propagate automatically.
     */
    @JvmName("vukbscexsugyxkre")
    public suspend fun autoPropagate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPropagate = mapped
    }

    /**
     * @param value The Bandwidth specification of the VPN gateway. Unit: Mbps.  If you want to create a public VPN gateway, the value is 5, 10, 20, 50, 100, 200, 500, or 1000. If you want to create a private VPN gateway, the value is 200 or 1000.
     */
    @JvmName("sypumshfqwbcvagn")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The description of the VPN gateway.
     */
    @JvmName("kmjagoeyggsgaopg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the backup VSwitch to which the VPN gateway is attached.
     */
    @JvmName("tpnlkjprwawvwixb")
    public suspend fun disasterRecoveryVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disasterRecoveryVswitchId = mapped
    }

    /**
     * @param value Enable or Disable IPSec VPN. At least one type of VPN should be enabled.
     */
    @JvmName("rmhemqrgbuiyswpf")
    public suspend fun enableIpsec(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpsec = mapped
    }

    /**
     * @param value Enable or Disable SSL VPN.  At least one type of VPN should be enabled.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("oopskkocjabesevw")
    public suspend fun enableSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsl = mapped
    }

    /**
     * @param value . Field 'instance_charge_type' has been deprecated from provider version 1.216.0. New field 'payment_type' instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.215.0. New field
      'payment_type' instead.
  """,
    )
    @JvmName("hvqmcbikkbcwnluu")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.216.0. New field 'vpn_gateway_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.215.0. New field 'vpn_gateway_name'
      instead.
  """,
    )
    @JvmName("tlhtyvhivbkskvwp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network type of the VPN gateway. Value:  public (default): public VPN gateway. private: private network VPN gateway.
     */
    @JvmName("fpkoglfjichmlcjr")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value Type of payment. Value: Subscription: prepaid PayAsYouGo: Post-paid.
     */
    @JvmName("vhswadctsbrojfqt")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The filed is only required while the InstanceChargeType is PrePaid. Valid values: [1-9, 12, 24, 36]. Default to 1.
     */
    @JvmName("ewtanesdbotkusut")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("kjykxtyqbabgsjfa")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Maximum number of clients.
     */
    @JvmName("ggcnffgldhhslukw")
    public suspend fun sslConnections(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslConnections = mapped
    }

    /**
     * @param value The Tag of.
     */
    @JvmName("ebrlcaqgocsxqccs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The Tag of.
     */
    @JvmName("xvtdujjqcyhapdfo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC to which the VPN gateway belongs.
     */
    @JvmName("mwipmwnbcmjxwogl")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The name of the VPN gateway.
     */
    @JvmName("scasosdddxceexjx")
    public suspend fun vpnGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayName = mapped
    }

    /**
     * @param value The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
     */
    @JvmName("cxkskuyrgcxkenxh")
    public suspend fun vpnType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    /**
     * @param value The ID of the VSwitch to which the VPN gateway is attached.
     */
    @JvmName("mnuffnspneovmlxo")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        autoPay = autoPay,
        autoPropagate = autoPropagate,
        bandwidth = bandwidth,
        description = description,
        disasterRecoveryVswitchId = disasterRecoveryVswitchId,
        enableIpsec = enableIpsec,
        enableSsl = enableSsl,
        instanceChargeType = instanceChargeType,
        name = name,
        networkType = networkType,
        paymentType = paymentType,
        period = period,
        resourceGroupId = resourceGroupId,
        sslConnections = sslConnections,
        tags = tags,
        vpcId = vpcId,
        vpnGatewayName = vpnGatewayName,
        vpnType = vpnType,
        vswitchId = vswitchId,
    )
}
