@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayVcoRoute].
 */
@PulumiTagMarker
public class GatewayVcoRouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayVcoRouteArgs = GatewayVcoRouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayVcoRouteArgsBuilder.() -> Unit) {
        val builder = GatewayVcoRouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayVcoRoute {
        val builtJavaResource = com.pulumi.alicloud.vpn.GatewayVcoRoute(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GatewayVcoRoute(builtJavaResource)
    }
}

/**
 * Provides a VPN Gateway Vco Route resource.
 * For information about VPN Gateway Vco Route and how to use it, see [What is Vco Route](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvcorouteentry).
 * > **NOTE:** Available in v1.183.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const defaultInstance = new alicloud.cen.Instance("default", {cenInstanceName: name});
 * const defaultTransitRouter = new alicloud.cen.TransitRouter("default", {
 *     cenId: defaultInstance.id,
 *     transitRouterDescription: "desd",
 *     transitRouterName: name,
 * });
 * const default = alicloud.cen.getTransitRouterAvailableResources({});
 * const defaultCustomerGateway = new alicloud.vpn.CustomerGateway("default", {
 *     name: name,
 *     ipAddress: "42.104.22.210",
 *     asn: "45014",
 *     description: "testAccVpnConnectionDesc",
 * });
 * const defaultGatewayVpnAttachment = new alicloud.vpn.GatewayVpnAttachment("default", {
 *     customerGatewayId: defaultCustomerGateway.id,
 *     networkType: "public",
 *     localSubnet: "0.0.0.0/0",
 *     remoteSubnet: "0.0.0.0/0",
 *     effectImmediately: false,
 *     ikeConfig: {
 *         ikeAuthAlg: "md5",
 *         ikeEncAlg: "des",
 *         ikeVersion: "ikev2",
 *         ikeMode: "main",
 *         ikeLifetime: 86400,
 *         psk: "tf-testvpn2",
 *         ikePfs: "group1",
 *         remoteId: "testbob2",
 *         localId: "testalice2",
 *     },
 *     ipsecConfig: {
 *         ipsecPfs: "group5",
 *         ipsecEncAlg: "des",
 *         ipsecAuthAlg: "md5",
 *         ipsecLifetime: 86400,
 *     },
 *     bgpConfig: {
 *         enable: true,
 *         localAsn: 45014,
 *         tunnelCidr: "169.254.11.0/30",
 *         localBgpIp: "169.254.11.1",
 *     },
 *     healthCheckConfig: {
 *         enable: true,
 *         sip: "192.168.1.1",
 *         dip: "10.0.0.1",
 *         interval: 10,
 *         retry: 10,
 *         policy: "revoke_route",
 *     },
 *     enableDpd: true,
 *     enableNatTraversal: true,
 *     vpnAttachmentName: name,
 * });
 * const defaultTransitRouterVpnAttachment = new alicloud.cen.TransitRouterVpnAttachment("default", {
 *     autoPublishRouteEnabled: false,
 *     transitRouterAttachmentDescription: name,
 *     transitRouterAttachmentName: name,
 *     cenId: defaultTransitRouter.cenId,
 *     transitRouterId: defaultTransitRouter.transitRouterId,
 *     vpnId: defaultGatewayVpnAttachment.id,
 *     zones: [{
 *         zoneId: _default.then(_default => _default.resources?.[0]?&#46;masterZones?&#46;[0]),
 *     }],
 * });
 * const defaultGatewayVcoRoute = new alicloud.vpn.GatewayVcoRoute("default", {
 *     routeDest: "192.168.12.0/24",
 *     nextHop: defaultTransitRouterVpnAttachment.vpnId,
 *     vpnConnectionId: defaultTransitRouterVpnAttachment.vpnId,
 *     weight: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
 * default_transit_router = alicloud.cen.TransitRouter("default",
 *     cen_id=default_instance.id,
 *     transit_router_description="desd",
 *     transit_router_name=name)
 * default = alicloud.cen.get_transit_router_available_resources()
 * default_customer_gateway = alicloud.vpn.CustomerGateway("default",
 *     name=name,
 *     ip_address="42.104.22.210",
 *     asn="45014",
 *     description="testAccVpnConnectionDesc")
 * default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
 *     customer_gateway_id=default_customer_gateway.id,
 *     network_type="public",
 *     local_subnet="0.0.0.0/0",
 *     remote_subnet="0.0.0.0/0",
 *     effect_immediately=False,
 *     ike_config={
 *         "ike_auth_alg": "md5",
 *         "ike_enc_alg": "des",
 *         "ike_version": "ikev2",
 *         "ike_mode": "main",
 *         "ike_lifetime": 86400,
 *         "psk": "tf-testvpn2",
 *         "ike_pfs": "group1",
 *         "remote_id": "testbob2",
 *         "local_id": "testalice2",
 *     },
 *     ipsec_config={
 *         "ipsec_pfs": "group5",
 *         "ipsec_enc_alg": "des",
 *         "ipsec_auth_alg": "md5",
 *         "ipsec_lifetime": 86400,
 *     },
 *     bgp_config={
 *         "enable": True,
 *         "local_asn": 45014,
 *         "tunnel_cidr": "169.254.11.0/30",
 *         "local_bgp_ip": "169.254.11.1",
 *     },
 *     health_check_config={
 *         "enable": True,
 *         "sip": "192.168.1.1",
 *         "dip": "10.0.0.1",
 *         "interval": 10,
 *         "retry": 10,
 *         "policy": "revoke_route",
 *     },
 *     enable_dpd=True,
 *     enable_nat_traversal=True,
 *     vpn_attachment_name=name)
 * default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
 *     auto_publish_route_enabled=False,
 *     transit_router_attachment_description=name,
 *     transit_router_attachment_name=name,
 *     cen_id=default_transit_router.cen_id,
 *     transit_router_id=default_transit_router.transit_router_id,
 *     vpn_id=default_gateway_vpn_attachment.id,
 *     zones=[{
 *         "zone_id": default.resources[0]&#46;master_zones[0],
 *     }])
 * default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("default",
 *     route_dest="192.168.12.0/24",
 *     next_hop=default_transit_router_vpn_attachment.vpn_id,
 *     vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
 *     weight=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultInstance = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = name,
 *     });
 *     var defaultTransitRouter = new AliCloud.Cen.TransitRouter("default", new()
 *     {
 *         CenId = defaultInstance.Id,
 *         TransitRouterDescription = "desd",
 *         TransitRouterName = name,
 *     });
 *     var @default = AliCloud.Cen.GetTransitRouterAvailableResources.Invoke();
 *     var defaultCustomerGateway = new AliCloud.Vpn.CustomerGateway("default", new()
 *     {
 *         Name = name,
 *         IpAddress = "42.104.22.210",
 *         Asn = "45014",
 *         Description = "testAccVpnConnectionDesc",
 *     });
 *     var defaultGatewayVpnAttachment = new AliCloud.Vpn.GatewayVpnAttachment("default", new()
 *     {
 *         CustomerGatewayId = defaultCustomerGateway.Id,
 *         NetworkType = "public",
 *         LocalSubnet = "0.0.0.0/0",
 *         RemoteSubnet = "0.0.0.0/0",
 *         EffectImmediately = false,
 *         IkeConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIkeConfigArgs
 *         {
 *             IkeAuthAlg = "md5",
 *             IkeEncAlg = "des",
 *             IkeVersion = "ikev2",
 *             IkeMode = "main",
 *             IkeLifetime = 86400,
 *             Psk = "tf-testvpn2",
 *             IkePfs = "group1",
 *             RemoteId = "testbob2",
 *             LocalId = "testalice2",
 *         },
 *         IpsecConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIpsecConfigArgs
 *         {
 *             IpsecPfs = "group5",
 *             IpsecEncAlg = "des",
 *             IpsecAuthAlg = "md5",
 *             IpsecLifetime = 86400,
 *         },
 *         BgpConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentBgpConfigArgs
 *         {
 *             Enable = true,
 *             LocalAsn = 45014,
 *             TunnelCidr = "169.254.11.0/30",
 *             LocalBgpIp = "169.254.11.1",
 *         },
 *         HealthCheckConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentHealthCheckConfigArgs
 *         {
 *             Enable = true,
 *             Sip = "192.168.1.1",
 *             Dip = "10.0.0.1",
 *             Interval = 10,
 *             Retry = 10,
 *             Policy = "revoke_route",
 *         },
 *         EnableDpd = true,
 *         EnableNatTraversal = true,
 *         VpnAttachmentName = name,
 *     });
 *     var defaultTransitRouterVpnAttachment = new AliCloud.Cen.TransitRouterVpnAttachment("default", new()
 *     {
 *         AutoPublishRouteEnabled = false,
 *         TransitRouterAttachmentDescription = name,
 *         TransitRouterAttachmentName = name,
 *         CenId = defaultTransitRouter.CenId,
 *         TransitRouterId = defaultTransitRouter.TransitRouterId,
 *         VpnId = defaultGatewayVpnAttachment.Id,
 *         Zones = new[]
 *         {
 *             new AliCloud.Cen.Inputs.TransitRouterVpnAttachmentZoneArgs
 *             {
 *                 ZoneId = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;MasterZones[0])),
 *             },
 *         },
 *     });
 *     var defaultGatewayVcoRoute = new AliCloud.Vpn.GatewayVcoRoute("default", new()
 *     {
 *         RouteDest = "192.168.12.0/24",
 *         NextHop = defaultTransitRouterVpnAttachment.VpnId,
 *         VpnConnectionId = defaultTransitRouterVpnAttachment.VpnId,
 *         Weight = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		defaultInstance, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.Any(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTransitRouter, err := cen.NewTransitRouter(ctx, "default", &cen.TransitRouterArgs{
 * 			CenId:                    defaultInstance.ID(),
 * 			TransitRouterDescription: pulumi.String("desd"),
 * 			TransitRouterName:        pulumi.Any(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := cen.GetTransitRouterAvailableResources(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCustomerGateway, err := vpn.NewCustomerGateway(ctx, "default", &vpn.CustomerGatewayArgs{
 * 			Name:        pulumi.Any(name),
 * 			IpAddress:   pulumi.String("42.104.22.210"),
 * 			Asn:         pulumi.String("45014"),
 * 			Description: pulumi.String("testAccVpnConnectionDesc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGatewayVpnAttachment, err := vpn.NewGatewayVpnAttachment(ctx, "default", &vpn.GatewayVpnAttachmentArgs{
 * 			CustomerGatewayId: defaultCustomerGateway.ID(),
 * 			NetworkType:       pulumi.String("public"),
 * 			LocalSubnet:       pulumi.String("0.0.0.0/0"),
 * 			RemoteSubnet:      pulumi.String("0.0.0.0/0"),
 * 			EffectImmediately: pulumi.Bool(false),
 * 			IkeConfig: &vpn.GatewayVpnAttachmentIkeConfigArgs{
 * 				IkeAuthAlg:  pulumi.String("md5"),
 * 				IkeEncAlg:   pulumi.String("des"),
 * 				IkeVersion:  pulumi.String("ikev2"),
 * 				IkeMode:     pulumi.String("main"),
 * 				IkeLifetime: pulumi.Int(86400),
 * 				Psk:         pulumi.String("tf-testvpn2"),
 * 				IkePfs:      pulumi.String("group1"),
 * 				RemoteId:    pulumi.String("testbob2"),
 * 				LocalId:     pulumi.String("testalice2"),
 * 			},
 * 			IpsecConfig: &vpn.GatewayVpnAttachmentIpsecConfigArgs{
 * 				IpsecPfs:      pulumi.String("group5"),
 * 				IpsecEncAlg:   pulumi.String("des"),
 * 				IpsecAuthAlg:  pulumi.String("md5"),
 * 				IpsecLifetime: pulumi.Int(86400),
 * 			},
 * 			BgpConfig: &vpn.GatewayVpnAttachmentBgpConfigArgs{
 * 				Enable:     pulumi.Bool(true),
 * 				LocalAsn:   pulumi.Int(45014),
 * 				TunnelCidr: pulumi.String("169.254.11.0/30"),
 * 				LocalBgpIp: pulumi.String("169.254.11.1"),
 * 			},
 * 			HealthCheckConfig: &vpn.GatewayVpnAttachmentHealthCheckConfigArgs{
 * 				Enable:   pulumi.Bool(true),
 * 				Sip:      pulumi.String("192.168.1.1"),
 * 				Dip:      pulumi.String("10.0.0.1"),
 * 				Interval: pulumi.Int(10),
 * 				Retry:    pulumi.Int(10),
 * 				Policy:   pulumi.String("revoke_route"),
 * 			},
 * 			EnableDpd:          pulumi.Bool(true),
 * 			EnableNatTraversal: pulumi.Bool(true),
 * 			VpnAttachmentName:  pulumi.Any(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTransitRouterVpnAttachment, err := cen.NewTransitRouterVpnAttachment(ctx, "default", &cen.TransitRouterVpnAttachmentArgs{
 * 			AutoPublishRouteEnabled:            pulumi.Bool(false),
 * 			TransitRouterAttachmentDescription: pulumi.Any(name),
 * 			TransitRouterAttachmentName:        pulumi.Any(name),
 * 			CenId:                              defaultTransitRouter.CenId,
 * 			TransitRouterId:                    defaultTransitRouter.TransitRouterId,
 * 			VpnId:                              defaultGatewayVpnAttachment.ID(),
 * 			Zones: cen.TransitRouterVpnAttachmentZoneArray{
 * 				&cen.TransitRouterVpnAttachmentZoneArgs{
 * 					ZoneId: pulumi.String(_default.Resources[0]&#46;MasterZones[0]),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewGatewayVcoRoute(ctx, "default", &vpn.GatewayVcoRouteArgs{
 * 			RouteDest:       pulumi.String("192.168.12.0/24"),
 * 			NextHop:         defaultTransitRouterVpnAttachment.VpnId,
 * 			VpnConnectionId: defaultTransitRouterVpnAttachment.VpnId,
 * 			Weight:          pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.CenFunctions;
 * import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesArgs;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachment;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs;
 * import com.pulumi.alicloud.cen.TransitRouterVpnAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs;
 * import com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs;
 * import com.pulumi.alicloud.vpn.GatewayVcoRoute;
 * import com.pulumi.alicloud.vpn.GatewayVcoRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .build());
 *         var defaultTransitRouter = new TransitRouter("defaultTransitRouter", TransitRouterArgs.builder()
 *             .cenId(defaultInstance.id())
 *             .transitRouterDescription("desd")
 *             .transitRouterName(name)
 *             .build());
 *         final var default = CenFunctions.getTransitRouterAvailableResources();
 *         var defaultCustomerGateway = new CustomerGateway("defaultCustomerGateway", CustomerGatewayArgs.builder()
 *             .name(name)
 *             .ipAddress("42.104.22.210")
 *             .asn("45014")
 *             .description("testAccVpnConnectionDesc")
 *             .build());
 *         var defaultGatewayVpnAttachment = new GatewayVpnAttachment("defaultGatewayVpnAttachment", GatewayVpnAttachmentArgs.builder()
 *             .customerGatewayId(defaultCustomerGateway.id())
 *             .networkType("public")
 *             .localSubnet("0.0.0.0/0")
 *             .remoteSubnet("0.0.0.0/0")
 *             .effectImmediately(false)
 *             .ikeConfig(GatewayVpnAttachmentIkeConfigArgs.builder()
 *                 .ikeAuthAlg("md5")
 *                 .ikeEncAlg("des")
 *                 .ikeVersion("ikev2")
 *                 .ikeMode("main")
 *                 .ikeLifetime(86400)
 *                 .psk("tf-testvpn2")
 *                 .ikePfs("group1")
 *                 .remoteId("testbob2")
 *                 .localId("testalice2")
 *                 .build())
 *             .ipsecConfig(GatewayVpnAttachmentIpsecConfigArgs.builder()
 *                 .ipsecPfs("group5")
 *                 .ipsecEncAlg("des")
 *                 .ipsecAuthAlg("md5")
 *                 .ipsecLifetime(86400)
 *                 .build())
 *             .bgpConfig(GatewayVpnAttachmentBgpConfigArgs.builder()
 *                 .enable(true)
 *                 .localAsn(45014)
 *                 .tunnelCidr("169.254.11.0/30")
 *                 .localBgpIp("169.254.11.1")
 *                 .build())
 *             .healthCheckConfig(GatewayVpnAttachmentHealthCheckConfigArgs.builder()
 *                 .enable(true)
 *                 .sip("192.168.1.1")
 *                 .dip("10.0.0.1")
 *                 .interval(10)
 *                 .retry(10)
 *                 .policy("revoke_route")
 *                 .build())
 *             .enableDpd(true)
 *             .enableNatTraversal(true)
 *             .vpnAttachmentName(name)
 *             .build());
 *         var defaultTransitRouterVpnAttachment = new TransitRouterVpnAttachment("defaultTransitRouterVpnAttachment", TransitRouterVpnAttachmentArgs.builder()
 *             .autoPublishRouteEnabled(false)
 *             .transitRouterAttachmentDescription(name)
 *             .transitRouterAttachmentName(name)
 *             .cenId(defaultTransitRouter.cenId())
 *             .transitRouterId(defaultTransitRouter.transitRouterId())
 *             .vpnId(defaultGatewayVpnAttachment.id())
 *             .zones(TransitRouterVpnAttachmentZoneArgs.builder()
 *                 .zoneId(default_.resources()[0]&#46;masterZones()[0])
 *                 .build())
 *             .build());
 *         var defaultGatewayVcoRoute = new GatewayVcoRoute("defaultGatewayVcoRoute", GatewayVcoRouteArgs.builder()
 *             .routeDest("192.168.12.0/24")
 *             .nextHop(defaultTransitRouterVpnAttachment.vpnId())
 *             .vpnConnectionId(defaultTransitRouterVpnAttachment.vpnId())
 *             .weight(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInstance:
 *     type: alicloud:cen:Instance
 *     name: default
 *     properties:
 *       cenInstanceName: ${name}
 *   defaultTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: default
 *     properties:
 *       cenId: ${defaultInstance.id}
 *       transitRouterDescription: desd
 *       transitRouterName: ${name}
 *   defaultCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     name: default
 *     properties:
 *       name: ${name}
 *       ipAddress: 42.104.22.210
 *       asn: '45014'
 *       description: testAccVpnConnectionDesc
 *   defaultGatewayVpnAttachment:
 *     type: alicloud:vpn:GatewayVpnAttachment
 *     name: default
 *     properties:
 *       customerGatewayId: ${defaultCustomerGateway.id}
 *       networkType: public
 *       localSubnet: 0.0.0.0/0
 *       remoteSubnet: 0.0.0.0/0
 *       effectImmediately: false
 *       ikeConfig:
 *         ikeAuthAlg: md5
 *         ikeEncAlg: des
 *         ikeVersion: ikev2
 *         ikeMode: main
 *         ikeLifetime: 86400
 *         psk: tf-testvpn2
 *         ikePfs: group1
 *         remoteId: testbob2
 *         localId: testalice2
 *       ipsecConfig:
 *         ipsecPfs: group5
 *         ipsecEncAlg: des
 *         ipsecAuthAlg: md5
 *         ipsecLifetime: 86400
 *       bgpConfig:
 *         enable: true
 *         localAsn: 45014
 *         tunnelCidr: 169.254.11.0/30
 *         localBgpIp: 169.254.11.1
 *       healthCheckConfig:
 *         enable: true
 *         sip: 192.168.1.1
 *         dip: 10.0.0.1
 *         interval: 10
 *         retry: 10
 *         policy: revoke_route
 *       enableDpd: true
 *       enableNatTraversal: true
 *       vpnAttachmentName: ${name}
 *   defaultTransitRouterVpnAttachment:
 *     type: alicloud:cen:TransitRouterVpnAttachment
 *     name: default
 *     properties:
 *       autoPublishRouteEnabled: false
 *       transitRouterAttachmentDescription: ${name}
 *       transitRouterAttachmentName: ${name}
 *       cenId: ${defaultTransitRouter.cenId}
 *       transitRouterId: ${defaultTransitRouter.transitRouterId}
 *       vpnId: ${defaultGatewayVpnAttachment.id}
 *       zones:
 *         - zoneId: ${default.resources[0]&#46;masterZones[0]}
 *   defaultGatewayVcoRoute:
 *     type: alicloud:vpn:GatewayVcoRoute
 *     name: default
 *     properties:
 *       routeDest: 192.168.12.0/24
 *       nextHop: ${defaultTransitRouterVpnAttachment.vpnId}
 *       vpnConnectionId: ${defaultTransitRouterVpnAttachment.vpnId}
 *       weight: 100
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cen:getTransitRouterAvailableResources
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN Gateway Vco Route can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/gatewayVcoRoute:GatewayVcoRoute example <vpn_connection_id>:<route_dest>:<next_hop>:<weight>
 * ```
 */
public class GatewayVcoRoute internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.GatewayVcoRoute,
) : KotlinCustomResource(javaResource, GatewayVcoRouteMapper) {
    /**
     * The next hop of the destination route.
     */
    public val nextHop: Output<String>
        get() = javaResource.nextHop().applyValue({ args0 -> args0 })

    /**
     * The destination network segment of the destination route.
     */
    public val routeDest: Output<String>
        get() = javaResource.routeDest().applyValue({ args0 -> args0 })

    /**
     * The status of the vpn route entry.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The id of the vpn attachment.
     */
    public val vpnConnectionId: Output<String>
        get() = javaResource.vpnConnectionId().applyValue({ args0 -> args0 })

    /**
     * The weight value of the destination route. Valid values: `0`, `100`.
     */
    public val weight: Output<Int>
        get() = javaResource.weight().applyValue({ args0 -> args0 })
}

public object GatewayVcoRouteMapper : ResourceMapper<GatewayVcoRoute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.GatewayVcoRoute::class == javaResource::class

    override fun map(javaResource: Resource): GatewayVcoRoute = GatewayVcoRoute(
        javaResource as
            com.pulumi.alicloud.vpn.GatewayVcoRoute,
    )
}

/**
 * @see [GatewayVcoRoute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayVcoRoute].
 */
public suspend fun gatewayVcoRoute(
    name: String,
    block: suspend GatewayVcoRouteResourceBuilder.() -> Unit,
): GatewayVcoRoute {
    val builder = GatewayVcoRouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayVcoRoute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayVcoRoute(name: String): GatewayVcoRoute {
    val builder = GatewayVcoRouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
