@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentBgpConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentHealthCheckConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentIkeConfig
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentIpsecConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentBgpConfig.Companion.toKotlin as gatewayVpnAttachmentBgpConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentHealthCheckConfig.Companion.toKotlin as gatewayVpnAttachmentHealthCheckConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentIkeConfig.Companion.toKotlin as gatewayVpnAttachmentIkeConfigToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GatewayVpnAttachmentIpsecConfig.Companion.toKotlin as gatewayVpnAttachmentIpsecConfigToKotlin

/**
 * Builder for [GatewayVpnAttachment].
 */
@PulumiTagMarker
public class GatewayVpnAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayVpnAttachmentArgs = GatewayVpnAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayVpnAttachmentArgsBuilder.() -> Unit) {
        val builder = GatewayVpnAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayVpnAttachment {
        val builtJavaResource = com.pulumi.alicloud.vpn.GatewayVpnAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GatewayVpnAttachment(builtJavaResource)
    }
}

/**
 * Provides a VPN Gateway Vpn Attachment resource.
 * For information about VPN Gateway Vpn Attachment and how to use it, see [What is Vpn Attachment](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvpnattachment).
 * > **NOTE:** Available since v1.181.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.vpn.CustomerGateway("default", {
 *     customerGatewayName: name,
 *     ipAddress: "42.104.22.210",
 *     asn: "45014",
 *     description: name,
 * });
 * const defaultGatewayVpnAttachment = new alicloud.vpn.GatewayVpnAttachment("default", {
 *     customerGatewayId: _default.id,
 *     networkType: "public",
 *     localSubnet: "0.0.0.0/0",
 *     remoteSubnet: "0.0.0.0/0",
 *     effectImmediately: false,
 *     ikeConfig: {
 *         ikeAuthAlg: "md5",
 *         ikeEncAlg: "des",
 *         ikeVersion: "ikev2",
 *         ikeMode: "main",
 *         ikeLifetime: 86400,
 *         psk: "tf-testvpn2",
 *         ikePfs: "group1",
 *         remoteId: "testbob2",
 *         localId: "testalice2",
 *     },
 *     ipsecConfig: {
 *         ipsecPfs: "group5",
 *         ipsecEncAlg: "des",
 *         ipsecAuthAlg: "md5",
 *         ipsecLifetime: 86400,
 *     },
 *     bgpConfig: {
 *         enable: true,
 *         localAsn: 45014,
 *         tunnelCidr: "169.254.11.0/30",
 *         localBgpIp: "169.254.11.1",
 *     },
 *     healthCheckConfig: {
 *         enable: true,
 *         sip: "192.168.1.1",
 *         dip: "10.0.0.1",
 *         interval: 10,
 *         retry: 10,
 *         policy: "revoke_route",
 *     },
 *     enableDpd: true,
 *     enableNatTraversal: true,
 *     vpnAttachmentName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.vpn.CustomerGateway("default",
 *     customer_gateway_name=name,
 *     ip_address="42.104.22.210",
 *     asn="45014",
 *     description=name)
 * default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
 *     customer_gateway_id=default.id,
 *     network_type="public",
 *     local_subnet="0.0.0.0/0",
 *     remote_subnet="0.0.0.0/0",
 *     effect_immediately=False,
 *     ike_config={
 *         "ike_auth_alg": "md5",
 *         "ike_enc_alg": "des",
 *         "ike_version": "ikev2",
 *         "ike_mode": "main",
 *         "ike_lifetime": 86400,
 *         "psk": "tf-testvpn2",
 *         "ike_pfs": "group1",
 *         "remote_id": "testbob2",
 *         "local_id": "testalice2",
 *     },
 *     ipsec_config={
 *         "ipsec_pfs": "group5",
 *         "ipsec_enc_alg": "des",
 *         "ipsec_auth_alg": "md5",
 *         "ipsec_lifetime": 86400,
 *     },
 *     bgp_config={
 *         "enable": True,
 *         "local_asn": 45014,
 *         "tunnel_cidr": "169.254.11.0/30",
 *         "local_bgp_ip": "169.254.11.1",
 *     },
 *     health_check_config={
 *         "enable": True,
 *         "sip": "192.168.1.1",
 *         "dip": "10.0.0.1",
 *         "interval": 10,
 *         "retry": 10,
 *         "policy": "revoke_route",
 *     },
 *     enable_dpd=True,
 *     enable_nat_traversal=True,
 *     vpn_attachment_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Vpn.CustomerGateway("default", new()
 *     {
 *         CustomerGatewayName = name,
 *         IpAddress = "42.104.22.210",
 *         Asn = "45014",
 *         Description = name,
 *     });
 *     var defaultGatewayVpnAttachment = new AliCloud.Vpn.GatewayVpnAttachment("default", new()
 *     {
 *         CustomerGatewayId = @default.Id,
 *         NetworkType = "public",
 *         LocalSubnet = "0.0.0.0/0",
 *         RemoteSubnet = "0.0.0.0/0",
 *         EffectImmediately = false,
 *         IkeConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIkeConfigArgs
 *         {
 *             IkeAuthAlg = "md5",
 *             IkeEncAlg = "des",
 *             IkeVersion = "ikev2",
 *             IkeMode = "main",
 *             IkeLifetime = 86400,
 *             Psk = "tf-testvpn2",
 *             IkePfs = "group1",
 *             RemoteId = "testbob2",
 *             LocalId = "testalice2",
 *         },
 *         IpsecConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIpsecConfigArgs
 *         {
 *             IpsecPfs = "group5",
 *             IpsecEncAlg = "des",
 *             IpsecAuthAlg = "md5",
 *             IpsecLifetime = 86400,
 *         },
 *         BgpConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentBgpConfigArgs
 *         {
 *             Enable = true,
 *             LocalAsn = 45014,
 *             TunnelCidr = "169.254.11.0/30",
 *             LocalBgpIp = "169.254.11.1",
 *         },
 *         HealthCheckConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentHealthCheckConfigArgs
 *         {
 *             Enable = true,
 *             Sip = "192.168.1.1",
 *             Dip = "10.0.0.1",
 *             Interval = 10,
 *             Retry = 10,
 *             Policy = "revoke_route",
 *         },
 *         EnableDpd = true,
 *         EnableNatTraversal = true,
 *         VpnAttachmentName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpn.NewCustomerGateway(ctx, "default", &vpn.CustomerGatewayArgs{
 * 			CustomerGatewayName: pulumi.String(name),
 * 			IpAddress:           pulumi.String("42.104.22.210"),
 * 			Asn:                 pulumi.String("45014"),
 * 			Description:         pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewGatewayVpnAttachment(ctx, "default", &vpn.GatewayVpnAttachmentArgs{
 * 			CustomerGatewayId: _default.ID(),
 * 			NetworkType:       pulumi.String("public"),
 * 			LocalSubnet:       pulumi.String("0.0.0.0/0"),
 * 			RemoteSubnet:      pulumi.String("0.0.0.0/0"),
 * 			EffectImmediately: pulumi.Bool(false),
 * 			IkeConfig: &vpn.GatewayVpnAttachmentIkeConfigArgs{
 * 				IkeAuthAlg:  pulumi.String("md5"),
 * 				IkeEncAlg:   pulumi.String("des"),
 * 				IkeVersion:  pulumi.String("ikev2"),
 * 				IkeMode:     pulumi.String("main"),
 * 				IkeLifetime: pulumi.Int(86400),
 * 				Psk:         pulumi.String("tf-testvpn2"),
 * 				IkePfs:      pulumi.String("group1"),
 * 				RemoteId:    pulumi.String("testbob2"),
 * 				LocalId:     pulumi.String("testalice2"),
 * 			},
 * 			IpsecConfig: &vpn.GatewayVpnAttachmentIpsecConfigArgs{
 * 				IpsecPfs:      pulumi.String("group5"),
 * 				IpsecEncAlg:   pulumi.String("des"),
 * 				IpsecAuthAlg:  pulumi.String("md5"),
 * 				IpsecLifetime: pulumi.Int(86400),
 * 			},
 * 			BgpConfig: &vpn.GatewayVpnAttachmentBgpConfigArgs{
 * 				Enable:     pulumi.Bool(true),
 * 				LocalAsn:   pulumi.Int(45014),
 * 				TunnelCidr: pulumi.String("169.254.11.0/30"),
 * 				LocalBgpIp: pulumi.String("169.254.11.1"),
 * 			},
 * 			HealthCheckConfig: &vpn.GatewayVpnAttachmentHealthCheckConfigArgs{
 * 				Enable:   pulumi.Bool(true),
 * 				Sip:      pulumi.String("192.168.1.1"),
 * 				Dip:      pulumi.String("10.0.0.1"),
 * 				Interval: pulumi.Int(10),
 * 				Retry:    pulumi.Int(10),
 * 				Policy:   pulumi.String("revoke_route"),
 * 			},
 * 			EnableDpd:          pulumi.Bool(true),
 * 			EnableNatTraversal: pulumi.Bool(true),
 * 			VpnAttachmentName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachment;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new CustomerGateway("default", CustomerGatewayArgs.builder()
 *             .customerGatewayName(name)
 *             .ipAddress("42.104.22.210")
 *             .asn("45014")
 *             .description(name)
 *             .build());
 *         var defaultGatewayVpnAttachment = new GatewayVpnAttachment("defaultGatewayVpnAttachment", GatewayVpnAttachmentArgs.builder()
 *             .customerGatewayId(default_.id())
 *             .networkType("public")
 *             .localSubnet("0.0.0.0/0")
 *             .remoteSubnet("0.0.0.0/0")
 *             .effectImmediately(false)
 *             .ikeConfig(GatewayVpnAttachmentIkeConfigArgs.builder()
 *                 .ikeAuthAlg("md5")
 *                 .ikeEncAlg("des")
 *                 .ikeVersion("ikev2")
 *                 .ikeMode("main")
 *                 .ikeLifetime(86400)
 *                 .psk("tf-testvpn2")
 *                 .ikePfs("group1")
 *                 .remoteId("testbob2")
 *                 .localId("testalice2")
 *                 .build())
 *             .ipsecConfig(GatewayVpnAttachmentIpsecConfigArgs.builder()
 *                 .ipsecPfs("group5")
 *                 .ipsecEncAlg("des")
 *                 .ipsecAuthAlg("md5")
 *                 .ipsecLifetime(86400)
 *                 .build())
 *             .bgpConfig(GatewayVpnAttachmentBgpConfigArgs.builder()
 *                 .enable(true)
 *                 .localAsn(45014)
 *                 .tunnelCidr("169.254.11.0/30")
 *                 .localBgpIp("169.254.11.1")
 *                 .build())
 *             .healthCheckConfig(GatewayVpnAttachmentHealthCheckConfigArgs.builder()
 *                 .enable(true)
 *                 .sip("192.168.1.1")
 *                 .dip("10.0.0.1")
 *                 .interval(10)
 *                 .retry(10)
 *                 .policy("revoke_route")
 *                 .build())
 *             .enableDpd(true)
 *             .enableNatTraversal(true)
 *             .vpnAttachmentName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       customerGatewayName: ${name}
 *       ipAddress: 42.104.22.210
 *       asn: '45014'
 *       description: ${name}
 *   defaultGatewayVpnAttachment:
 *     type: alicloud:vpn:GatewayVpnAttachment
 *     name: default
 *     properties:
 *       customerGatewayId: ${default.id}
 *       networkType: public
 *       localSubnet: 0.0.0.0/0
 *       remoteSubnet: 0.0.0.0/0
 *       effectImmediately: false
 *       ikeConfig:
 *         ikeAuthAlg: md5
 *         ikeEncAlg: des
 *         ikeVersion: ikev2
 *         ikeMode: main
 *         ikeLifetime: 86400
 *         psk: tf-testvpn2
 *         ikePfs: group1
 *         remoteId: testbob2
 *         localId: testalice2
 *       ipsecConfig:
 *         ipsecPfs: group5
 *         ipsecEncAlg: des
 *         ipsecAuthAlg: md5
 *         ipsecLifetime: 86400
 *       bgpConfig:
 *         enable: true
 *         localAsn: 45014
 *         tunnelCidr: 169.254.11.0/30
 *         localBgpIp: 169.254.11.1
 *       healthCheckConfig:
 *         enable: true
 *         sip: 192.168.1.1
 *         dip: 10.0.0.1
 *         interval: 10
 *         retry: 10
 *         policy: revoke_route
 *       enableDpd: true
 *       enableNatTraversal: true
 *       vpnAttachmentName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN Gateway Vpn Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/gatewayVpnAttachment:GatewayVpnAttachment example <id>
 * ```
 */
public class GatewayVpnAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.GatewayVpnAttachment,
) : KotlinCustomResource(javaResource, GatewayVpnAttachmentMapper) {
    /**
     * Bgp configuration information. See `bgp_config` below.
     */
    public val bgpConfig: Output<GatewayVpnAttachmentBgpConfig>
        get() = javaResource.bgpConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayVpnAttachmentBgpConfigToKotlin(args0)
            })
        })

    /**
     * The ID of the customer gateway. From version 1.196.0, `customer_gateway_id` can be modified.
     */
    public val customerGatewayId: Output<String>
        get() = javaResource.customerGatewayId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
     */
    public val effectImmediately: Output<Boolean>?
        get() = javaResource.effectImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable the DPD (peer survival detection) function.
     */
    public val enableDpd: Output<Boolean>
        get() = javaResource.enableDpd().applyValue({ args0 -> args0 })

    /**
     * Allow NAT penetration.
     */
    public val enableNatTraversal: Output<Boolean>
        get() = javaResource.enableNatTraversal().applyValue({ args0 -> args0 })

    /**
     * Health check configuration information. See `health_check_config` below.
     */
    public val healthCheckConfig: Output<GatewayVpnAttachmentHealthCheckConfig>
        get() = javaResource.healthCheckConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayVpnAttachmentHealthCheckConfigToKotlin(args0)
            })
        })

    /**
     * Configuration negotiated in the second stage. See `ike_config` below.
     */
    public val ikeConfig: Output<GatewayVpnAttachmentIkeConfig>
        get() = javaResource.ikeConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayVpnAttachmentIkeConfigToKotlin(args0)
            })
        })

    /**
     * The VPN gateway IP.
     */
    public val internetIp: Output<String>
        get() = javaResource.internetIp().applyValue({ args0 -> args0 })

    /**
     * Configuration negotiated in the second stage. See `ipsec_config` below.
     */
    public val ipsecConfig: Output<GatewayVpnAttachmentIpsecConfig>
        get() = javaResource.ipsecConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayVpnAttachmentIpsecConfigToKotlin(args0)
            })
        })

    /**
     * The CIDR block of the virtual private cloud (VPC).
     */
    public val localSubnet: Output<String>
        get() = javaResource.localSubnet().applyValue({ args0 -> args0 })

    /**
     * The network type of the IPsec connection. Valid values: `public`, `private`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The CIDR block of the on-premises data center.
     */
    public val remoteSubnet: Output<String>
        get() = javaResource.remoteSubnet().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The name of the vpn attachment.
     */
    public val vpnAttachmentName: Output<String>?
        get() = javaResource.vpnAttachmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GatewayVpnAttachmentMapper : ResourceMapper<GatewayVpnAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.GatewayVpnAttachment::class == javaResource::class

    override fun map(javaResource: Resource): GatewayVpnAttachment = GatewayVpnAttachment(
        javaResource
            as com.pulumi.alicloud.vpn.GatewayVpnAttachment,
    )
}

/**
 * @see [GatewayVpnAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayVpnAttachment].
 */
public suspend fun gatewayVpnAttachment(
    name: String,
    block: suspend GatewayVpnAttachmentResourceBuilder.() -> Unit,
): GatewayVpnAttachment {
    val builder = GatewayVpnAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayVpnAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayVpnAttachment(name: String): GatewayVpnAttachment {
    val builder = GatewayVpnAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
