@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs.builder
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentBgpConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentBgpConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentHealthCheckConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentHealthCheckConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentIkeConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentIkeConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentIpsecConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GatewayVpnAttachmentIpsecConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a VPN Gateway Vpn Attachment resource.
 * For information about VPN Gateway Vpn Attachment and how to use it, see [What is Vpn Attachment](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvpnattachment).
 * > **NOTE:** Available since v1.181.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.vpn.CustomerGateway("default", {
 *     customerGatewayName: name,
 *     ipAddress: "42.104.22.210",
 *     asn: "45014",
 *     description: name,
 * });
 * const defaultGatewayVpnAttachment = new alicloud.vpn.GatewayVpnAttachment("default", {
 *     customerGatewayId: _default.id,
 *     networkType: "public",
 *     localSubnet: "0.0.0.0/0",
 *     remoteSubnet: "0.0.0.0/0",
 *     effectImmediately: false,
 *     ikeConfig: {
 *         ikeAuthAlg: "md5",
 *         ikeEncAlg: "des",
 *         ikeVersion: "ikev2",
 *         ikeMode: "main",
 *         ikeLifetime: 86400,
 *         psk: "tf-testvpn2",
 *         ikePfs: "group1",
 *         remoteId: "testbob2",
 *         localId: "testalice2",
 *     },
 *     ipsecConfig: {
 *         ipsecPfs: "group5",
 *         ipsecEncAlg: "des",
 *         ipsecAuthAlg: "md5",
 *         ipsecLifetime: 86400,
 *     },
 *     bgpConfig: {
 *         enable: true,
 *         localAsn: 45014,
 *         tunnelCidr: "169.254.11.0/30",
 *         localBgpIp: "169.254.11.1",
 *     },
 *     healthCheckConfig: {
 *         enable: true,
 *         sip: "192.168.1.1",
 *         dip: "10.0.0.1",
 *         interval: 10,
 *         retry: 10,
 *         policy: "revoke_route",
 *     },
 *     enableDpd: true,
 *     enableNatTraversal: true,
 *     vpnAttachmentName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.vpn.CustomerGateway("default",
 *     customer_gateway_name=name,
 *     ip_address="42.104.22.210",
 *     asn="45014",
 *     description=name)
 * default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
 *     customer_gateway_id=default.id,
 *     network_type="public",
 *     local_subnet="0.0.0.0/0",
 *     remote_subnet="0.0.0.0/0",
 *     effect_immediately=False,
 *     ike_config={
 *         "ike_auth_alg": "md5",
 *         "ike_enc_alg": "des",
 *         "ike_version": "ikev2",
 *         "ike_mode": "main",
 *         "ike_lifetime": 86400,
 *         "psk": "tf-testvpn2",
 *         "ike_pfs": "group1",
 *         "remote_id": "testbob2",
 *         "local_id": "testalice2",
 *     },
 *     ipsec_config={
 *         "ipsec_pfs": "group5",
 *         "ipsec_enc_alg": "des",
 *         "ipsec_auth_alg": "md5",
 *         "ipsec_lifetime": 86400,
 *     },
 *     bgp_config={
 *         "enable": True,
 *         "local_asn": 45014,
 *         "tunnel_cidr": "169.254.11.0/30",
 *         "local_bgp_ip": "169.254.11.1",
 *     },
 *     health_check_config={
 *         "enable": True,
 *         "sip": "192.168.1.1",
 *         "dip": "10.0.0.1",
 *         "interval": 10,
 *         "retry": 10,
 *         "policy": "revoke_route",
 *     },
 *     enable_dpd=True,
 *     enable_nat_traversal=True,
 *     vpn_attachment_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Vpn.CustomerGateway("default", new()
 *     {
 *         CustomerGatewayName = name,
 *         IpAddress = "42.104.22.210",
 *         Asn = "45014",
 *         Description = name,
 *     });
 *     var defaultGatewayVpnAttachment = new AliCloud.Vpn.GatewayVpnAttachment("default", new()
 *     {
 *         CustomerGatewayId = @default.Id,
 *         NetworkType = "public",
 *         LocalSubnet = "0.0.0.0/0",
 *         RemoteSubnet = "0.0.0.0/0",
 *         EffectImmediately = false,
 *         IkeConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIkeConfigArgs
 *         {
 *             IkeAuthAlg = "md5",
 *             IkeEncAlg = "des",
 *             IkeVersion = "ikev2",
 *             IkeMode = "main",
 *             IkeLifetime = 86400,
 *             Psk = "tf-testvpn2",
 *             IkePfs = "group1",
 *             RemoteId = "testbob2",
 *             LocalId = "testalice2",
 *         },
 *         IpsecConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIpsecConfigArgs
 *         {
 *             IpsecPfs = "group5",
 *             IpsecEncAlg = "des",
 *             IpsecAuthAlg = "md5",
 *             IpsecLifetime = 86400,
 *         },
 *         BgpConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentBgpConfigArgs
 *         {
 *             Enable = true,
 *             LocalAsn = 45014,
 *             TunnelCidr = "169.254.11.0/30",
 *             LocalBgpIp = "169.254.11.1",
 *         },
 *         HealthCheckConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentHealthCheckConfigArgs
 *         {
 *             Enable = true,
 *             Sip = "192.168.1.1",
 *             Dip = "10.0.0.1",
 *             Interval = 10,
 *             Retry = 10,
 *             Policy = "revoke_route",
 *         },
 *         EnableDpd = true,
 *         EnableNatTraversal = true,
 *         VpnAttachmentName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpn.NewCustomerGateway(ctx, "default", &vpn.CustomerGatewayArgs{
 * 			CustomerGatewayName: pulumi.String(name),
 * 			IpAddress:           pulumi.String("42.104.22.210"),
 * 			Asn:                 pulumi.String("45014"),
 * 			Description:         pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewGatewayVpnAttachment(ctx, "default", &vpn.GatewayVpnAttachmentArgs{
 * 			CustomerGatewayId: _default.ID(),
 * 			NetworkType:       pulumi.String("public"),
 * 			LocalSubnet:       pulumi.String("0.0.0.0/0"),
 * 			RemoteSubnet:      pulumi.String("0.0.0.0/0"),
 * 			EffectImmediately: pulumi.Bool(false),
 * 			IkeConfig: &vpn.GatewayVpnAttachmentIkeConfigArgs{
 * 				IkeAuthAlg:  pulumi.String("md5"),
 * 				IkeEncAlg:   pulumi.String("des"),
 * 				IkeVersion:  pulumi.String("ikev2"),
 * 				IkeMode:     pulumi.String("main"),
 * 				IkeLifetime: pulumi.Int(86400),
 * 				Psk:         pulumi.String("tf-testvpn2"),
 * 				IkePfs:      pulumi.String("group1"),
 * 				RemoteId:    pulumi.String("testbob2"),
 * 				LocalId:     pulumi.String("testalice2"),
 * 			},
 * 			IpsecConfig: &vpn.GatewayVpnAttachmentIpsecConfigArgs{
 * 				IpsecPfs:      pulumi.String("group5"),
 * 				IpsecEncAlg:   pulumi.String("des"),
 * 				IpsecAuthAlg:  pulumi.String("md5"),
 * 				IpsecLifetime: pulumi.Int(86400),
 * 			},
 * 			BgpConfig: &vpn.GatewayVpnAttachmentBgpConfigArgs{
 * 				Enable:     pulumi.Bool(true),
 * 				LocalAsn:   pulumi.Int(45014),
 * 				TunnelCidr: pulumi.String("169.254.11.0/30"),
 * 				LocalBgpIp: pulumi.String("169.254.11.1"),
 * 			},
 * 			HealthCheckConfig: &vpn.GatewayVpnAttachmentHealthCheckConfigArgs{
 * 				Enable:   pulumi.Bool(true),
 * 				Sip:      pulumi.String("192.168.1.1"),
 * 				Dip:      pulumi.String("10.0.0.1"),
 * 				Interval: pulumi.Int(10),
 * 				Retry:    pulumi.Int(10),
 * 				Policy:   pulumi.String("revoke_route"),
 * 			},
 * 			EnableDpd:          pulumi.Bool(true),
 * 			EnableNatTraversal: pulumi.Bool(true),
 * 			VpnAttachmentName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachment;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new CustomerGateway("default", CustomerGatewayArgs.builder()
 *             .customerGatewayName(name)
 *             .ipAddress("42.104.22.210")
 *             .asn("45014")
 *             .description(name)
 *             .build());
 *         var defaultGatewayVpnAttachment = new GatewayVpnAttachment("defaultGatewayVpnAttachment", GatewayVpnAttachmentArgs.builder()
 *             .customerGatewayId(default_.id())
 *             .networkType("public")
 *             .localSubnet("0.0.0.0/0")
 *             .remoteSubnet("0.0.0.0/0")
 *             .effectImmediately(false)
 *             .ikeConfig(GatewayVpnAttachmentIkeConfigArgs.builder()
 *                 .ikeAuthAlg("md5")
 *                 .ikeEncAlg("des")
 *                 .ikeVersion("ikev2")
 *                 .ikeMode("main")
 *                 .ikeLifetime(86400)
 *                 .psk("tf-testvpn2")
 *                 .ikePfs("group1")
 *                 .remoteId("testbob2")
 *                 .localId("testalice2")
 *                 .build())
 *             .ipsecConfig(GatewayVpnAttachmentIpsecConfigArgs.builder()
 *                 .ipsecPfs("group5")
 *                 .ipsecEncAlg("des")
 *                 .ipsecAuthAlg("md5")
 *                 .ipsecLifetime(86400)
 *                 .build())
 *             .bgpConfig(GatewayVpnAttachmentBgpConfigArgs.builder()
 *                 .enable(true)
 *                 .localAsn(45014)
 *                 .tunnelCidr("169.254.11.0/30")
 *                 .localBgpIp("169.254.11.1")
 *                 .build())
 *             .healthCheckConfig(GatewayVpnAttachmentHealthCheckConfigArgs.builder()
 *                 .enable(true)
 *                 .sip("192.168.1.1")
 *                 .dip("10.0.0.1")
 *                 .interval(10)
 *                 .retry(10)
 *                 .policy("revoke_route")
 *                 .build())
 *             .enableDpd(true)
 *             .enableNatTraversal(true)
 *             .vpnAttachmentName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       customerGatewayName: ${name}
 *       ipAddress: 42.104.22.210
 *       asn: '45014'
 *       description: ${name}
 *   defaultGatewayVpnAttachment:
 *     type: alicloud:vpn:GatewayVpnAttachment
 *     name: default
 *     properties:
 *       customerGatewayId: ${default.id}
 *       networkType: public
 *       localSubnet: 0.0.0.0/0
 *       remoteSubnet: 0.0.0.0/0
 *       effectImmediately: false
 *       ikeConfig:
 *         ikeAuthAlg: md5
 *         ikeEncAlg: des
 *         ikeVersion: ikev2
 *         ikeMode: main
 *         ikeLifetime: 86400
 *         psk: tf-testvpn2
 *         ikePfs: group1
 *         remoteId: testbob2
 *         localId: testalice2
 *       ipsecConfig:
 *         ipsecPfs: group5
 *         ipsecEncAlg: des
 *         ipsecAuthAlg: md5
 *         ipsecLifetime: 86400
 *       bgpConfig:
 *         enable: true
 *         localAsn: 45014
 *         tunnelCidr: 169.254.11.0/30
 *         localBgpIp: 169.254.11.1
 *       healthCheckConfig:
 *         enable: true
 *         sip: 192.168.1.1
 *         dip: 10.0.0.1
 *         interval: 10
 *         retry: 10
 *         policy: revoke_route
 *       enableDpd: true
 *       enableNatTraversal: true
 *       vpnAttachmentName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN Gateway Vpn Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/gatewayVpnAttachment:GatewayVpnAttachment example <id>
 * ```
 * @property bgpConfig Bgp configuration information. See `bgp_config` below.
 * @property customerGatewayId The ID of the customer gateway. From version 1.196.0, `customer_gateway_id` can be modified.
 * @property effectImmediately Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
 * @property enableDpd Whether to enable the DPD (peer survival detection) function.
 * @property enableNatTraversal Allow NAT penetration.
 * @property healthCheckConfig Health check configuration information. See `health_check_config` below.
 * @property ikeConfig Configuration negotiated in the second stage. See `ike_config` below.
 * @property ipsecConfig Configuration negotiated in the second stage. See `ipsec_config` below.
 * @property localSubnet The CIDR block of the virtual private cloud (VPC).
 * @property networkType The network type of the IPsec connection. Valid values: `public`, `private`.
 * @property remoteSubnet The CIDR block of the on-premises data center.
 * @property vpnAttachmentName The name of the vpn attachment.
 */
public data class GatewayVpnAttachmentArgs(
    public val bgpConfig: Output<GatewayVpnAttachmentBgpConfigArgs>? = null,
    public val customerGatewayId: Output<String>? = null,
    public val effectImmediately: Output<Boolean>? = null,
    public val enableDpd: Output<Boolean>? = null,
    public val enableNatTraversal: Output<Boolean>? = null,
    public val healthCheckConfig: Output<GatewayVpnAttachmentHealthCheckConfigArgs>? = null,
    public val ikeConfig: Output<GatewayVpnAttachmentIkeConfigArgs>? = null,
    public val ipsecConfig: Output<GatewayVpnAttachmentIpsecConfigArgs>? = null,
    public val localSubnet: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val remoteSubnet: Output<String>? = null,
    public val vpnAttachmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs =
        com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs.builder()
            .bgpConfig(bgpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerGatewayId(customerGatewayId?.applyValue({ args0 -> args0 }))
            .effectImmediately(effectImmediately?.applyValue({ args0 -> args0 }))
            .enableDpd(enableDpd?.applyValue({ args0 -> args0 }))
            .enableNatTraversal(enableNatTraversal?.applyValue({ args0 -> args0 }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ikeConfig(ikeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipsecConfig(ipsecConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localSubnet(localSubnet?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .remoteSubnet(remoteSubnet?.applyValue({ args0 -> args0 }))
            .vpnAttachmentName(vpnAttachmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayVpnAttachmentArgs].
 */
@PulumiTagMarker
public class GatewayVpnAttachmentArgsBuilder internal constructor() {
    private var bgpConfig: Output<GatewayVpnAttachmentBgpConfigArgs>? = null

    private var customerGatewayId: Output<String>? = null

    private var effectImmediately: Output<Boolean>? = null

    private var enableDpd: Output<Boolean>? = null

    private var enableNatTraversal: Output<Boolean>? = null

    private var healthCheckConfig: Output<GatewayVpnAttachmentHealthCheckConfigArgs>? = null

    private var ikeConfig: Output<GatewayVpnAttachmentIkeConfigArgs>? = null

    private var ipsecConfig: Output<GatewayVpnAttachmentIpsecConfigArgs>? = null

    private var localSubnet: Output<String>? = null

    private var networkType: Output<String>? = null

    private var remoteSubnet: Output<String>? = null

    private var vpnAttachmentName: Output<String>? = null

    /**
     * @param value Bgp configuration information. See `bgp_config` below.
     */
    @JvmName("kyrkqiktevnwtxdr")
    public suspend fun bgpConfig(`value`: Output<GatewayVpnAttachmentBgpConfigArgs>) {
        this.bgpConfig = value
    }

    /**
     * @param value The ID of the customer gateway. From version 1.196.0, `customer_gateway_id` can be modified.
     */
    @JvmName("txikxrtvvvbfcxxy")
    public suspend fun customerGatewayId(`value`: Output<String>) {
        this.customerGatewayId = value
    }

    /**
     * @param value Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
     */
    @JvmName("ioxwnsgbvbrkwwyw")
    public suspend fun effectImmediately(`value`: Output<Boolean>) {
        this.effectImmediately = value
    }

    /**
     * @param value Whether to enable the DPD (peer survival detection) function.
     */
    @JvmName("slwmnelsifdlvllq")
    public suspend fun enableDpd(`value`: Output<Boolean>) {
        this.enableDpd = value
    }

    /**
     * @param value Allow NAT penetration.
     */
    @JvmName("xnjwrjhhatdifwwf")
    public suspend fun enableNatTraversal(`value`: Output<Boolean>) {
        this.enableNatTraversal = value
    }

    /**
     * @param value Health check configuration information. See `health_check_config` below.
     */
    @JvmName("fgovmcrasqmlgfbu")
    public suspend fun healthCheckConfig(`value`: Output<GatewayVpnAttachmentHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value Configuration negotiated in the second stage. See `ike_config` below.
     */
    @JvmName("xxxjubmnscluskfx")
    public suspend fun ikeConfig(`value`: Output<GatewayVpnAttachmentIkeConfigArgs>) {
        this.ikeConfig = value
    }

    /**
     * @param value Configuration negotiated in the second stage. See `ipsec_config` below.
     */
    @JvmName("mahrnwbyxrclxpix")
    public suspend fun ipsecConfig(`value`: Output<GatewayVpnAttachmentIpsecConfigArgs>) {
        this.ipsecConfig = value
    }

    /**
     * @param value The CIDR block of the virtual private cloud (VPC).
     */
    @JvmName("cbvgriwuwpotqcrj")
    public suspend fun localSubnet(`value`: Output<String>) {
        this.localSubnet = value
    }

    /**
     * @param value The network type of the IPsec connection. Valid values: `public`, `private`.
     */
    @JvmName("lbhsiihhepijiqto")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The CIDR block of the on-premises data center.
     */
    @JvmName("ylgnancpiqmkgcqa")
    public suspend fun remoteSubnet(`value`: Output<String>) {
        this.remoteSubnet = value
    }

    /**
     * @param value The name of the vpn attachment.
     */
    @JvmName("dhwnbmyoqrxysguw")
    public suspend fun vpnAttachmentName(`value`: Output<String>) {
        this.vpnAttachmentName = value
    }

    /**
     * @param value Bgp configuration information. See `bgp_config` below.
     */
    @JvmName("agifltbgennuxkhf")
    public suspend fun bgpConfig(`value`: GatewayVpnAttachmentBgpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpConfig = mapped
    }

    /**
     * @param argument Bgp configuration information. See `bgp_config` below.
     */
    @JvmName("qyfautdfphwwssif")
    public suspend fun bgpConfig(argument: suspend GatewayVpnAttachmentBgpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayVpnAttachmentBgpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpConfig = mapped
    }

    /**
     * @param value The ID of the customer gateway. From version 1.196.0, `customer_gateway_id` can be modified.
     */
    @JvmName("ugdxockfggtgsklq")
    public suspend fun customerGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerGatewayId = mapped
    }

    /**
     * @param value Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
     */
    @JvmName("njgvekbhdtswbnwb")
    public suspend fun effectImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectImmediately = mapped
    }

    /**
     * @param value Whether to enable the DPD (peer survival detection) function.
     */
    @JvmName("actitubaoncjudyp")
    public suspend fun enableDpd(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDpd = mapped
    }

    /**
     * @param value Allow NAT penetration.
     */
    @JvmName("ufrdgkppagpoilwj")
    public suspend fun enableNatTraversal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNatTraversal = mapped
    }

    /**
     * @param value Health check configuration information. See `health_check_config` below.
     */
    @JvmName("pewyfjqtjcjlroek")
    public suspend fun healthCheckConfig(`value`: GatewayVpnAttachmentHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument Health check configuration information. See `health_check_config` below.
     */
    @JvmName("gpegkiqibpdgyibp")
    public suspend fun healthCheckConfig(argument: suspend GatewayVpnAttachmentHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayVpnAttachmentHealthCheckConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value Configuration negotiated in the second stage. See `ike_config` below.
     */
    @JvmName("aslrmumtwglqgjgq")
    public suspend fun ikeConfig(`value`: GatewayVpnAttachmentIkeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeConfig = mapped
    }

    /**
     * @param argument Configuration negotiated in the second stage. See `ike_config` below.
     */
    @JvmName("oxvpcokphqviscdk")
    public suspend fun ikeConfig(argument: suspend GatewayVpnAttachmentIkeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayVpnAttachmentIkeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ikeConfig = mapped
    }

    /**
     * @param value Configuration negotiated in the second stage. See `ipsec_config` below.
     */
    @JvmName("aecisldliuutmhas")
    public suspend fun ipsecConfig(`value`: GatewayVpnAttachmentIpsecConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecConfig = mapped
    }

    /**
     * @param argument Configuration negotiated in the second stage. See `ipsec_config` below.
     */
    @JvmName("cnaxifuutqsijigj")
    public suspend fun ipsecConfig(argument: suspend GatewayVpnAttachmentIpsecConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayVpnAttachmentIpsecConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipsecConfig = mapped
    }

    /**
     * @param value The CIDR block of the virtual private cloud (VPC).
     */
    @JvmName("styjvgievsihcefk")
    public suspend fun localSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localSubnet = mapped
    }

    /**
     * @param value The network type of the IPsec connection. Valid values: `public`, `private`.
     */
    @JvmName("cbqbywnafsmwkojp")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The CIDR block of the on-premises data center.
     */
    @JvmName("kscerexyhatcygev")
    public suspend fun remoteSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteSubnet = mapped
    }

    /**
     * @param value The name of the vpn attachment.
     */
    @JvmName("ntfodxnqucecxrgx")
    public suspend fun vpnAttachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnAttachmentName = mapped
    }

    internal fun build(): GatewayVpnAttachmentArgs = GatewayVpnAttachmentArgs(
        bgpConfig = bgpConfig,
        customerGatewayId = customerGatewayId,
        effectImmediately = effectImmediately,
        enableDpd = enableDpd,
        enableNatTraversal = enableNatTraversal,
        healthCheckConfig = healthCheckConfig,
        ikeConfig = ikeConfig,
        ipsecConfig = ipsecConfig,
        localSubnet = localSubnet,
        networkType = networkType,
        remoteSubnet = remoteSubnet,
        vpnAttachmentName = vpnAttachmentName,
    )
}
