@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.IpsecServerArgs.builder
import com.pulumi.alicloud.vpn.kotlin.inputs.IpsecServerIkeConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.IpsecServerIkeConfigArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.IpsecServerIpsecConfigArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.IpsecServerIpsecConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a VPN Ipsec Server resource.
 * For information about VPN Ipsec Server and how to use it, see [What is Ipsec Server](https://www.alibabacloud.com/help/en/doc-detail/205454.html).
 * > **NOTE:** Available since v1.161.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const default0 = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const default1 = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[1],
 * }));
 * const defaultGateway = new alicloud.vpn.Gateway("default", {
 *     vpnGatewayName: name,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     bandwidth: 10,
 *     enableSsl: true,
 *     description: name,
 *     paymentType: "Subscription",
 *     vswitchId: default0.then(default0 => default0.ids?.[0]),
 *     disasterRecoveryVswitchId: default1.then(default1 => default1.ids?.[0]),
 * });
 * const foo = new alicloud.vpn.IpsecServer("foo", {
 *     clientIpPool: "10.0.0.0/24",
 *     ipsecServerName: name,
 *     localSubnet: "192.168.0.0/24",
 *     vpnGatewayId: defaultGateway.id,
 *     pskEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="172.16.0.0/16")
 * default0 = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default1 = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[1])
 * default_gateway = alicloud.vpn.Gateway("default",
 *     vpn_gateway_name=name,
 *     vpc_id=default_get_networks.ids[0],
 *     bandwidth=10,
 *     enable_ssl=True,
 *     description=name,
 *     payment_type="Subscription",
 *     vswitch_id=default0.ids[0],
 *     disaster_recovery_vswitch_id=default1.ids[0])
 * foo = alicloud.vpn.IpsecServer("foo",
 *     client_ip_pool="10.0.0.0/24",
 *     ipsec_server_name=name,
 *     local_subnet="192.168.0.0/24",
 *     vpn_gateway_id=default_gateway.id,
 *     psk_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var default0 = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var default1 = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[1]),
 *     });
 *     var defaultGateway = new AliCloud.Vpn.Gateway("default", new()
 *     {
 *         VpnGatewayName = name,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         Bandwidth = 10,
 *         EnableSsl = true,
 *         Description = name,
 *         PaymentType = "Subscription",
 *         VswitchId = default0.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         DisasterRecoveryVswitchId = default1.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *     });
 *     var foo = new AliCloud.Vpn.IpsecServer("foo", new()
 *     {
 *         ClientIpPool = "10.0.0.0/24",
 *         IpsecServerName = name,
 *         LocalSubnet = "192.168.0.0/24",
 *         VpnGatewayId = defaultGateway.Id,
 *         PskEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("172.16.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default0, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[1]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGateway, err := vpn.NewGateway(ctx, "default", &vpn.GatewayArgs{
 * 			VpnGatewayName:            pulumi.String(name),
 * 			VpcId:                     pulumi.String(defaultGetNetworks.Ids[0]),
 * 			Bandwidth:                 pulumi.Int(10),
 * 			EnableSsl:                 pulumi.Bool(true),
 * 			Description:               pulumi.String(name),
 * 			PaymentType:               pulumi.String("Subscription"),
 * 			VswitchId:                 pulumi.String(default0.Ids[0]),
 * 			DisasterRecoveryVswitchId: pulumi.String(default1.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewIpsecServer(ctx, "foo", &vpn.IpsecServerArgs{
 * 			ClientIpPool:    pulumi.String("10.0.0.0/24"),
 * 			IpsecServerName: pulumi.String(name),
 * 			LocalSubnet:     pulumi.String("192.168.0.0/24"),
 * 			VpnGatewayId:    defaultGateway.ID(),
 * 			PskEnabled:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.vpn.Gateway;
 * import com.pulumi.alicloud.vpn.GatewayArgs;
 * import com.pulumi.alicloud.vpn.IpsecServer;
 * import com.pulumi.alicloud.vpn.IpsecServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         final var default0 = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         final var default1 = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[1])
 *             .build());
 *         var defaultGateway = new Gateway("defaultGateway", GatewayArgs.builder()
 *             .vpnGatewayName(name)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .bandwidth("10")
 *             .enableSsl(true)
 *             .description(name)
 *             .paymentType("Subscription")
 *             .vswitchId(default0.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .disasterRecoveryVswitchId(default1.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .build());
 *         var foo = new IpsecServer("foo", IpsecServerArgs.builder()
 *             .clientIpPool("10.0.0.0/24")
 *             .ipsecServerName(name)
 *             .localSubnet("192.168.0.0/24")
 *             .vpnGatewayId(defaultGateway.id())
 *             .pskEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultGateway:
 *     type: alicloud:vpn:Gateway
 *     name: default
 *     properties:
 *       vpnGatewayName: ${name}
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       bandwidth: '10'
 *       enableSsl: true
 *       description: ${name}
 *       paymentType: Subscription
 *       vswitchId: ${default0.ids[0]}
 *       disasterRecoveryVswitchId: ${default1.ids[0]}
 *   foo:
 *     type: alicloud:vpn:IpsecServer
 *     properties:
 *       clientIpPool: 10.0.0.0/24
 *       ipsecServerName: ${name}
 *       localSubnet: 192.168.0.0/24
 *       vpnGatewayId: ${defaultGateway.id}
 *       pskEnabled: true
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 172.16.0.0/16
 *   default0:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 *   default1:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[1]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN Ipsec Server can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/ipsecServer:IpsecServer example <id>
 * ```
 * @property clientIpPool The client CIDR block. It refers to the CIDR block that is allocated to the virtual interface of the client.
 * @property dryRun The dry run.
 * @property effectImmediately Specifies whether you want the configuration to immediately take effect.
 * @property ikeConfigs The configuration of Phase 1 negotiations. See `ike_config` below.
 * @property ipsecConfigs The configuration of Phase 2 negotiations. See `ipsec_config` below.
 * @property ipsecServerName The name of the IPsec server. The name must be `2` to `128` characters in length, and can contain digits, hyphens (-), and underscores (_). It must start with a letter.
 * @property localSubnet The local CIDR block. It refers to the CIDR block of the virtual private cloud (VPC) that is used to connect with the client. Separate multiple CIDR blocks with commas (,). Example: `192.168.1.0/24,192.168.2.0/24`.
 * @property psk The pre-shared key. The pre-shared key is used to authenticate the VPN gateway and the client. By default, the system generates a random string that is 16 bits in length. You can also specify the pre-shared key. It can contain at most 100 characters.
 * @property pskEnabled Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
 * @property vpnGatewayId The ID of the VPN gateway.
 */
public data class IpsecServerArgs(
    public val clientIpPool: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val effectImmediately: Output<Boolean>? = null,
    public val ikeConfigs: Output<List<IpsecServerIkeConfigArgs>>? = null,
    public val ipsecConfigs: Output<List<IpsecServerIpsecConfigArgs>>? = null,
    public val ipsecServerName: Output<String>? = null,
    public val localSubnet: Output<String>? = null,
    public val psk: Output<String>? = null,
    public val pskEnabled: Output<Boolean>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.IpsecServerArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.IpsecServerArgs =
        com.pulumi.alicloud.vpn.IpsecServerArgs.builder()
            .clientIpPool(clientIpPool?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .effectImmediately(effectImmediately?.applyValue({ args0 -> args0 }))
            .ikeConfigs(
                ikeConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipsecConfigs(
                ipsecConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipsecServerName(ipsecServerName?.applyValue({ args0 -> args0 }))
            .localSubnet(localSubnet?.applyValue({ args0 -> args0 }))
            .psk(psk?.applyValue({ args0 -> args0 }))
            .pskEnabled(pskEnabled?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpsecServerArgs].
 */
@PulumiTagMarker
public class IpsecServerArgsBuilder internal constructor() {
    private var clientIpPool: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var effectImmediately: Output<Boolean>? = null

    private var ikeConfigs: Output<List<IpsecServerIkeConfigArgs>>? = null

    private var ipsecConfigs: Output<List<IpsecServerIpsecConfigArgs>>? = null

    private var ipsecServerName: Output<String>? = null

    private var localSubnet: Output<String>? = null

    private var psk: Output<String>? = null

    private var pskEnabled: Output<Boolean>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value The client CIDR block. It refers to the CIDR block that is allocated to the virtual interface of the client.
     */
    @JvmName("mmxjqeynviydwtyj")
    public suspend fun clientIpPool(`value`: Output<String>) {
        this.clientIpPool = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("hqfwndfakkbqhrom")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Specifies whether you want the configuration to immediately take effect.
     */
    @JvmName("xfkoagmxnnwhbdua")
    public suspend fun effectImmediately(`value`: Output<Boolean>) {
        this.effectImmediately = value
    }

    /**
     * @param value The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("ruftwoymxkwsvxir")
    public suspend fun ikeConfigs(`value`: Output<List<IpsecServerIkeConfigArgs>>) {
        this.ikeConfigs = value
    }

    @JvmName("ktldtfqnfqyjeybg")
    public suspend fun ikeConfigs(vararg values: Output<IpsecServerIkeConfigArgs>) {
        this.ikeConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("yayspntbcymboubh")
    public suspend fun ikeConfigs(values: List<Output<IpsecServerIkeConfigArgs>>) {
        this.ikeConfigs = Output.all(values)
    }

    /**
     * @param value The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("lhjtmwccjfdnggwo")
    public suspend fun ipsecConfigs(`value`: Output<List<IpsecServerIpsecConfigArgs>>) {
        this.ipsecConfigs = value
    }

    @JvmName("nkdvuoixnlndmyni")
    public suspend fun ipsecConfigs(vararg values: Output<IpsecServerIpsecConfigArgs>) {
        this.ipsecConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("ylmxodiercjwclsb")
    public suspend fun ipsecConfigs(values: List<Output<IpsecServerIpsecConfigArgs>>) {
        this.ipsecConfigs = Output.all(values)
    }

    /**
     * @param value The name of the IPsec server. The name must be `2` to `128` characters in length, and can contain digits, hyphens (-), and underscores (_). It must start with a letter.
     */
    @JvmName("ypgnvflqkcvusein")
    public suspend fun ipsecServerName(`value`: Output<String>) {
        this.ipsecServerName = value
    }

    /**
     * @param value The local CIDR block. It refers to the CIDR block of the virtual private cloud (VPC) that is used to connect with the client. Separate multiple CIDR blocks with commas (,). Example: `192.168.1.0/24,192.168.2.0/24`.
     */
    @JvmName("kohvihdjyuwkkwwa")
    public suspend fun localSubnet(`value`: Output<String>) {
        this.localSubnet = value
    }

    /**
     * @param value The pre-shared key. The pre-shared key is used to authenticate the VPN gateway and the client. By default, the system generates a random string that is 16 bits in length. You can also specify the pre-shared key. It can contain at most 100 characters.
     */
    @JvmName("oteijjucovmjlrnh")
    public suspend fun psk(`value`: Output<String>) {
        this.psk = value
    }

    /**
     * @param value Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
     */
    @JvmName("bhmmwvuejctdfkvy")
    public suspend fun pskEnabled(`value`: Output<Boolean>) {
        this.pskEnabled = value
    }

    /**
     * @param value The ID of the VPN gateway.
     */
    @JvmName("lnttyidwokbgrvyi")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value The client CIDR block. It refers to the CIDR block that is allocated to the virtual interface of the client.
     */
    @JvmName("wsjrstjewggdjcdf")
    public suspend fun clientIpPool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIpPool = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("cqpiitnlymgcgxjn")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Specifies whether you want the configuration to immediately take effect.
     */
    @JvmName("mtnyyibaowniffpj")
    public suspend fun effectImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectImmediately = mapped
    }

    /**
     * @param value The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("rweewptxijtstmsj")
    public suspend fun ikeConfigs(`value`: List<IpsecServerIkeConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeConfigs = mapped
    }

    /**
     * @param argument The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("mftglcoruqrfamyr")
    public suspend fun ikeConfigs(argument: List<suspend IpsecServerIkeConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpsecServerIkeConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ikeConfigs = mapped
    }

    /**
     * @param argument The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("oaclipeuvniaqjsk")
    public suspend fun ikeConfigs(vararg argument: suspend IpsecServerIkeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpsecServerIkeConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ikeConfigs = mapped
    }

    /**
     * @param argument The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("dcjmvnuebbqwdfhb")
    public suspend fun ikeConfigs(argument: suspend IpsecServerIkeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecServerIkeConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ikeConfigs = mapped
    }

    /**
     * @param values The configuration of Phase 1 negotiations. See `ike_config` below.
     */
    @JvmName("afxevujhcwlkhcqv")
    public suspend fun ikeConfigs(vararg values: IpsecServerIkeConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeConfigs = mapped
    }

    /**
     * @param value The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("fewsrmkruswdttpy")
    public suspend fun ipsecConfigs(`value`: List<IpsecServerIpsecConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecConfigs = mapped
    }

    /**
     * @param argument The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("lliyqyshvqaswjfm")
    public suspend fun ipsecConfigs(argument: List<suspend IpsecServerIpsecConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpsecServerIpsecConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipsecConfigs = mapped
    }

    /**
     * @param argument The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("yeogojghpbscderi")
    public suspend fun ipsecConfigs(vararg argument: suspend IpsecServerIpsecConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpsecServerIpsecConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipsecConfigs = mapped
    }

    /**
     * @param argument The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("nisbtkdvwkbkeduo")
    public suspend fun ipsecConfigs(argument: suspend IpsecServerIpsecConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecServerIpsecConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipsecConfigs = mapped
    }

    /**
     * @param values The configuration of Phase 2 negotiations. See `ipsec_config` below.
     */
    @JvmName("uubmcjfiwiylfeey")
    public suspend fun ipsecConfigs(vararg values: IpsecServerIpsecConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecConfigs = mapped
    }

    /**
     * @param value The name of the IPsec server. The name must be `2` to `128` characters in length, and can contain digits, hyphens (-), and underscores (_). It must start with a letter.
     */
    @JvmName("psxeyvxjdtjykjci")
    public suspend fun ipsecServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecServerName = mapped
    }

    /**
     * @param value The local CIDR block. It refers to the CIDR block of the virtual private cloud (VPC) that is used to connect with the client. Separate multiple CIDR blocks with commas (,). Example: `192.168.1.0/24,192.168.2.0/24`.
     */
    @JvmName("mxiblbuuiaeomhol")
    public suspend fun localSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localSubnet = mapped
    }

    /**
     * @param value The pre-shared key. The pre-shared key is used to authenticate the VPN gateway and the client. By default, the system generates a random string that is 16 bits in length. You can also specify the pre-shared key. It can contain at most 100 characters.
     */
    @JvmName("rxsawcbtyakyadoo")
    public suspend fun psk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.psk = mapped
    }

    /**
     * @param value Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
     */
    @JvmName("hxkqnuhlxgdphrsk")
    public suspend fun pskEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pskEnabled = mapped
    }

    /**
     * @param value The ID of the VPN gateway.
     */
    @JvmName("qokehbhlmwhftiam")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): IpsecServerArgs = IpsecServerArgs(
        clientIpPool = clientIpPool,
        dryRun = dryRun,
        effectImmediately = effectImmediately,
        ikeConfigs = ikeConfigs,
        ipsecConfigs = ipsecConfigs,
        ipsecServerName = ipsecServerName,
        localSubnet = localSubnet,
        psk = psk,
        pskEnabled = pskEnabled,
        vpnGatewayId = vpnGatewayId,
    )
}
