@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouteEntry].
 */
@PulumiTagMarker
public class RouteEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteEntryArgs = RouteEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteEntryArgsBuilder.() -> Unit) {
        val builder = RouteEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteEntry {
        val builtJavaResource = com.pulumi.alicloud.vpn.RouteEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteEntry(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.vpn.getGateways({});
 * const defaultCustomerGateway = new alicloud.vpn.CustomerGateway("defaultCustomerGateway", {
 *     description: "defaultCustomerGateway",
 *     ipAddress: "2.2.2.5",
 *     asn: "2224",
 *     customerGatewayName: name,
 * });
 * const changeCustomerGateway = new alicloud.vpn.CustomerGateway("changeCustomerGateway", {
 *     description: "changeCustomerGateway",
 *     ipAddress: "2.2.2.6",
 *     asn: "2225",
 *     customerGatewayName: name,
 * });
 * const defaultConnection = new alicloud.vpn.Connection("default", {
 *     vpnGatewayId: _default.then(_default => _default.ids?.[0]),
 *     vpnConnectionName: name,
 *     localSubnets: ["3&#46;0&#46;0&#46;0/24"],
 *     remoteSubnets: [
 *         "10.0.0.0/24",
 *         "10.0.1.0/24",
 *     ],
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     enableTunnelsBgp: true,
 *     tunnelOptionsSpecifications: [
 *         {
 *             tunnelIpsecConfig: {
 *                 ipsecAuthAlg: "md5",
 *                 ipsecEncAlg: "aes256",
 *                 ipsecLifetime: 16400,
 *                 ipsecPfs: "group5",
 *             },
 *             customerGatewayId: defaultCustomerGateway.id,
 *             role: "master",
 *             tunnelBgpConfig: {
 *                 localAsn: "1219002",
 *                 tunnelCidr: "169.254.30.0/30",
 *                 localBgpIp: "169.254.30.1",
 *             },
 *             tunnelIkeConfig: {
 *                 ikeMode: "aggressive",
 *                 ikeVersion: "ikev2",
 *                 localId: "localid_tunnel2",
 *                 psk: "12345678",
 *                 remoteId: "remote2",
 *                 ikeAuthAlg: "md5",
 *                 ikeEncAlg: "aes256",
 *                 ikeLifetime: 3600,
 *                 ikePfs: "group14",
 *             },
 *         },
 *         {
 *             tunnelIkeConfig: {
 *                 remoteId: "remote24",
 *                 ikeEncAlg: "aes256",
 *                 ikeLifetime: 27000,
 *                 ikeMode: "aggressive",
 *                 ikePfs: "group5",
 *                 ikeAuthAlg: "md5",
 *                 ikeVersion: "ikev2",
 *                 localId: "localid_tunnel2",
 *                 psk: "12345678",
 *             },
 *             tunnelIpsecConfig: {
 *                 ipsecLifetime: 2700,
 *                 ipsecPfs: "group14",
 *                 ipsecAuthAlg: "md5",
 *                 ipsecEncAlg: "aes256",
 *             },
 *             customerGatewayId: defaultCustomerGateway.id,
 *             role: "slave",
 *             tunnelBgpConfig: {
 *                 localAsn: "1219002",
 *                 localBgpIp: "169.254.40.1",
 *                 tunnelCidr: "169.254.40.0/30",
 *             },
 *         },
 *     ],
 * });
 * const defaultRouteEntry = new alicloud.vpn.RouteEntry("default", {
 *     vpnGatewayId: _default.then(_default => _default.ids?.[0]),
 *     routeDest: "10.0.0.0/24",
 *     nextHop: defaultConnection.id,
 *     weight: 0,
 *     publishVpc: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpn.get_gateways()
 * default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
 *     description="defaultCustomerGateway",
 *     ip_address="2.2.2.5",
 *     asn="2224",
 *     customer_gateway_name=name)
 * change_customer_gateway = alicloud.vpn.CustomerGateway("changeCustomerGateway",
 *     description="changeCustomerGateway",
 *     ip_address="2.2.2.6",
 *     asn="2225",
 *     customer_gateway_name=name)
 * default_connection = alicloud.vpn.Connection("default",
 *     vpn_gateway_id=default.ids[0],
 *     vpn_connection_name=name,
 *     local_subnets=["3&#46;0&#46;0&#46;0/24"],
 *     remote_subnets=[
 *         "10.0.0.0/24",
 *         "10.0.1.0/24",
 *     ],
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     enable_tunnels_bgp=True,
 *     tunnel_options_specifications=[
 *         {
 *             "tunnel_ipsec_config": {
 *                 "ipsec_auth_alg": "md5",
 *                 "ipsec_enc_alg": "aes256",
 *                 "ipsec_lifetime": 16400,
 *                 "ipsec_pfs": "group5",
 *             },
 *             "customer_gateway_id": default_customer_gateway.id,
 *             "role": "master",
 *             "tunnel_bgp_config": {
 *                 "local_asn": "1219002",
 *                 "tunnel_cidr": "169.254.30.0/30",
 *                 "local_bgp_ip": "169.254.30.1",
 *             },
 *             "tunnel_ike_config": {
 *                 "ike_mode": "aggressive",
 *                 "ike_version": "ikev2",
 *                 "local_id": "localid_tunnel2",
 *                 "psk": "12345678",
 *                 "remote_id": "remote2",
 *                 "ike_auth_alg": "md5",
 *                 "ike_enc_alg": "aes256",
 *                 "ike_lifetime": 3600,
 *                 "ike_pfs": "group14",
 *             },
 *         },
 *         {
 *             "tunnel_ike_config": {
 *                 "remote_id": "remote24",
 *                 "ike_enc_alg": "aes256",
 *                 "ike_lifetime": 27000,
 *                 "ike_mode": "aggressive",
 *                 "ike_pfs": "group5",
 *                 "ike_auth_alg": "md5",
 *                 "ike_version": "ikev2",
 *                 "local_id": "localid_tunnel2",
 *                 "psk": "12345678",
 *             },
 *             "tunnel_ipsec_config": {
 *                 "ipsec_lifetime": 2700,
 *                 "ipsec_pfs": "group14",
 *                 "ipsec_auth_alg": "md5",
 *                 "ipsec_enc_alg": "aes256",
 *             },
 *             "customer_gateway_id": default_customer_gateway.id,
 *             "role": "slave",
 *             "tunnel_bgp_config": {
 *                 "local_asn": "1219002",
 *                 "local_bgp_ip": "169.254.40.1",
 *                 "tunnel_cidr": "169.254.40.0/30",
 *             },
 *         },
 *     ])
 * default_route_entry = alicloud.vpn.RouteEntry("default",
 *     vpn_gateway_id=default.ids[0],
 *     route_dest="10.0.0.0/24",
 *     next_hop=default_connection.id,
 *     weight=0,
 *     publish_vpc=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Vpn.GetGateways.Invoke();
 *     var defaultCustomerGateway = new AliCloud.Vpn.CustomerGateway("defaultCustomerGateway", new()
 *     {
 *         Description = "defaultCustomerGateway",
 *         IpAddress = "2.2.2.5",
 *         Asn = "2224",
 *         CustomerGatewayName = name,
 *     });
 *     var changeCustomerGateway = new AliCloud.Vpn.CustomerGateway("changeCustomerGateway", new()
 *     {
 *         Description = "changeCustomerGateway",
 *         IpAddress = "2.2.2.6",
 *         Asn = "2225",
 *         CustomerGatewayName = name,
 *     });
 *     var defaultConnection = new AliCloud.Vpn.Connection("default", new()
 *     {
 *         VpnGatewayId = @default.Apply(@default => @default.Apply(getGatewaysResult => getGatewaysResult.Ids[0])),
 *         VpnConnectionName = name,
 *         LocalSubnets = new[]
 *         {
 *             "3.0.0.0/24",
 *         },
 *         RemoteSubnets = new[]
 *         {
 *             "10.0.0.0/24",
 *             "10.0.1.0/24",
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         EnableTunnelsBgp = true,
 *         TunnelOptionsSpecifications = new[]
 *         {
 *             new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationArgs
 *             {
 *                 TunnelIpsecConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs
 *                 {
 *                     IpsecAuthAlg = "md5",
 *                     IpsecEncAlg = "aes256",
 *                     IpsecLifetime = 16400,
 *                     IpsecPfs = "group5",
 *                 },
 *                 CustomerGatewayId = defaultCustomerGateway.Id,
 *                 Role = "master",
 *                 TunnelBgpConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs
 *                 {
 *                     LocalAsn = "1219002",
 *                     TunnelCidr = "169.254.30.0/30",
 *                     LocalBgpIp = "169.254.30.1",
 *                 },
 *                 TunnelIkeConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs
 *                 {
 *                     IkeMode = "aggressive",
 *                     IkeVersion = "ikev2",
 *                     LocalId = "localid_tunnel2",
 *                     Psk = "12345678",
 *                     RemoteId = "remote2",
 *                     IkeAuthAlg = "md5",
 *                     IkeEncAlg = "aes256",
 *                     IkeLifetime = 3600,
 *                     IkePfs = "group14",
 *                 },
 *             },
 *             new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationArgs
 *             {
 *                 TunnelIkeConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs
 *                 {
 *                     RemoteId = "remote24",
 *                     IkeEncAlg = "aes256",
 *                     IkeLifetime = 27000,
 *                     IkeMode = "aggressive",
 *                     IkePfs = "group5",
 *                     IkeAuthAlg = "md5",
 *                     IkeVersion = "ikev2",
 *                     LocalId = "localid_tunnel2",
 *                     Psk = "12345678",
 *                 },
 *                 TunnelIpsecConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs
 *                 {
 *                     IpsecLifetime = 2700,
 *                     IpsecPfs = "group14",
 *                     IpsecAuthAlg = "md5",
 *                     IpsecEncAlg = "aes256",
 *                 },
 *                 CustomerGatewayId = defaultCustomerGateway.Id,
 *                 Role = "slave",
 *                 TunnelBgpConfig = new AliCloud.Vpn.Inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs
 *                 {
 *                     LocalAsn = "1219002",
 *                     LocalBgpIp = "169.254.40.1",
 *                     TunnelCidr = "169.254.40.0/30",
 *                 },
 *             },
 *         },
 *     });
 *     var defaultRouteEntry = new AliCloud.Vpn.RouteEntry("default", new()
 *     {
 *         VpnGatewayId = @default.Apply(@default => @default.Apply(getGatewaysResult => getGatewaysResult.Ids[0])),
 *         RouteDest = "10.0.0.0/24",
 *         NextHop = defaultConnection.Id,
 *         Weight = 0,
 *         PublishVpc = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := vpn.GetGateways(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCustomerGateway, err := vpn.NewCustomerGateway(ctx, "defaultCustomerGateway", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String("defaultCustomerGateway"),
 * 			IpAddress:           pulumi.String("2.2.2.5"),
 * 			Asn:                 pulumi.String("2224"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewCustomerGateway(ctx, "changeCustomerGateway", &vpn.CustomerGatewayArgs{
 * 			Description:         pulumi.String("changeCustomerGateway"),
 * 			IpAddress:           pulumi.String("2.2.2.6"),
 * 			Asn:                 pulumi.String("2225"),
 * 			CustomerGatewayName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultConnection, err := vpn.NewConnection(ctx, "default", &vpn.ConnectionArgs{
 * 			VpnGatewayId:      pulumi.String(_default.Ids[0]),
 * 			VpnConnectionName: pulumi.String(name),
 * 			LocalSubnets: pulumi.StringArray{
 * 				pulumi.String("3.0.0.0/24"),
 * 			},
 * 			RemoteSubnets: pulumi.StringArray{
 * 				pulumi.String("10.0.0.0/24"),
 * 				pulumi.String("10.0.1.0/24"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			EnableTunnelsBgp: pulumi.Bool(true),
 * 			TunnelOptionsSpecifications: vpn.ConnectionTunnelOptionsSpecificationArray{
 * 				&vpn.ConnectionTunnelOptionsSpecificationArgs{
 * 					TunnelIpsecConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs{
 * 						IpsecAuthAlg:  pulumi.String("md5"),
 * 						IpsecEncAlg:   pulumi.String("aes256"),
 * 						IpsecLifetime: pulumi.Int(16400),
 * 						IpsecPfs:      pulumi.String("group5"),
 * 					},
 * 					CustomerGatewayId: defaultCustomerGateway.ID(),
 * 					Role:              pulumi.String("master"),
 * 					TunnelBgpConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs{
 * 						LocalAsn:   pulumi.String("1219002"),
 * 						TunnelCidr: pulumi.String("169.254.30.0/30"),
 * 						LocalBgpIp: pulumi.String("169.254.30.1"),
 * 					},
 * 					TunnelIkeConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs{
 * 						IkeMode:     pulumi.String("aggressive"),
 * 						IkeVersion:  pulumi.String("ikev2"),
 * 						LocalId:     pulumi.String("localid_tunnel2"),
 * 						Psk:         pulumi.String("12345678"),
 * 						RemoteId:    pulumi.String("remote2"),
 * 						IkeAuthAlg:  pulumi.String("md5"),
 * 						IkeEncAlg:   pulumi.String("aes256"),
 * 						IkeLifetime: pulumi.Int(3600),
 * 						IkePfs:      pulumi.String("group14"),
 * 					},
 * 				},
 * 				&vpn.ConnectionTunnelOptionsSpecificationArgs{
 * 					TunnelIkeConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs{
 * 						RemoteId:    pulumi.String("remote24"),
 * 						IkeEncAlg:   pulumi.String("aes256"),
 * 						IkeLifetime: pulumi.Int(27000),
 * 						IkeMode:     pulumi.String("aggressive"),
 * 						IkePfs:      pulumi.String("group5"),
 * 						IkeAuthAlg:  pulumi.String("md5"),
 * 						IkeVersion:  pulumi.String("ikev2"),
 * 						LocalId:     pulumi.String("localid_tunnel2"),
 * 						Psk:         pulumi.String("12345678"),
 * 					},
 * 					TunnelIpsecConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs{
 * 						IpsecLifetime: pulumi.Int(2700),
 * 						IpsecPfs:      pulumi.String("group14"),
 * 						IpsecAuthAlg:  pulumi.String("md5"),
 * 						IpsecEncAlg:   pulumi.String("aes256"),
 * 					},
 * 					CustomerGatewayId: defaultCustomerGateway.ID(),
 * 					Role:              pulumi.String("slave"),
 * 					TunnelBgpConfig: &vpn.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs{
 * 						LocalAsn:   pulumi.String("1219002"),
 * 						LocalBgpIp: pulumi.String("169.254.40.1"),
 * 						TunnelCidr: pulumi.String("169.254.40.0/30"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpn.NewRouteEntry(ctx, "default", &vpn.RouteEntryArgs{
 * 			VpnGatewayId: pulumi.String(_default.Ids[0]),
 * 			RouteDest:    pulumi.String("10.0.0.0/24"),
 * 			NextHop:      defaultConnection.ID(),
 * 			Weight:       pulumi.Int(0),
 * 			PublishVpc:   pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpn.VpnFunctions;
 * import com.pulumi.alicloud.vpn.inputs.GetGatewaysArgs;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.Connection;
 * import com.pulumi.alicloud.vpn.ConnectionArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs;
 * import com.pulumi.alicloud.vpn.RouteEntry;
 * import com.pulumi.alicloud.vpn.RouteEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = VpnFunctions.getGateways();
 *         var defaultCustomerGateway = new CustomerGateway("defaultCustomerGateway", CustomerGatewayArgs.builder()
 *             .description("defaultCustomerGateway")
 *             .ipAddress("2.2.2.5")
 *             .asn("2224")
 *             .customerGatewayName(name)
 *             .build());
 *         var changeCustomerGateway = new CustomerGateway("changeCustomerGateway", CustomerGatewayArgs.builder()
 *             .description("changeCustomerGateway")
 *             .ipAddress("2.2.2.6")
 *             .asn("2225")
 *             .customerGatewayName(name)
 *             .build());
 *         var defaultConnection = new Connection("defaultConnection", ConnectionArgs.builder()
 *             .vpnGatewayId(default_.ids()[0])
 *             .vpnConnectionName(name)
 *             .localSubnets("3.0.0.0/24")
 *             .remoteSubnets(
 *                 "10.0.0.0/24",
 *                 "10.0.1.0/24")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .enableTunnelsBgp("true")
 *             .tunnelOptionsSpecifications(
 *                 ConnectionTunnelOptionsSpecificationArgs.builder()
 *                     .tunnelIpsecConfig(ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
 *                         .ipsecAuthAlg("md5")
 *                         .ipsecEncAlg("aes256")
 *                         .ipsecLifetime("16400")
 *                         .ipsecPfs("group5")
 *                         .build())
 *                     .customerGatewayId(defaultCustomerGateway.id())
 *                     .role("master")
 *                     .tunnelBgpConfig(ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
 *                         .localAsn("1219002")
 *                         .tunnelCidr("169.254.30.0/30")
 *                         .localBgpIp("169.254.30.1")
 *                         .build())
 *                     .tunnelIkeConfig(ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
 *                         .ikeMode("aggressive")
 *                         .ikeVersion("ikev2")
 *                         .localId("localid_tunnel2")
 *                         .psk("12345678")
 *                         .remoteId("remote2")
 *                         .ikeAuthAlg("md5")
 *                         .ikeEncAlg("aes256")
 *                         .ikeLifetime("3600")
 *                         .ikePfs("group14")
 *                         .build())
 *                     .build(),
 *                 ConnectionTunnelOptionsSpecificationArgs.builder()
 *                     .tunnelIkeConfig(ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
 *                         .remoteId("remote24")
 *                         .ikeEncAlg("aes256")
 *                         .ikeLifetime("27000")
 *                         .ikeMode("aggressive")
 *                         .ikePfs("group5")
 *                         .ikeAuthAlg("md5")
 *                         .ikeVersion("ikev2")
 *                         .localId("localid_tunnel2")
 *                         .psk("12345678")
 *                         .build())
 *                     .tunnelIpsecConfig(ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
 *                         .ipsecLifetime("2700")
 *                         .ipsecPfs("group14")
 *                         .ipsecAuthAlg("md5")
 *                         .ipsecEncAlg("aes256")
 *                         .build())
 *                     .customerGatewayId(defaultCustomerGateway.id())
 *                     .role("slave")
 *                     .tunnelBgpConfig(ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
 *                         .localAsn("1219002")
 *                         .localBgpIp("169.254.40.1")
 *                         .tunnelCidr("169.254.40.0/30")
 *                         .build())
 *                     .build())
 *             .build());
 *         var defaultRouteEntry = new RouteEntry("defaultRouteEntry", RouteEntryArgs.builder()
 *             .vpnGatewayId(default_.ids()[0])
 *             .routeDest("10.0.0.0/24")
 *             .nextHop(defaultConnection.id())
 *             .weight(0)
 *             .publishVpc(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: defaultCustomerGateway
 *       ipAddress: 2.2.2.5
 *       asn: '2224'
 *       customerGatewayName: ${name}
 *   changeCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     properties:
 *       description: changeCustomerGateway
 *       ipAddress: 2.2.2.6
 *       asn: '2225'
 *       customerGatewayName: ${name}
 *   defaultConnection:
 *     type: alicloud:vpn:Connection
 *     name: default
 *     properties:
 *       vpnGatewayId: ${default.ids[0]}
 *       vpnConnectionName: ${name}
 *       localSubnets:
 *         - 3.0.0.0/24
 *       remoteSubnets:
 *         - 10.0.0.0/24
 *         - 10.0.1.0/24
 *       tags:
 *         Created: TF
 *         For: example
 *       enableTunnelsBgp: 'true'
 *       tunnelOptionsSpecifications:
 *         - tunnelIpsecConfig:
 *             ipsecAuthAlg: md5
 *             ipsecEncAlg: aes256
 *             ipsecLifetime: '16400'
 *             ipsecPfs: group5
 *           customerGatewayId: ${defaultCustomerGateway.id}
 *           role: master
 *           tunnelBgpConfig:
 *             localAsn: '1219002'
 *             tunnelCidr: 169.254.30.0/30
 *             localBgpIp: 169.254.30.1
 *           tunnelIkeConfig:
 *             ikeMode: aggressive
 *             ikeVersion: ikev2
 *             localId: localid_tunnel2
 *             psk: '12345678'
 *             remoteId: remote2
 *             ikeAuthAlg: md5
 *             ikeEncAlg: aes256
 *             ikeLifetime: '3600'
 *             ikePfs: group14
 *         - tunnelIkeConfig:
 *             remoteId: remote24
 *             ikeEncAlg: aes256
 *             ikeLifetime: '27000'
 *             ikeMode: aggressive
 *             ikePfs: group5
 *             ikeAuthAlg: md5
 *             ikeVersion: ikev2
 *             localId: localid_tunnel2
 *             psk: '12345678'
 *           tunnelIpsecConfig:
 *             ipsecLifetime: '2700'
 *             ipsecPfs: group14
 *             ipsecAuthAlg: md5
 *             ipsecEncAlg: aes256
 *           customerGatewayId: ${defaultCustomerGateway.id}
 *           role: slave
 *           tunnelBgpConfig:
 *             localAsn: '1219002'
 *             localBgpIp: 169.254.40.1
 *             tunnelCidr: 169.254.40.0/30
 *   defaultRouteEntry:
 *     type: alicloud:vpn:RouteEntry
 *     name: default
 *     properties:
 *       vpnGatewayId: ${default.ids[0]}
 *       routeDest: 10.0.0.0/24
 *       nextHop: ${defaultConnection.id}
 *       weight: 0
 *       publishVpc: false
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpn:getGateways
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPN route entry can be imported using the id(VpnGatewayId +":"+ NextHop +":"+ RouteDest), e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/routeEntry:RouteEntry example vpn-abc123456:vco-abc123456:10.0.0.10/24
 * ```
 */
public class RouteEntry internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.RouteEntry,
) : KotlinCustomResource(javaResource, RouteEntryMapper) {
    /**
     * The next hop of the destination route.
     */
    public val nextHop: Output<String>
        get() = javaResource.nextHop().applyValue({ args0 -> args0 })

    /**
     * Whether to issue the destination route to the VPC.
     */
    public val publishVpc: Output<Boolean>
        get() = javaResource.publishVpc().applyValue({ args0 -> args0 })

    /**
     * The destination network segment of the destination route.
     */
    public val routeDest: Output<String>
        get() = javaResource.routeDest().applyValue({ args0 -> args0 })

    /**
     * (Available in 1.161.0+) The type of the vpn route entry.
     */
    public val routeEntryType: Output<String>
        get() = javaResource.routeEntryType().applyValue({ args0 -> args0 })

    /**
     * (Available in 1.161.0+) The status of the vpn route entry.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The id of the vpn gateway.
     */
    public val vpnGatewayId: Output<String>
        get() = javaResource.vpnGatewayId().applyValue({ args0 -> args0 })

    /**
     * The value should be 0 or 100.
     */
    public val weight: Output<Int>
        get() = javaResource.weight().applyValue({ args0 -> args0 })
}

public object RouteEntryMapper : ResourceMapper<RouteEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.RouteEntry::class == javaResource::class

    override fun map(javaResource: Resource): RouteEntry = RouteEntry(
        javaResource as
            com.pulumi.alicloud.vpn.RouteEntry,
    )
}

/**
 * @see [RouteEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteEntry].
 */
public suspend fun routeEntry(name: String, block: suspend RouteEntryResourceBuilder.() -> Unit): RouteEntry {
    val builder = RouteEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeEntry(name: String): RouteEntry {
    val builder = RouteEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
