@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SslVpnClientCert].
 */
@PulumiTagMarker
public class SslVpnClientCertResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SslVpnClientCertArgs = SslVpnClientCertArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SslVpnClientCertArgsBuilder.() -> Unit) {
        val builder = SslVpnClientCertArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SslVpnClientCert {
        val builtJavaResource = com.pulumi.alicloud.vpn.SslVpnClientCert(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SslVpnClientCert(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * ## Import
 * SSL-VPN client certificates can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/sslVpnClientCert:SslVpnClientCert example vsc-abc123456
 * ```
 */
public class SslVpnClientCert internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.SslVpnClientCert,
) : KotlinCustomResource(javaResource, SslVpnClientCertMapper) {
    /**
     * The client ca cert.
     */
    public val caCert: Output<String>
        get() = javaResource.caCert().applyValue({ args0 -> args0 })

    /**
     * The client cert.
     */
    public val clientCert: Output<String>
        get() = javaResource.clientCert().applyValue({ args0 -> args0 })

    /**
     * The vpn client config.
     */
    public val clientConfig: Output<String>
        get() = javaResource.clientConfig().applyValue({ args0 -> args0 })

    /**
     * The client key.
     */
    public val clientKey: Output<String>
        get() = javaResource.clientKey().applyValue({ args0 -> args0 })

    /**
     * The name of the client certificate.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the SSL-VPN server.
     */
    public val sslVpnServerId: Output<String>
        get() = javaResource.sslVpnServerId().applyValue({ args0 -> args0 })

    /**
     * The status of the client certificate.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SslVpnClientCertMapper : ResourceMapper<SslVpnClientCert> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.SslVpnClientCert::class == javaResource::class

    override fun map(javaResource: Resource): SslVpnClientCert = SslVpnClientCert(
        javaResource as
            com.pulumi.alicloud.vpn.SslVpnClientCert,
    )
}

/**
 * @see [SslVpnClientCert].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SslVpnClientCert].
 */
public suspend fun sslVpnClientCert(
    name: String,
    block: suspend SslVpnClientCertResourceBuilder.() -> Unit,
): SslVpnClientCert {
    val builder = SslVpnClientCertResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SslVpnClientCert].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sslVpnClientCert(name: String): SslVpnClientCert {
    val builder = SslVpnClientCertResourceBuilder()
    builder.name(name)
    return builder.build()
}
