@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.SslVpnClientCertArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * ## Import
 * SSL-VPN client certificates can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/sslVpnClientCert:SslVpnClientCert example vsc-abc123456
 * ```
 * @property name The name of the client certificate.
 * @property sslVpnServerId The ID of the SSL-VPN server.
 */
public data class SslVpnClientCertArgs(
    public val name: Output<String>? = null,
    public val sslVpnServerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.SslVpnClientCertArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.SslVpnClientCertArgs =
        com.pulumi.alicloud.vpn.SslVpnClientCertArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sslVpnServerId(sslVpnServerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SslVpnClientCertArgs].
 */
@PulumiTagMarker
public class SslVpnClientCertArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sslVpnServerId: Output<String>? = null

    /**
     * @param value The name of the client certificate.
     */
    @JvmName("qdrmhxoiywbejdho")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the SSL-VPN server.
     */
    @JvmName("ctcpcdghwfowkflw")
    public suspend fun sslVpnServerId(`value`: Output<String>) {
        this.sslVpnServerId = value
    }

    /**
     * @param value The name of the client certificate.
     */
    @JvmName("hokbqaqvqtncbtap")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the SSL-VPN server.
     */
    @JvmName("pnsexmbilsedxtes")
    public suspend fun sslVpnServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslVpnServerId = mapped
    }

    internal fun build(): SslVpnClientCertArgs = SslVpnClientCertArgs(
        name = name,
        sslVpnServerId = sslVpnServerId,
    )
}
