@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SslVpnServer].
 */
@PulumiTagMarker
public class SslVpnServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SslVpnServerArgs = SslVpnServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SslVpnServerArgsBuilder.() -> Unit) {
        val builder = SslVpnServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SslVpnServer {
        val builtJavaResource = com.pulumi.alicloud.vpn.SslVpnServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SslVpnServer(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * ## Import
 * SSL-VPN server can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/sslVpnServer:SslVpnServer example vss-abc123456
 * ```
 */
public class SslVpnServer internal constructor(
    override val javaResource: com.pulumi.alicloud.vpn.SslVpnServer,
) : KotlinCustomResource(javaResource, SslVpnServerMapper) {
    /**
     * The encryption algorithm that is used in the SSL-VPN connection. Valid values: `AES-128-CBC`,`AES-192-CBC`,`AES-256-CBC`,`none`. Default value: `AES-128-CBC`.
     * * `AES-128-CBC` - the AES-128-CBC algorithm.
     * * `AES-192-CBC` - the AES-192-CBC algorithm.
     * * `AES-256-CBC` - the AES-256-CBC algorithm.
     */
    public val cipher: Output<String>?
        get() = javaResource.cipher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CIDR block from which access addresses are allocated to the virtual network interface card of the client.
     */
    public val clientIpPool: Output<String>
        get() = javaResource.clientIpPool().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable data compression. Valid values: `true`,`false`. Default value: `false`
     */
    public val compress: Output<Boolean>?
        get() = javaResource.compress().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The number of current connections.
     */
    public val connections: Output<Int>
        get() = javaResource.connections().applyValue({ args0 -> args0 })

    /**
     * The internet IP of the SSL-VPN server.
     */
    public val internetIp: Output<String>
        get() = javaResource.internetIp().applyValue({ args0 -> args0 })

    /**
     * The CIDR block to be accessed by the client through the SSL-VPN connection. It supports to set multi CIDRs by comma join ways, like `10.0.1.0/24,10.0.2.0/24,10.0.3.0/24`.
     */
    public val localSubnet: Output<String>
        get() = javaResource.localSubnet().applyValue({ args0 -> args0 })

    /**
     * The maximum number of connections.
     */
    public val maxConnections: Output<Int>
        get() = javaResource.maxConnections().applyValue({ args0 -> args0 })

    /**
     * The name of the SSL-VPN server.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The port used by the SSL-VPN server. The default value is `1194`.The following ports cannot be used: [22, 2222, 22222, 9000, 9001, 9002, 7505, 80, 443, 53, 68, 123, 4510, 4560, 500, 4500].
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The protocol used by the SSL-VPN server. Valid value: UDP(default) |TCP
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the VPN gateway.
     */
    public val vpnGatewayId: Output<String>
        get() = javaResource.vpnGatewayId().applyValue({ args0 -> args0 })
}

public object SslVpnServerMapper : ResourceMapper<SslVpnServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpn.SslVpnServer::class == javaResource::class

    override fun map(javaResource: Resource): SslVpnServer = SslVpnServer(
        javaResource as
            com.pulumi.alicloud.vpn.SslVpnServer,
    )
}

/**
 * @see [SslVpnServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SslVpnServer].
 */
public suspend fun sslVpnServer(
    name: String,
    block: suspend SslVpnServerResourceBuilder.() -> Unit,
): SslVpnServer {
    val builder = SslVpnServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SslVpnServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sslVpnServer(name: String): SslVpnServer {
    val builder = SslVpnServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
