@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.SslVpnServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * ## Import
 * SSL-VPN server can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpn/sslVpnServer:SslVpnServer example vss-abc123456
 * ```
 * @property cipher The encryption algorithm that is used in the SSL-VPN connection. Valid values: `AES-128-CBC`,`AES-192-CBC`,`AES-256-CBC`,`none`. Default value: `AES-128-CBC`.
 * * `AES-128-CBC` - the AES-128-CBC algorithm.
 * * `AES-192-CBC` - the AES-192-CBC algorithm.
 * * `AES-256-CBC` - the AES-256-CBC algorithm.
 * @property clientIpPool The CIDR block from which access addresses are allocated to the virtual network interface card of the client.
 * @property compress Specifies whether to enable data compression. Valid values: `true`,`false`. Default value: `false`
 * @property localSubnet The CIDR block to be accessed by the client through the SSL-VPN connection. It supports to set multi CIDRs by comma join ways, like `10.0.1.0/24,10.0.2.0/24,10.0.3.0/24`.
 * @property name The name of the SSL-VPN server.
 * @property port The port used by the SSL-VPN server. The default value is `1194`.The following ports cannot be used: [22, 2222, 22222, 9000, 9001, 9002, 7505, 80, 443, 53, 68, 123, 4510, 4560, 500, 4500].
 * @property protocol The protocol used by the SSL-VPN server. Valid value: UDP(default) |TCP
 * @property vpnGatewayId The ID of the VPN gateway.
 */
public data class SslVpnServerArgs(
    public val cipher: Output<String>? = null,
    public val clientIpPool: Output<String>? = null,
    public val compress: Output<Boolean>? = null,
    public val localSubnet: Output<String>? = null,
    public val name: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.SslVpnServerArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.SslVpnServerArgs =
        com.pulumi.alicloud.vpn.SslVpnServerArgs.builder()
            .cipher(cipher?.applyValue({ args0 -> args0 }))
            .clientIpPool(clientIpPool?.applyValue({ args0 -> args0 }))
            .compress(compress?.applyValue({ args0 -> args0 }))
            .localSubnet(localSubnet?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SslVpnServerArgs].
 */
@PulumiTagMarker
public class SslVpnServerArgsBuilder internal constructor() {
    private var cipher: Output<String>? = null

    private var clientIpPool: Output<String>? = null

    private var compress: Output<Boolean>? = null

    private var localSubnet: Output<String>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value The encryption algorithm that is used in the SSL-VPN connection. Valid values: `AES-128-CBC`,`AES-192-CBC`,`AES-256-CBC`,`none`. Default value: `AES-128-CBC`.
     * * `AES-128-CBC` - the AES-128-CBC algorithm.
     * * `AES-192-CBC` - the AES-192-CBC algorithm.
     * * `AES-256-CBC` - the AES-256-CBC algorithm.
     */
    @JvmName("pdroeyqndllvtbed")
    public suspend fun cipher(`value`: Output<String>) {
        this.cipher = value
    }

    /**
     * @param value The CIDR block from which access addresses are allocated to the virtual network interface card of the client.
     */
    @JvmName("wiexaiwouctqgfjp")
    public suspend fun clientIpPool(`value`: Output<String>) {
        this.clientIpPool = value
    }

    /**
     * @param value Specifies whether to enable data compression. Valid values: `true`,`false`. Default value: `false`
     */
    @JvmName("yopifjtbmhjrhumb")
    public suspend fun compress(`value`: Output<Boolean>) {
        this.compress = value
    }

    /**
     * @param value The CIDR block to be accessed by the client through the SSL-VPN connection. It supports to set multi CIDRs by comma join ways, like `10.0.1.0/24,10.0.2.0/24,10.0.3.0/24`.
     */
    @JvmName("ittqefpsbrmptqhl")
    public suspend fun localSubnet(`value`: Output<String>) {
        this.localSubnet = value
    }

    /**
     * @param value The name of the SSL-VPN server.
     */
    @JvmName("rllrrsanoyslgdiw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The port used by the SSL-VPN server. The default value is `1194`.The following ports cannot be used: [22, 2222, 22222, 9000, 9001, 9002, 7505, 80, 443, 53, 68, 123, 4510, 4560, 500, 4500].
     */
    @JvmName("umgfbujnxvggosri")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol used by the SSL-VPN server. Valid value: UDP(default) |TCP
     */
    @JvmName("ijjmcvlghukvqpvf")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The ID of the VPN gateway.
     */
    @JvmName("utteactnsxipljrw")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value The encryption algorithm that is used in the SSL-VPN connection. Valid values: `AES-128-CBC`,`AES-192-CBC`,`AES-256-CBC`,`none`. Default value: `AES-128-CBC`.
     * * `AES-128-CBC` - the AES-128-CBC algorithm.
     * * `AES-192-CBC` - the AES-192-CBC algorithm.
     * * `AES-256-CBC` - the AES-256-CBC algorithm.
     */
    @JvmName("ldimxtntohgxyosh")
    public suspend fun cipher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cipher = mapped
    }

    /**
     * @param value The CIDR block from which access addresses are allocated to the virtual network interface card of the client.
     */
    @JvmName("bvybooejfdfetjwo")
    public suspend fun clientIpPool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIpPool = mapped
    }

    /**
     * @param value Specifies whether to enable data compression. Valid values: `true`,`false`. Default value: `false`
     */
    @JvmName("tbdpbgstxkavtsfd")
    public suspend fun compress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compress = mapped
    }

    /**
     * @param value The CIDR block to be accessed by the client through the SSL-VPN connection. It supports to set multi CIDRs by comma join ways, like `10.0.1.0/24,10.0.2.0/24,10.0.3.0/24`.
     */
    @JvmName("vaibgueiywtswrho")
    public suspend fun localSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localSubnet = mapped
    }

    /**
     * @param value The name of the SSL-VPN server.
     */
    @JvmName("duugytefcuctpacj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The port used by the SSL-VPN server. The default value is `1194`.The following ports cannot be used: [22, 2222, 22222, 9000, 9001, 9002, 7505, 80, 443, 53, 68, 123, 4510, 4560, 500, 4500].
     */
    @JvmName("wrsqagvvfoxtqvge")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol used by the SSL-VPN server. Valid value: UDP(default) |TCP
     */
    @JvmName("sduqtaitqiboutae")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The ID of the VPN gateway.
     */
    @JvmName("shflhmgciircuemj")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): SslVpnServerArgs = SslVpnServerArgs(
        cipher = cipher,
        clientIpPool = clientIpPool,
        compress = compress,
        localSubnet = localSubnet,
        name = name,
        port = port,
        protocol = protocol,
        vpnGatewayId = vpnGatewayId,
    )
}
