@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin

import com.pulumi.alicloud.vpn.VpnFunctions.getConnectionsPlain
import com.pulumi.alicloud.vpn.VpnFunctions.getCustomerGatewaysPlain
import com.pulumi.alicloud.vpn.VpnFunctions.getGatewayVcoRoutesPlain
import com.pulumi.alicloud.vpn.VpnFunctions.getGatewayVpnAttachmentsPlain
import com.pulumi.alicloud.vpn.VpnFunctions.getGatewayZonesPlain
import com.pulumi.alicloud.vpn.VpnFunctions.getGatewaysPlain
import com.pulumi.alicloud.vpn.kotlin.inputs.GetConnectionsPlainArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GetConnectionsPlainArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GetCustomerGatewaysPlainArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GetCustomerGatewaysPlainArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewayVcoRoutesPlainArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewayVcoRoutesPlainArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewayVpnAttachmentsPlainArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewayVpnAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewayZonesPlainArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewayZonesPlainArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewaysPlainArgs
import com.pulumi.alicloud.vpn.kotlin.inputs.GetGatewaysPlainArgsBuilder
import com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsResult
import com.pulumi.alicloud.vpn.kotlin.outputs.GetCustomerGatewaysResult
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVcoRoutesResult
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsResult
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayZonesResult
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewaysResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsResult.Companion.toKotlin as getConnectionsResultToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GetCustomerGatewaysResult.Companion.toKotlin as getCustomerGatewaysResultToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVcoRoutesResult.Companion.toKotlin as getGatewayVcoRoutesResultToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsResult.Companion.toKotlin as getGatewayVpnAttachmentsResultToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayZonesResult.Companion.toKotlin as getGatewayZonesResultToKotlin
import com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewaysResult.Companion.toKotlin as getGatewaysResultToKotlin

public object VpnFunctions {
    /**
     * The VPN connections data source lists lots of VPN connections resource information owned by an Alicloud account.
     * > **NOTE:** Available since v1.18.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const foo = alicloud.vpn.getConnections({
     *     ids: ["fake-conn-id"],
     *     vpnGatewayId: "fake-vpn-id",
     *     customerGatewayId: "fake-cgw-id",
     *     outputFile: "/tmp/vpnconn",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * foo = alicloud.vpn.get_connections(ids=["fake-conn-id"],
     *     vpn_gateway_id="fake-vpn-id",
     *     customer_gateway_id="fake-cgw-id",
     *     output_file="/tmp/vpnconn")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = AliCloud.Vpn.GetConnections.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "fake-conn-id",
     *         },
     *         VpnGatewayId = "fake-vpn-id",
     *         CustomerGatewayId = "fake-cgw-id",
     *         OutputFile = "/tmp/vpnconn",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpn.GetConnections(ctx, &vpn.GetConnectionsArgs{
     * 			Ids: []string{
     * 				"fake-conn-id",
     * 			},
     * 			VpnGatewayId:      pulumi.StringRef("fake-vpn-id"),
     * 			CustomerGatewayId: pulumi.StringRef("fake-cgw-id"),
     * 			OutputFile:        pulumi.StringRef("/tmp/vpnconn"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpn.VpnFunctions;
     * import com.pulumi.alicloud.vpn.inputs.GetConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = VpnFunctions.getConnections(GetConnectionsArgs.builder()
     *             .ids("fake-conn-id")
     *             .vpnGatewayId("fake-vpn-id")
     *             .customerGatewayId("fake-cgw-id")
     *             .outputFile("/tmp/vpnconn")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpn:getConnections
     *       Arguments:
     *         ids:
     *           - fake-conn-id
     *         vpnGatewayId: fake-vpn-id
     *         customerGatewayId: fake-cgw-id
     *         outputFile: /tmp/vpnconn
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnections.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: GetConnectionsPlainArgs): GetConnectionsResult =
        getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getConnections].
     * @param customerGatewayId Use the VPN customer gateway ID as the search key.
     * @param ids IDs of the VPN connections.
     * @param nameRegex A regex string of VPN connection name.
     * @param outputFile Save the result to the file.
     * @param vpnGatewayId Use the VPN gateway ID as the search key.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(
        customerGatewayId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        vpnGatewayId: String? = null,
    ): GetConnectionsResult {
        val argument = GetConnectionsPlainArgs(
            customerGatewayId = customerGatewayId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            vpnGatewayId = vpnGatewayId,
        )
        return getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnections].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpn&#46;kotlin&#46;inputs&#46;GetConnectionsPlainArgs].
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: suspend GetConnectionsPlainArgsBuilder.() -> Unit): GetConnectionsResult {
        val builder = GetConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionsResultToKotlin(getConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPN customers gateways data source lists a number of VPN customer gateways resource information owned by an Alicloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const foo = alicloud.vpn.getCustomerGateways({
     *     nameRegex: "testAcc*",
     *     ids: [
     *         "fake-id1",
     *         "fake-id2",
     *     ],
     *     outputFile: "/tmp/cgws",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * foo = alicloud.vpn.get_customer_gateways(name_regex="testAcc*",
     *     ids=[
     *         "fake-id1",
     *         "fake-id2",
     *     ],
     *     output_file="/tmp/cgws")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = AliCloud.Vpn.GetCustomerGateways.Invoke(new()
     *     {
     *         NameRegex = "testAcc*",
     *         Ids = new[]
     *         {
     *             "fake-id1",
     *             "fake-id2",
     *         },
     *         OutputFile = "/tmp/cgws",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpn.GetCustomerGateways(ctx, &vpn.GetCustomerGatewaysArgs{
     * 			NameRegex: pulumi.StringRef("testAcc*"),
     * 			Ids: []string{
     * 				"fake-id1",
     * 				"fake-id2",
     * 			},
     * 			OutputFile: pulumi.StringRef("/tmp/cgws"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpn.VpnFunctions;
     * import com.pulumi.alicloud.vpn.inputs.GetCustomerGatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = VpnFunctions.getCustomerGateways(GetCustomerGatewaysArgs.builder()
     *             .nameRegex("testAcc*")
     *             .ids(
     *                 "fake-id1",
     *                 "fake-id2")
     *             .outputFile("/tmp/cgws")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpn:getCustomerGateways
     *       Arguments:
     *         nameRegex: testAcc*
     *         ids:
     *           - fake-id1
     *           - fake-id2
     *         outputFile: /tmp/cgws
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomerGateways.
     * @return A collection of values returned by getCustomerGateways.
     */
    public suspend fun getCustomerGateways(argument: GetCustomerGatewaysPlainArgs): GetCustomerGatewaysResult =
        getCustomerGatewaysResultToKotlin(getCustomerGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getCustomerGateways].
     * @param ids ID of the VPN customer gateways.
     * @param nameRegex A regex string of VPN customer gateways name.
     * @param outputFile Save the result to the file.
     * @return A collection of values returned by getCustomerGateways.
     */
    public suspend fun getCustomerGateways(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetCustomerGatewaysResult {
        val argument = GetCustomerGatewaysPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getCustomerGatewaysResultToKotlin(getCustomerGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomerGateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpn&#46;kotlin&#46;inputs&#46;GetCustomerGatewaysPlainArgs].
     * @return A collection of values returned by getCustomerGateways.
     */
    public suspend fun getCustomerGateways(argument: suspend GetCustomerGatewaysPlainArgsBuilder.() -> Unit): GetCustomerGatewaysResult {
        val builder = GetCustomerGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomerGatewaysResultToKotlin(getCustomerGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpn Gateway Vco Routes of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.183.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultInstance = new alicloud.cen.Instance("default", {cenInstanceName: name});
     * const defaultTransitRouter = new alicloud.cen.TransitRouter("default", {
     *     cenId: defaultInstance.id,
     *     transitRouterDescription: "desd",
     *     transitRouterName: name,
     * });
     * const default = alicloud.cen.getTransitRouterAvailableResources({});
     * const defaultCustomerGateway = new alicloud.vpn.CustomerGateway("default", {
     *     name: name,
     *     ipAddress: "42.104.22.210",
     *     asn: "45014",
     *     description: "testAccVpnConnectionDesc",
     * });
     * const defaultGatewayVpnAttachment = new alicloud.vpn.GatewayVpnAttachment("default", {
     *     customerGatewayId: defaultCustomerGateway.id,
     *     networkType: "public",
     *     localSubnet: "0.0.0.0/0",
     *     remoteSubnet: "0.0.0.0/0",
     *     effectImmediately: false,
     *     ikeConfig: {
     *         ikeAuthAlg: "md5",
     *         ikeEncAlg: "des",
     *         ikeVersion: "ikev2",
     *         ikeMode: "main",
     *         ikeLifetime: 86400,
     *         psk: "tf-testvpn2",
     *         ikePfs: "group1",
     *         remoteId: "testbob2",
     *         localId: "testalice2",
     *     },
     *     ipsecConfig: {
     *         ipsecPfs: "group5",
     *         ipsecEncAlg: "des",
     *         ipsecAuthAlg: "md5",
     *         ipsecLifetime: 86400,
     *     },
     *     bgpConfig: {
     *         enable: true,
     *         localAsn: 45014,
     *         tunnelCidr: "169.254.11.0/30",
     *         localBgpIp: "169.254.11.1",
     *     },
     *     healthCheckConfig: {
     *         enable: true,
     *         sip: "192.168.1.1",
     *         dip: "10.0.0.1",
     *         interval: 10,
     *         retry: 10,
     *         policy: "revoke_route",
     *     },
     *     enableDpd: true,
     *     enableNatTraversal: true,
     *     vpnAttachmentName: name,
     * });
     * const defaultTransitRouterVpnAttachment = new alicloud.cen.TransitRouterVpnAttachment("default", {
     *     autoPublishRouteEnabled: false,
     *     transitRouterAttachmentDescription: name,
     *     transitRouterAttachmentName: name,
     *     cenId: defaultTransitRouter.cenId,
     *     transitRouterId: defaultTransitRouter.transitRouterId,
     *     vpnId: defaultGatewayVpnAttachment.id,
     *     zones: [{
     *         zoneId: _default.then(_default => _default.resources?.[0]?&#46;masterZones?&#46;[0]),
     *     }],
     * });
     * const defaultGatewayVcoRoute = new alicloud.vpn.GatewayVcoRoute("default", {
     *     routeDest: "192.168.12.0/24",
     *     nextHop: defaultTransitRouterVpnAttachment.vpnId,
     *     vpnConnectionId: defaultTransitRouterVpnAttachment.vpnId,
     *     weight: 100,
     * });
     * const defaultGetGatewayVcoRoutes = alicloud.vpn.getGatewayVcoRoutesOutput({
     *     vpnConnectionId: defaultTransitRouterVpnAttachment.vpnId,
     * });
     * export const vpnGatewayVcoRouteId1 = ids.routes[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
     * default_transit_router = alicloud.cen.TransitRouter("default",
     *     cen_id=default_instance.id,
     *     transit_router_description="desd",
     *     transit_router_name=name)
     * default = alicloud.cen.get_transit_router_available_resources()
     * default_customer_gateway = alicloud.vpn.CustomerGateway("default",
     *     name=name,
     *     ip_address="42.104.22.210",
     *     asn="45014",
     *     description="testAccVpnConnectionDesc")
     * default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
     *     customer_gateway_id=default_customer_gateway.id,
     *     network_type="public",
     *     local_subnet="0.0.0.0/0",
     *     remote_subnet="0.0.0.0/0",
     *     effect_immediately=False,
     *     ike_config={
     *         "ike_auth_alg": "md5",
     *         "ike_enc_alg": "des",
     *         "ike_version": "ikev2",
     *         "ike_mode": "main",
     *         "ike_lifetime": 86400,
     *         "psk": "tf-testvpn2",
     *         "ike_pfs": "group1",
     *         "remote_id": "testbob2",
     *         "local_id": "testalice2",
     *     },
     *     ipsec_config={
     *         "ipsec_pfs": "group5",
     *         "ipsec_enc_alg": "des",
     *         "ipsec_auth_alg": "md5",
     *         "ipsec_lifetime": 86400,
     *     },
     *     bgp_config={
     *         "enable": True,
     *         "local_asn": 45014,
     *         "tunnel_cidr": "169.254.11.0/30",
     *         "local_bgp_ip": "169.254.11.1",
     *     },
     *     health_check_config={
     *         "enable": True,
     *         "sip": "192.168.1.1",
     *         "dip": "10.0.0.1",
     *         "interval": 10,
     *         "retry": 10,
     *         "policy": "revoke_route",
     *     },
     *     enable_dpd=True,
     *     enable_nat_traversal=True,
     *     vpn_attachment_name=name)
     * default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
     *     auto_publish_route_enabled=False,
     *     transit_router_attachment_description=name,
     *     transit_router_attachment_name=name,
     *     cen_id=default_transit_router.cen_id,
     *     transit_router_id=default_transit_router.transit_router_id,
     *     vpn_id=default_gateway_vpn_attachment.id,
     *     zones=[{
     *         "zone_id": default.resources[0]&#46;master_zones[0],
     *     }])
     * default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("default",
     *     route_dest="192.168.12.0/24",
     *     next_hop=default_transit_router_vpn_attachment.vpn_id,
     *     vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
     *     weight=100)
     * default_get_gateway_vco_routes = alicloud.vpn.get_gateway_vco_routes_output(vpn_connection_id=default_transit_router_vpn_attachment.vpn_id)
     * pulumi.export("vpnGatewayVcoRouteId1", ids["routes"][0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultInstance = new AliCloud.Cen.Instance("default", new()
     *     {
     *         CenInstanceName = name,
     *     });
     *     var defaultTransitRouter = new AliCloud.Cen.TransitRouter("default", new()
     *     {
     *         CenId = defaultInstance.Id,
     *         TransitRouterDescription = "desd",
     *         TransitRouterName = name,
     *     });
     *     var @default = AliCloud.Cen.GetTransitRouterAvailableResources.Invoke();
     *     var defaultCustomerGateway = new AliCloud.Vpn.CustomerGateway("default", new()
     *     {
     *         Name = name,
     *         IpAddress = "42.104.22.210",
     *         Asn = "45014",
     *         Description = "testAccVpnConnectionDesc",
     *     });
     *     var defaultGatewayVpnAttachment = new AliCloud.Vpn.GatewayVpnAttachment("default", new()
     *     {
     *         CustomerGatewayId = defaultCustomerGateway.Id,
     *         NetworkType = "public",
     *         LocalSubnet = "0.0.0.0/0",
     *         RemoteSubnet = "0.0.0.0/0",
     *         EffectImmediately = false,
     *         IkeConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIkeConfigArgs
     *         {
     *             IkeAuthAlg = "md5",
     *             IkeEncAlg = "des",
     *             IkeVersion = "ikev2",
     *             IkeMode = "main",
     *             IkeLifetime = 86400,
     *             Psk = "tf-testvpn2",
     *             IkePfs = "group1",
     *             RemoteId = "testbob2",
     *             LocalId = "testalice2",
     *         },
     *         IpsecConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIpsecConfigArgs
     *         {
     *             IpsecPfs = "group5",
     *             IpsecEncAlg = "des",
     *             IpsecAuthAlg = "md5",
     *             IpsecLifetime = 86400,
     *         },
     *         BgpConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentBgpConfigArgs
     *         {
     *             Enable = true,
     *             LocalAsn = 45014,
     *             TunnelCidr = "169.254.11.0/30",
     *             LocalBgpIp = "169.254.11.1",
     *         },
     *         HealthCheckConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentHealthCheckConfigArgs
     *         {
     *             Enable = true,
     *             Sip = "192.168.1.1",
     *             Dip = "10.0.0.1",
     *             Interval = 10,
     *             Retry = 10,
     *             Policy = "revoke_route",
     *         },
     *         EnableDpd = true,
     *         EnableNatTraversal = true,
     *         VpnAttachmentName = name,
     *     });
     *     var defaultTransitRouterVpnAttachment = new AliCloud.Cen.TransitRouterVpnAttachment("default", new()
     *     {
     *         AutoPublishRouteEnabled = false,
     *         TransitRouterAttachmentDescription = name,
     *         TransitRouterAttachmentName = name,
     *         CenId = defaultTransitRouter.CenId,
     *         TransitRouterId = defaultTransitRouter.TransitRouterId,
     *         VpnId = defaultGatewayVpnAttachment.Id,
     *         Zones = new[]
     *         {
     *             new AliCloud.Cen.Inputs.TransitRouterVpnAttachmentZoneArgs
     *             {
     *                 ZoneId = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;MasterZones[0])),
     *             },
     *         },
     *     });
     *     var defaultGatewayVcoRoute = new AliCloud.Vpn.GatewayVcoRoute("default", new()
     *     {
     *         RouteDest = "192.168.12.0/24",
     *         NextHop = defaultTransitRouterVpnAttachment.VpnId,
     *         VpnConnectionId = defaultTransitRouterVpnAttachment.VpnId,
     *         Weight = 100,
     *     });
     *     var defaultGetGatewayVcoRoutes = AliCloud.Vpn.GetGatewayVcoRoutes.Invoke(new()
     *     {
     *         VpnConnectionId = defaultTransitRouterVpnAttachment.VpnId,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpnGatewayVcoRouteId1"] = ids&#46;Routes[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultInstance, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
     * 			CenInstanceName: pulumi.Any(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultTransitRouter, err := cen.NewTransitRouter(ctx, "default", &cen.TransitRouterArgs{
     * 			CenId:                    defaultInstance.ID(),
     * 			TransitRouterDescription: pulumi.String("desd"),
     * 			TransitRouterName:        pulumi.Any(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_default, err := cen.GetTransitRouterAvailableResources(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultCustomerGateway, err := vpn.NewCustomerGateway(ctx, "default", &vpn.CustomerGatewayArgs{
     * 			Name:        pulumi.Any(name),
     * 			IpAddress:   pulumi.String("42.104.22.210"),
     * 			Asn:         pulumi.String("45014"),
     * 			Description: pulumi.String("testAccVpnConnectionDesc"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGatewayVpnAttachment, err := vpn.NewGatewayVpnAttachment(ctx, "default", &vpn.GatewayVpnAttachmentArgs{
     * 			CustomerGatewayId: defaultCustomerGateway.ID(),
     * 			NetworkType:       pulumi.String("public"),
     * 			LocalSubnet:       pulumi.String("0.0.0.0/0"),
     * 			RemoteSubnet:      pulumi.String("0.0.0.0/0"),
     * 			EffectImmediately: pulumi.Bool(false),
     * 			IkeConfig: &vpn.GatewayVpnAttachmentIkeConfigArgs{
     * 				IkeAuthAlg:  pulumi.String("md5"),
     * 				IkeEncAlg:   pulumi.String("des"),
     * 				IkeVersion:  pulumi.String("ikev2"),
     * 				IkeMode:     pulumi.String("main"),
     * 				IkeLifetime: pulumi.Int(86400),
     * 				Psk:         pulumi.String("tf-testvpn2"),
     * 				IkePfs:      pulumi.String("group1"),
     * 				RemoteId:    pulumi.String("testbob2"),
     * 				LocalId:     pulumi.String("testalice2"),
     * 			},
     * 			IpsecConfig: &vpn.GatewayVpnAttachmentIpsecConfigArgs{
     * 				IpsecPfs:      pulumi.String("group5"),
     * 				IpsecEncAlg:   pulumi.String("des"),
     * 				IpsecAuthAlg:  pulumi.String("md5"),
     * 				IpsecLifetime: pulumi.Int(86400),
     * 			},
     * 			BgpConfig: &vpn.GatewayVpnAttachmentBgpConfigArgs{
     * 				Enable:     pulumi.Bool(true),
     * 				LocalAsn:   pulumi.Int(45014),
     * 				TunnelCidr: pulumi.String("169.254.11.0/30"),
     * 				LocalBgpIp: pulumi.String("169.254.11.1"),
     * 			},
     * 			HealthCheckConfig: &vpn.GatewayVpnAttachmentHealthCheckConfigArgs{
     * 				Enable:   pulumi.Bool(true),
     * 				Sip:      pulumi.String("192.168.1.1"),
     * 				Dip:      pulumi.String("10.0.0.1"),
     * 				Interval: pulumi.Int(10),
     * 				Retry:    pulumi.Int(10),
     * 				Policy:   pulumi.String("revoke_route"),
     * 			},
     * 			EnableDpd:          pulumi.Bool(true),
     * 			EnableNatTraversal: pulumi.Bool(true),
     * 			VpnAttachmentName:  pulumi.Any(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultTransitRouterVpnAttachment, err := cen.NewTransitRouterVpnAttachment(ctx, "default", &cen.TransitRouterVpnAttachmentArgs{
     * 			AutoPublishRouteEnabled:            pulumi.Bool(false),
     * 			TransitRouterAttachmentDescription: pulumi.Any(name),
     * 			TransitRouterAttachmentName:        pulumi.Any(name),
     * 			CenId:                              defaultTransitRouter.CenId,
     * 			TransitRouterId:                    defaultTransitRouter.TransitRouterId,
     * 			VpnId:                              defaultGatewayVpnAttachment.ID(),
     * 			Zones: cen.TransitRouterVpnAttachmentZoneArray{
     * 				&cen.TransitRouterVpnAttachmentZoneArgs{
     * 					ZoneId: pulumi.String(_default.Resources[0]&#46;MasterZones[0]),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = vpn.NewGatewayVcoRoute(ctx, "default", &vpn.GatewayVcoRouteArgs{
     * 			RouteDest:       pulumi.String("192.168.12.0/24"),
     * 			NextHop:         defaultTransitRouterVpnAttachment.VpnId,
     * 			VpnConnectionId: defaultTransitRouterVpnAttachment.VpnId,
     * 			Weight:          pulumi.Int(100),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = vpn.GetGatewayVcoRoutesOutput(ctx, vpn.GetGatewayVcoRoutesOutputArgs{
     * 			VpnConnectionId: defaultTransitRouterVpnAttachment.VpnId,
     * 		}, nil)
     * 		ctx.Export("vpnGatewayVcoRouteId1", ids.Routes[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.Instance;
     * import com.pulumi.alicloud.cen.InstanceArgs;
     * import com.pulumi.alicloud.cen.TransitRouter;
     * import com.pulumi.alicloud.cen.TransitRouterArgs;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesArgs;
     * import com.pulumi.alicloud.vpn.CustomerGateway;
     * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
     * import com.pulumi.alicloud.vpn.GatewayVpnAttachment;
     * import com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs;
     * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs;
     * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs;
     * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs;
     * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs;
     * import com.pulumi.alicloud.cen.TransitRouterVpnAttachment;
     * import com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs;
     * import com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs;
     * import com.pulumi.alicloud.vpn.GatewayVcoRoute;
     * import com.pulumi.alicloud.vpn.GatewayVcoRouteArgs;
     * import com.pulumi.alicloud.vpn.VpnFunctions;
     * import com.pulumi.alicloud.vpn.inputs.GetGatewayVcoRoutesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
     *             .cenInstanceName(name)
     *             .build());
     *         var defaultTransitRouter = new TransitRouter("defaultTransitRouter", TransitRouterArgs.builder()
     *             .cenId(defaultInstance.id())
     *             .transitRouterDescription("desd")
     *             .transitRouterName(name)
     *             .build());
     *         final var default = CenFunctions.getTransitRouterAvailableResources();
     *         var defaultCustomerGateway = new CustomerGateway("defaultCustomerGateway", CustomerGatewayArgs.builder()
     *             .name(name)
     *             .ipAddress("42.104.22.210")
     *             .asn("45014")
     *             .description("testAccVpnConnectionDesc")
     *             .build());
     *         var defaultGatewayVpnAttachment = new GatewayVpnAttachment("defaultGatewayVpnAttachment", GatewayVpnAttachmentArgs.builder()
     *             .customerGatewayId(defaultCustomerGateway.id())
     *             .networkType("public")
     *             .localSubnet("0.0.0.0/0")
     *             .remoteSubnet("0.0.0.0/0")
     *             .effectImmediately(false)
     *             .ikeConfig(GatewayVpnAttachmentIkeConfigArgs.builder()
     *                 .ikeAuthAlg("md5")
     *                 .ikeEncAlg("des")
     *                 .ikeVersion("ikev2")
     *                 .ikeMode("main")
     *                 .ikeLifetime(86400)
     *                 .psk("tf-testvpn2")
     *                 .ikePfs("group1")
     *                 .remoteId("testbob2")
     *                 .localId("testalice2")
     *                 .build())
     *             .ipsecConfig(GatewayVpnAttachmentIpsecConfigArgs.builder()
     *                 .ipsecPfs("group5")
     *                 .ipsecEncAlg("des")
     *                 .ipsecAuthAlg("md5")
     *                 .ipsecLifetime(86400)
     *                 .build())
     *             .bgpConfig(GatewayVpnAttachmentBgpConfigArgs.builder()
     *                 .enable(true)
     *                 .localAsn(45014)
     *                 .tunnelCidr("169.254.11.0/30")
     *                 .localBgpIp("169.254.11.1")
     *                 .build())
     *             .healthCheckConfig(GatewayVpnAttachmentHealthCheckConfigArgs.builder()
     *                 .enable(true)
     *                 .sip("192.168.1.1")
     *                 .dip("10.0.0.1")
     *                 .interval(10)
     *                 .retry(10)
     *                 .policy("revoke_route")
     *                 .build())
     *             .enableDpd(true)
     *             .enableNatTraversal(true)
     *             .vpnAttachmentName(name)
     *             .build());
     *         var defaultTransitRouterVpnAttachment = new TransitRouterVpnAttachment("defaultTransitRouterVpnAttachment", TransitRouterVpnAttachmentArgs.builder()
     *             .autoPublishRouteEnabled(false)
     *             .transitRouterAttachmentDescription(name)
     *             .transitRouterAttachmentName(name)
     *             .cenId(defaultTransitRouter.cenId())
     *             .transitRouterId(defaultTransitRouter.transitRouterId())
     *             .vpnId(defaultGatewayVpnAttachment.id())
     *             .zones(TransitRouterVpnAttachmentZoneArgs.builder()
     *                 .zoneId(default_.resources()[0]&#46;masterZones()[0])
     *                 .build())
     *             .build());
     *         var defaultGatewayVcoRoute = new GatewayVcoRoute("defaultGatewayVcoRoute", GatewayVcoRouteArgs.builder()
     *             .routeDest("192.168.12.0/24")
     *             .nextHop(defaultTransitRouterVpnAttachment.vpnId())
     *             .vpnConnectionId(defaultTransitRouterVpnAttachment.vpnId())
     *             .weight(100)
     *             .build());
     *         final var defaultGetGatewayVcoRoutes = VpnFunctions.getGatewayVcoRoutes(GetGatewayVcoRoutesArgs.builder()
     *             .vpnConnectionId(defaultTransitRouterVpnAttachment.vpnId())
     *             .build());
     *         ctx.export("vpnGatewayVcoRouteId1", ids.routes()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultInstance:
     *     type: alicloud:cen:Instance
     *     name: default
     *     properties:
     *       cenInstanceName: ${name}
     *   defaultTransitRouter:
     *     type: alicloud:cen:TransitRouter
     *     name: default
     *     properties:
     *       cenId: ${defaultInstance.id}
     *       transitRouterDescription: desd
     *       transitRouterName: ${name}
     *   defaultCustomerGateway:
     *     type: alicloud:vpn:CustomerGateway
     *     name: default
     *     properties:
     *       name: ${name}
     *       ipAddress: 42.104.22.210
     *       asn: '45014'
     *       description: testAccVpnConnectionDesc
     *   defaultGatewayVpnAttachment:
     *     type: alicloud:vpn:GatewayVpnAttachment
     *     name: default
     *     properties:
     *       customerGatewayId: ${defaultCustomerGateway.id}
     *       networkType: public
     *       localSubnet: 0.0.0.0/0
     *       remoteSubnet: 0.0.0.0/0
     *       effectImmediately: false
     *       ikeConfig:
     *         ikeAuthAlg: md5
     *         ikeEncAlg: des
     *         ikeVersion: ikev2
     *         ikeMode: main
     *         ikeLifetime: 86400
     *         psk: tf-testvpn2
     *         ikePfs: group1
     *         remoteId: testbob2
     *         localId: testalice2
     *       ipsecConfig:
     *         ipsecPfs: group5
     *         ipsecEncAlg: des
     *         ipsecAuthAlg: md5
     *         ipsecLifetime: 86400
     *       bgpConfig:
     *         enable: true
     *         localAsn: 45014
     *         tunnelCidr: 169.254.11.0/30
     *         localBgpIp: 169.254.11.1
     *       healthCheckConfig:
     *         enable: true
     *         sip: 192.168.1.1
     *         dip: 10.0.0.1
     *         interval: 10
     *         retry: 10
     *         policy: revoke_route
     *       enableDpd: true
     *       enableNatTraversal: true
     *       vpnAttachmentName: ${name}
     *   defaultTransitRouterVpnAttachment:
     *     type: alicloud:cen:TransitRouterVpnAttachment
     *     name: default
     *     properties:
     *       autoPublishRouteEnabled: false
     *       transitRouterAttachmentDescription: ${name}
     *       transitRouterAttachmentName: ${name}
     *       cenId: ${defaultTransitRouter.cenId}
     *       transitRouterId: ${defaultTransitRouter.transitRouterId}
     *       vpnId: ${defaultGatewayVpnAttachment.id}
     *       zones:
     *         - zoneId: ${default.resources[0]&#46;masterZones[0]}
     *   defaultGatewayVcoRoute:
     *     type: alicloud:vpn:GatewayVcoRoute
     *     name: default
     *     properties:
     *       routeDest: 192.168.12.0/24
     *       nextHop: ${defaultTransitRouterVpnAttachment.vpnId}
     *       vpnConnectionId: ${defaultTransitRouterVpnAttachment.vpnId}
     *       weight: 100
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterAvailableResources
     *       Arguments: {}
     *   defaultGetGatewayVcoRoutes:
     *     fn::invoke:
     *       Function: alicloud:vpn:getGatewayVcoRoutes
     *       Arguments:
     *         vpnConnectionId: ${defaultTransitRouterVpnAttachment.vpnId}
     * outputs:
     *   vpnGatewayVcoRouteId1: ${ids.routes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayVcoRoutes.
     * @return A collection of values returned by getGatewayVcoRoutes.
     */
    public suspend fun getGatewayVcoRoutes(argument: GetGatewayVcoRoutesPlainArgs): GetGatewayVcoRoutesResult =
        getGatewayVcoRoutesResultToKotlin(getGatewayVcoRoutesPlain(argument.toJava()).await())

    /**
     * @see [getGatewayVcoRoutes].
     * @param ids A list of Vco Route IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param routeEntryType The Routing input type. Valid values: `custom`, `bgp`.
     * @param status The status of the vpn route entry. Valid values: `normal`, `published`.
     * @param vpnConnectionId The id of the vpn connection.
     * @return A collection of values returned by getGatewayVcoRoutes.
     */
    public suspend fun getGatewayVcoRoutes(
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        routeEntryType: String? = null,
        status: String? = null,
        vpnConnectionId: String,
    ): GetGatewayVcoRoutesResult {
        val argument = GetGatewayVcoRoutesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            routeEntryType = routeEntryType,
            status = status,
            vpnConnectionId = vpnConnectionId,
        )
        return getGatewayVcoRoutesResultToKotlin(getGatewayVcoRoutesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayVcoRoutes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpn&#46;kotlin&#46;inputs&#46;GetGatewayVcoRoutesPlainArgs].
     * @return A collection of values returned by getGatewayVcoRoutes.
     */
    public suspend fun getGatewayVcoRoutes(argument: suspend GetGatewayVcoRoutesPlainArgsBuilder.() -> Unit): GetGatewayVcoRoutesResult {
        val builder = GetGatewayVcoRoutesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayVcoRoutesResultToKotlin(getGatewayVcoRoutesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpn Gateway Vpn Attachments of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.181.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpn.getGatewayVpnAttachments({});
     * export const vpnGatewayVpnAttachmentId1 = ids.then(ids => ids.attachments?.[0]?.id);
     * const nameRegex = alicloud.vpn.getGatewayVpnAttachments({
     *     nameRegex: "^my-VpnAttachment",
     * });
     * export const vpnGatewayVpnAttachmentId2 = nameRegex.then(nameRegex => nameRegex.attachments?.[0]?.id);
     * export const localId = vpnAttachments.attachments[0]&#46;ikeConfig[0].localId;
     * export const internetIp = vpnAttachments.attachments[0].internetIp;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpn.get_gateway_vpn_attachments()
     * pulumi.export("vpnGatewayVpnAttachmentId1", ids.attachments[0].id)
     * name_regex = alicloud.vpn.get_gateway_vpn_attachments(name_regex="^my-VpnAttachment")
     * pulumi.export("vpnGatewayVpnAttachmentId2", name_regex.attachments[0].id)
     * pulumi.export("localId", vpn_attachments["attachments"][0]["ikeConfig"][0]["localId"])
     * pulumi.export("internetIp", vpn_attachments["attachments"][0]["internetIp"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpn.GetGatewayVpnAttachments.Invoke();
     *     var nameRegex = AliCloud.Vpn.GetGatewayVpnAttachments.Invoke(new()
     *     {
     *         NameRegex = "^my-VpnAttachment",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpnGatewayVpnAttachmentId1"] = ids&#46;Apply(getGatewayVpnAttachmentsResult => getGatewayVpnAttachmentsResult&#46;Attachments[0]?.Id),
     *         ["vpnGatewayVpnAttachmentId2"] = nameRegex&#46;Apply(getGatewayVpnAttachmentsResult => getGatewayVpnAttachmentsResult&#46;Attachments[0]?.Id),
     *         ["localId"] = vpnAttachments&#46;Attachments[0]&#46;IkeConfig[0].LocalId,
     *         ["internetIp"] = vpnAttachments&#46;Attachments[0].InternetIp,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpn.GetGatewayVpnAttachments(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpnGatewayVpnAttachmentId1", ids.Attachments[0].Id)
     * 		nameRegex, err := vpn.GetGatewayVpnAttachments(ctx, &vpn.GetGatewayVpnAttachmentsArgs{
     * 			NameRegex: pulumi.StringRef("^my-VpnAttachment"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpnGatewayVpnAttachmentId2", nameRegex.Attachments[0].Id)
     * 		ctx.Export("localId", vpnAttachments.Attachments[0]&#46;IkeConfig[0].LocalId)
     * 		ctx.Export("internetIp", vpnAttachments.Attachments[0].InternetIp)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpn.VpnFunctions;
     * import com.pulumi.alicloud.vpn.inputs.GetGatewayVpnAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpnFunctions.getGatewayVpnAttachments();
     *         ctx.export("vpnGatewayVpnAttachmentId1", ids.applyValue(getGatewayVpnAttachmentsResult -> getGatewayVpnAttachmentsResult.attachments()[0].id()));
     *         final var nameRegex = VpnFunctions.getGatewayVpnAttachments(GetGatewayVpnAttachmentsArgs.builder()
     *             .nameRegex("^my-VpnAttachment")
     *             .build());
     *         ctx.export("vpnGatewayVpnAttachmentId2", nameRegex.applyValue(getGatewayVpnAttachmentsResult -> getGatewayVpnAttachmentsResult.attachments()[0].id()));
     *         ctx.export("localId", vpnAttachments.attachments()[0]&#46;ikeConfig()[0].localId());
     *         ctx.export("internetIp", vpnAttachments.attachments()[0].internetIp());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpn:getGatewayVpnAttachments
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpn:getGatewayVpnAttachments
     *       Arguments:
     *         nameRegex: ^my-VpnAttachment
     * outputs:
     *   vpnGatewayVpnAttachmentId1: ${ids.attachments[0].id}
     *   vpnGatewayVpnAttachmentId2: ${nameRegex.attachments[0].id}
     *   localId: ${vpnAttachments.attachments[0]&#46;ikeConfig[0].localId}
     *   internetIp: ${vpnAttachments.attachments[0].internetIp}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayVpnAttachments.
     * @return A collection of values returned by getGatewayVpnAttachments.
     */
    public suspend fun getGatewayVpnAttachments(argument: GetGatewayVpnAttachmentsPlainArgs): GetGatewayVpnAttachmentsResult =
        getGatewayVpnAttachmentsResultToKotlin(getGatewayVpnAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getGatewayVpnAttachments].
     * @param ids A list of Vpn Attachment IDs.
     * @param nameRegex A regex string to filter results by Vpn Attachment name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
     * @param vpnGatewayId The parameter 'vpn_gateway_id' has been deprecated from 1.194.0.
     * @return A collection of values returned by getGatewayVpnAttachments.
     */
    public suspend fun getGatewayVpnAttachments(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
        vpnGatewayId: String? = null,
    ): GetGatewayVpnAttachmentsResult {
        val argument = GetGatewayVpnAttachmentsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
            vpnGatewayId = vpnGatewayId,
        )
        return getGatewayVpnAttachmentsResultToKotlin(getGatewayVpnAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayVpnAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpn&#46;kotlin&#46;inputs&#46;GetGatewayVpnAttachmentsPlainArgs].
     * @return A collection of values returned by getGatewayVpnAttachments.
     */
    public suspend fun getGatewayVpnAttachments(argument: suspend GetGatewayVpnAttachmentsPlainArgsBuilder.() -> Unit): GetGatewayVpnAttachmentsResult {
        val builder = GetGatewayVpnAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayVpnAttachmentsResultToKotlin(getGatewayVpnAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides VPN Gateway Zone available to the user.[What is Zone](https://next.api.alibabacloud.com/api/Vpc/2016-04-28/DescribeVpnGatewayAvailableZones?lang=JAVA)
     * > **NOTE:** Available since v1.216.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.vpn.getGatewayZones({
     *     spec: "5M",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.vpn.get_gateway_zones(spec="5M")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Vpn.GetGatewayZones.Invoke(new()
     *     {
     *         Spec = "5M",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpn.GetGatewayZones(ctx, &vpn.GetGatewayZonesArgs{
     * 			Spec: "5M",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpn.VpnFunctions;
     * import com.pulumi.alicloud.vpn.inputs.GetGatewayZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = VpnFunctions.getGatewayZones(GetGatewayZonesArgs.builder()
     *             .spec("5M")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:vpn:getGatewayZones
     *       Arguments:
     *         spec: 5M
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayZones.
     * @return A collection of values returned by getGatewayZones.
     */
    public suspend fun getGatewayZones(argument: GetGatewayZonesPlainArgs): GetGatewayZonesResult =
        getGatewayZonesResultToKotlin(getGatewayZonesPlain(argument.toJava()).await())

    /**
     * @see [getGatewayZones].
     * @param ids A list of Zone IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param spec Bandwidth specification.-If an IPsec connection is bound to a VPN gateway instance, this parameter indicates the Bandwidth specification of the VPN gateway instance.-If an IPsec connection is bound to a forwarding router, this parameter indicates the bandwidth that you expect the IPsec connection to support.Different bandwidth specifications may affect the zone information that is found. Value:
     * - `5M`
     * - `10M`
     * - `20M`
     * - `50M`
     * - `100M`
     * - `200M`
     * - `500M`
     * - `1000M`
     * @return A collection of values returned by getGatewayZones.
     */
    public suspend fun getGatewayZones(
        ids: List<String>? = null,
        outputFile: String? = null,
        spec: String,
    ): GetGatewayZonesResult {
        val argument = GetGatewayZonesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            spec = spec,
        )
        return getGatewayZonesResultToKotlin(getGatewayZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpn&#46;kotlin&#46;inputs&#46;GetGatewayZonesPlainArgs].
     * @return A collection of values returned by getGatewayZones.
     */
    public suspend fun getGatewayZones(argument: suspend GetGatewayZonesPlainArgsBuilder.() -> Unit): GetGatewayZonesResult {
        val builder = GetGatewayZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayZonesResultToKotlin(getGatewayZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPNs data source lists a number of VPNs resource information owned by an Alicloud account.
     * > **NOTE:** Available since v1.18.0.
     * @param argument A collection of arguments for invoking getGateways.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: GetGatewaysPlainArgs): GetGatewaysResult =
        getGatewaysResultToKotlin(getGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getGateways].
     * @param businessStatus Limit search to specific business status - valid value is "Normal", "FinancialLocked".
     * @param enableIpsec Indicates whether the IPsec-VPN feature is enabled.
     * @param ids IDs of the VPN.
     * @param includeReservationData Include ineffective ordering data.
     * @param nameRegex A regex string of VPN name.
     * @param outputFile Save the result to the file.
     * @param status Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
     * @param vpcId Use the VPC ID as the search key.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(
        businessStatus: String? = null,
        enableIpsec: Boolean? = null,
        ids: List<String>? = null,
        includeReservationData: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        vpcId: String? = null,
    ): GetGatewaysResult {
        val argument = GetGatewaysPlainArgs(
            businessStatus = businessStatus,
            enableIpsec = enableIpsec,
            ids = ids,
            includeReservationData = includeReservationData,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            vpcId = vpcId,
        )
        return getGatewaysResultToKotlin(getGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpn&#46;kotlin&#46;inputs&#46;GetGatewaysPlainArgs].
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: suspend GetGatewaysPlainArgsBuilder.() -> Unit): GetGatewaysResult {
        val builder = GetGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewaysResultToKotlin(getGatewaysPlain(builtArgument.toJava()).await())
    }
}
