@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionBgpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable Bgp enable.
 * @property localAsn Local asn.
 * @property localBgpIp Local bgp IP.
 * @property status The negotiation status of Tunnel.
 * @property tunnelCidr IPSec tunnel Cidr.
 */
public data class ConnectionBgpConfigArgs(
    public val enable: Output<Boolean>? = null,
    public val localAsn: Output<String>? = null,
    public val localBgpIp: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tunnelCidr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionBgpConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionBgpConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionBgpConfigArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .localAsn(localAsn?.applyValue({ args0 -> args0 }))
            .localBgpIp(localBgpIp?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tunnelCidr(tunnelCidr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionBgpConfigArgs].
 */
@PulumiTagMarker
public class ConnectionBgpConfigArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var localAsn: Output<String>? = null

    private var localBgpIp: Output<String>? = null

    private var status: Output<String>? = null

    private var tunnelCidr: Output<String>? = null

    /**
     * @param value Bgp enable.
     */
    @JvmName("gvelspdikdqcbyia")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Local asn.
     */
    @JvmName("dmddqajlmxwjghkd")
    public suspend fun localAsn(`value`: Output<String>) {
        this.localAsn = value
    }

    /**
     * @param value Local bgp IP.
     */
    @JvmName("iuuapwjcabfdoiwl")
    public suspend fun localBgpIp(`value`: Output<String>) {
        this.localBgpIp = value
    }

    /**
     * @param value The negotiation status of Tunnel.
     */
    @JvmName("sarilyxrwotpsqcj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value IPSec tunnel Cidr.
     */
    @JvmName("filrokgxlnhylspb")
    public suspend fun tunnelCidr(`value`: Output<String>) {
        this.tunnelCidr = value
    }

    /**
     * @param value Bgp enable.
     */
    @JvmName("ulixxhxutgruxpnr")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Local asn.
     */
    @JvmName("ocrcrubrccmwewnw")
    public suspend fun localAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAsn = mapped
    }

    /**
     * @param value Local bgp IP.
     */
    @JvmName("drojkowwvkvyextn")
    public suspend fun localBgpIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBgpIp = mapped
    }

    /**
     * @param value The negotiation status of Tunnel.
     */
    @JvmName("cujlxcxwucssiarh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value IPSec tunnel Cidr.
     */
    @JvmName("kjrwrjukhbdhwslt")
    public suspend fun tunnelCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelCidr = mapped
    }

    internal fun build(): ConnectionBgpConfigArgs = ConnectionBgpConfigArgs(
        enable = enable,
        localAsn = localAsn,
        localBgpIp = localBgpIp,
        status = status,
        tunnelCidr = tunnelCidr,
    )
}
