@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionHealthCheckConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dip Destination IP.
 * @property enable Specifies whether to enable healthcheck.
 * @property interval Retry interval.
 * @property retry retry times.
 * @property sip Source IP.
 */
public data class ConnectionHealthCheckConfigArgs(
    public val dip: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val interval: Output<Int>? = null,
    public val retry: Output<Int>? = null,
    public val sip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionHealthCheckConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionHealthCheckConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionHealthCheckConfigArgs.builder()
            .dip(dip?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .retry(retry?.applyValue({ args0 -> args0 }))
            .sip(sip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionHealthCheckConfigArgs].
 */
@PulumiTagMarker
public class ConnectionHealthCheckConfigArgsBuilder internal constructor() {
    private var dip: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var interval: Output<Int>? = null

    private var retry: Output<Int>? = null

    private var sip: Output<String>? = null

    /**
     * @param value Destination IP.
     */
    @JvmName("huwnuiroxgpohacg")
    public suspend fun dip(`value`: Output<String>) {
        this.dip = value
    }

    /**
     * @param value Specifies whether to enable healthcheck.
     */
    @JvmName("ttoufbrkxprluvpr")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Retry interval.
     */
    @JvmName("rdupmmygistguyyt")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value retry times.
     */
    @JvmName("cgpjmplkmvsioslk")
    public suspend fun retry(`value`: Output<Int>) {
        this.retry = value
    }

    /**
     * @param value Source IP.
     */
    @JvmName("ecdobftgqgsdpqry")
    public suspend fun sip(`value`: Output<String>) {
        this.sip = value
    }

    /**
     * @param value Destination IP.
     */
    @JvmName("akxftjheihxfqmvg")
    public suspend fun dip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dip = mapped
    }

    /**
     * @param value Specifies whether to enable healthcheck.
     */
    @JvmName("navwavmkgrtoattw")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Retry interval.
     */
    @JvmName("ejobrftdcxcvayug")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value retry times.
     */
    @JvmName("hjfcqbmqwlwaadct")
    public suspend fun retry(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retry = mapped
    }

    /**
     * @param value Source IP.
     */
    @JvmName("hjugmcqfnvfyofyt")
    public suspend fun sip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sip = mapped
    }

    internal fun build(): ConnectionHealthCheckConfigArgs = ConnectionHealthCheckConfigArgs(
        dip = dip,
        enable = enable,
        interval = interval,
        retry = retry,
        sip = sip,
    )
}
