@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionIkeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ikeAuthAlg IKE auth Algorithm.
 * @property ikeEncAlg IKE encript algorithm.
 * @property ikeLifetime IKE lifetime.
 * @property ikeLocalId The local ID, which supports the FQDN and IP formats, and defaults to the IP address of the selected VPN gateway.
 * @property ikeMode IKE mode, supports main and aggressive mode. The main mode is highly secure. If NAT traversal is enabled, we recommend that you use the aggressive mode.
 * @property ikePfs DH group.
 * @property ikeRemoteId The peer ID. The FQDN and IP address formats are supported. The default value is the IP address of the selected customer gateway.
 * @property ikeVersion IKE version.
 * @property psk Preshared secret key.
 */
public data class ConnectionIkeConfigArgs(
    public val ikeAuthAlg: Output<String>? = null,
    public val ikeEncAlg: Output<String>? = null,
    public val ikeLifetime: Output<Int>? = null,
    public val ikeLocalId: Output<String>? = null,
    public val ikeMode: Output<String>? = null,
    public val ikePfs: Output<String>? = null,
    public val ikeRemoteId: Output<String>? = null,
    public val ikeVersion: Output<String>? = null,
    public val psk: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionIkeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionIkeConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionIkeConfigArgs.builder()
            .ikeAuthAlg(ikeAuthAlg?.applyValue({ args0 -> args0 }))
            .ikeEncAlg(ikeEncAlg?.applyValue({ args0 -> args0 }))
            .ikeLifetime(ikeLifetime?.applyValue({ args0 -> args0 }))
            .ikeLocalId(ikeLocalId?.applyValue({ args0 -> args0 }))
            .ikeMode(ikeMode?.applyValue({ args0 -> args0 }))
            .ikePfs(ikePfs?.applyValue({ args0 -> args0 }))
            .ikeRemoteId(ikeRemoteId?.applyValue({ args0 -> args0 }))
            .ikeVersion(ikeVersion?.applyValue({ args0 -> args0 }))
            .psk(psk?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionIkeConfigArgs].
 */
@PulumiTagMarker
public class ConnectionIkeConfigArgsBuilder internal constructor() {
    private var ikeAuthAlg: Output<String>? = null

    private var ikeEncAlg: Output<String>? = null

    private var ikeLifetime: Output<Int>? = null

    private var ikeLocalId: Output<String>? = null

    private var ikeMode: Output<String>? = null

    private var ikePfs: Output<String>? = null

    private var ikeRemoteId: Output<String>? = null

    private var ikeVersion: Output<String>? = null

    private var psk: Output<String>? = null

    /**
     * @param value IKE auth Algorithm.
     */
    @JvmName("jfxwuckhiimqkxkb")
    public suspend fun ikeAuthAlg(`value`: Output<String>) {
        this.ikeAuthAlg = value
    }

    /**
     * @param value IKE encript algorithm.
     */
    @JvmName("hrqfqleaptexuowj")
    public suspend fun ikeEncAlg(`value`: Output<String>) {
        this.ikeEncAlg = value
    }

    /**
     * @param value IKE lifetime.
     */
    @JvmName("fiqfssntoypfwenv")
    public suspend fun ikeLifetime(`value`: Output<Int>) {
        this.ikeLifetime = value
    }

    /**
     * @param value The local ID, which supports the FQDN and IP formats, and defaults to the IP address of the selected VPN gateway.
     */
    @JvmName("jxilfemriocnsqda")
    public suspend fun ikeLocalId(`value`: Output<String>) {
        this.ikeLocalId = value
    }

    /**
     * @param value IKE mode, supports main and aggressive mode. The main mode is highly secure. If NAT traversal is enabled, we recommend that you use the aggressive mode.
     */
    @JvmName("vcynrlsoeroprmic")
    public suspend fun ikeMode(`value`: Output<String>) {
        this.ikeMode = value
    }

    /**
     * @param value DH group.
     */
    @JvmName("nkhekbgicvdicjud")
    public suspend fun ikePfs(`value`: Output<String>) {
        this.ikePfs = value
    }

    /**
     * @param value The peer ID. The FQDN and IP address formats are supported. The default value is the IP address of the selected customer gateway.
     */
    @JvmName("lhbpjhwllxtkptxj")
    public suspend fun ikeRemoteId(`value`: Output<String>) {
        this.ikeRemoteId = value
    }

    /**
     * @param value IKE version.
     */
    @JvmName("gfcrikoysxfrgtct")
    public suspend fun ikeVersion(`value`: Output<String>) {
        this.ikeVersion = value
    }

    /**
     * @param value Preshared secret key.
     */
    @JvmName("hompvxwfoxaeyeoi")
    public suspend fun psk(`value`: Output<String>) {
        this.psk = value
    }

    /**
     * @param value IKE auth Algorithm.
     */
    @JvmName("gtpmkhdiojqwdqat")
    public suspend fun ikeAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeAuthAlg = mapped
    }

    /**
     * @param value IKE encript algorithm.
     */
    @JvmName("gtolinveptrcdkti")
    public suspend fun ikeEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeEncAlg = mapped
    }

    /**
     * @param value IKE lifetime.
     */
    @JvmName("dbocibvbvlooowrd")
    public suspend fun ikeLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeLifetime = mapped
    }

    /**
     * @param value The local ID, which supports the FQDN and IP formats, and defaults to the IP address of the selected VPN gateway.
     */
    @JvmName("trqhwtwvbswvrubp")
    public suspend fun ikeLocalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeLocalId = mapped
    }

    /**
     * @param value IKE mode, supports main and aggressive mode. The main mode is highly secure. If NAT traversal is enabled, we recommend that you use the aggressive mode.
     */
    @JvmName("puaieslcvmwacmfm")
    public suspend fun ikeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeMode = mapped
    }

    /**
     * @param value DH group.
     */
    @JvmName("iksovlnkgyvvyhgp")
    public suspend fun ikePfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikePfs = mapped
    }

    /**
     * @param value The peer ID. The FQDN and IP address formats are supported. The default value is the IP address of the selected customer gateway.
     */
    @JvmName("nnkskjtafbfudqvs")
    public suspend fun ikeRemoteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeRemoteId = mapped
    }

    /**
     * @param value IKE version.
     */
    @JvmName("qtaiuinthrpkvihd")
    public suspend fun ikeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeVersion = mapped
    }

    /**
     * @param value Preshared secret key.
     */
    @JvmName("xbocgyfdgrfcsuqv")
    public suspend fun psk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.psk = mapped
    }

    internal fun build(): ConnectionIkeConfigArgs = ConnectionIkeConfigArgs(
        ikeAuthAlg = ikeAuthAlg,
        ikeEncAlg = ikeEncAlg,
        ikeLifetime = ikeLifetime,
        ikeLocalId = ikeLocalId,
        ikeMode = ikeMode,
        ikePfs = ikePfs,
        ikeRemoteId = ikeRemoteId,
        ikeVersion = ikeVersion,
        psk = psk,
    )
}
