@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionIpsecConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipsecAuthAlg IPsec authentication algorithm. sha1 and md5 are supported.
 * @property ipsecEncAlg IPsec Encript algorithm.
 * @property ipsecLifetime IPsec lifetime.
 * @property ipsecPfs DH Group.
 */
public data class ConnectionIpsecConfigArgs(
    public val ipsecAuthAlg: Output<String>? = null,
    public val ipsecEncAlg: Output<String>? = null,
    public val ipsecLifetime: Output<Int>? = null,
    public val ipsecPfs: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionIpsecConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionIpsecConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionIpsecConfigArgs.builder()
            .ipsecAuthAlg(ipsecAuthAlg?.applyValue({ args0 -> args0 }))
            .ipsecEncAlg(ipsecEncAlg?.applyValue({ args0 -> args0 }))
            .ipsecLifetime(ipsecLifetime?.applyValue({ args0 -> args0 }))
            .ipsecPfs(ipsecPfs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionIpsecConfigArgs].
 */
@PulumiTagMarker
public class ConnectionIpsecConfigArgsBuilder internal constructor() {
    private var ipsecAuthAlg: Output<String>? = null

    private var ipsecEncAlg: Output<String>? = null

    private var ipsecLifetime: Output<Int>? = null

    private var ipsecPfs: Output<String>? = null

    /**
     * @param value IPsec authentication algorithm. sha1 and md5 are supported.
     */
    @JvmName("mxnkhuelgyileewn")
    public suspend fun ipsecAuthAlg(`value`: Output<String>) {
        this.ipsecAuthAlg = value
    }

    /**
     * @param value IPsec Encript algorithm.
     */
    @JvmName("jljbicuxdqsqqgwx")
    public suspend fun ipsecEncAlg(`value`: Output<String>) {
        this.ipsecEncAlg = value
    }

    /**
     * @param value IPsec lifetime.
     */
    @JvmName("fwufrpwmggxkjnfc")
    public suspend fun ipsecLifetime(`value`: Output<Int>) {
        this.ipsecLifetime = value
    }

    /**
     * @param value DH Group.
     */
    @JvmName("xweuwuhxakahwnpi")
    public suspend fun ipsecPfs(`value`: Output<String>) {
        this.ipsecPfs = value
    }

    /**
     * @param value IPsec authentication algorithm. sha1 and md5 are supported.
     */
    @JvmName("pojhoshxsgbtdlkc")
    public suspend fun ipsecAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecAuthAlg = mapped
    }

    /**
     * @param value IPsec Encript algorithm.
     */
    @JvmName("qktcydypvpxmbtec")
    public suspend fun ipsecEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecEncAlg = mapped
    }

    /**
     * @param value IPsec lifetime.
     */
    @JvmName("glxetobmavgexfmt")
    public suspend fun ipsecLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecLifetime = mapped
    }

    /**
     * @param value DH Group.
     */
    @JvmName("jpaulnwmccmlddog")
    public suspend fun ipsecPfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPfs = mapped
    }

    internal fun build(): ConnectionIpsecConfigArgs = ConnectionIpsecConfigArgs(
        ipsecAuthAlg = ipsecAuthAlg,
        ipsecEncAlg = ipsecEncAlg,
        ipsecLifetime = ipsecLifetime,
        ipsecPfs = ipsecPfs,
    )
}
