@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customerGatewayId The ID of the customer gateway in Tunnel.
 * @property enableDpd Wether enable Dpd detection.
 * @property enableNatTraversal enable nat traversal.
 * @property internetIp The local internet IP in Tunnel.
 * @property role The role of Tunnel.
 * @property state The state of Tunnel.
 * @property status The negotiation status of Tunnel.
 * @property tunnelBgpConfig The bgp config of Tunnel. See `tunnel_bgp_config` below.
 * @property tunnelId The tunnel ID of IPsec-VPN connection.
 * @property tunnelIkeConfig The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
 * @property tunnelIpsecConfig IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
 * @property zoneNo The zoneNo of tunnel.
 */
public data class ConnectionTunnelOptionsSpecificationArgs(
    public val customerGatewayId: Output<String>? = null,
    public val enableDpd: Output<Boolean>? = null,
    public val enableNatTraversal: Output<Boolean>? = null,
    public val internetIp: Output<String>? = null,
    public val role: Output<String>? = null,
    public val state: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tunnelBgpConfig: Output<ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs>? =
        null,
    public val tunnelId: Output<String>? = null,
    public val tunnelIkeConfig: Output<ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs>? =
        null,
    public val tunnelIpsecConfig: Output<ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs>? =
        null,
    public val zoneNo: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationArgs.builder()
            .customerGatewayId(customerGatewayId?.applyValue({ args0 -> args0 }))
            .enableDpd(enableDpd?.applyValue({ args0 -> args0 }))
            .enableNatTraversal(enableNatTraversal?.applyValue({ args0 -> args0 }))
            .internetIp(internetIp?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tunnelBgpConfig(tunnelBgpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tunnelId(tunnelId?.applyValue({ args0 -> args0 }))
            .tunnelIkeConfig(tunnelIkeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tunnelIpsecConfig(tunnelIpsecConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zoneNo(zoneNo?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionTunnelOptionsSpecificationArgs].
 */
@PulumiTagMarker
public class ConnectionTunnelOptionsSpecificationArgsBuilder internal constructor() {
    private var customerGatewayId: Output<String>? = null

    private var enableDpd: Output<Boolean>? = null

    private var enableNatTraversal: Output<Boolean>? = null

    private var internetIp: Output<String>? = null

    private var role: Output<String>? = null

    private var state: Output<String>? = null

    private var status: Output<String>? = null

    private var tunnelBgpConfig: Output<ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs>? =
        null

    private var tunnelId: Output<String>? = null

    private var tunnelIkeConfig: Output<ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs>? =
        null

    private var tunnelIpsecConfig: Output<ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs>? =
        null

    private var zoneNo: Output<String>? = null

    /**
     * @param value The ID of the customer gateway in Tunnel.
     */
    @JvmName("bhlghhripxtrxxeq")
    public suspend fun customerGatewayId(`value`: Output<String>) {
        this.customerGatewayId = value
    }

    /**
     * @param value Wether enable Dpd detection.
     */
    @JvmName("dmjygkpvlmkwlwsa")
    public suspend fun enableDpd(`value`: Output<Boolean>) {
        this.enableDpd = value
    }

    /**
     * @param value enable nat traversal.
     */
    @JvmName("cumqftkpkehekpoi")
    public suspend fun enableNatTraversal(`value`: Output<Boolean>) {
        this.enableNatTraversal = value
    }

    /**
     * @param value The local internet IP in Tunnel.
     */
    @JvmName("wygvfdaqrypyknbd")
    public suspend fun internetIp(`value`: Output<String>) {
        this.internetIp = value
    }

    /**
     * @param value The role of Tunnel.
     */
    @JvmName("rmyksvnbquvcjfqm")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The state of Tunnel.
     */
    @JvmName("poykpqlqkwyggqdb")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The negotiation status of Tunnel.
     */
    @JvmName("lryxetjruxvftpxx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The bgp config of Tunnel. See `tunnel_bgp_config` below.
     */
    @JvmName("idwabtjpgytrgeux")
    public suspend fun tunnelBgpConfig(`value`: Output<ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs>) {
        this.tunnelBgpConfig = value
    }

    /**
     * @param value The tunnel ID of IPsec-VPN connection.
     */
    @JvmName("opkgmnhxumoypyld")
    public suspend fun tunnelId(`value`: Output<String>) {
        this.tunnelId = value
    }

    /**
     * @param value The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
     */
    @JvmName("fotnkalhugeadlyh")
    public suspend fun tunnelIkeConfig(`value`: Output<ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs>) {
        this.tunnelIkeConfig = value
    }

    /**
     * @param value IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
     */
    @JvmName("cfeeixtysvhofqrs")
    public suspend fun tunnelIpsecConfig(`value`: Output<ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs>) {
        this.tunnelIpsecConfig = value
    }

    /**
     * @param value The zoneNo of tunnel.
     */
    @JvmName("jvgvapviqxfwpcla")
    public suspend fun zoneNo(`value`: Output<String>) {
        this.zoneNo = value
    }

    /**
     * @param value The ID of the customer gateway in Tunnel.
     */
    @JvmName("odkmitewwdeskego")
    public suspend fun customerGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerGatewayId = mapped
    }

    /**
     * @param value Wether enable Dpd detection.
     */
    @JvmName("raogqdcnfcvbqtcg")
    public suspend fun enableDpd(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDpd = mapped
    }

    /**
     * @param value enable nat traversal.
     */
    @JvmName("dggurxihnwtqttul")
    public suspend fun enableNatTraversal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNatTraversal = mapped
    }

    /**
     * @param value The local internet IP in Tunnel.
     */
    @JvmName("wbpyouvnmnguevha")
    public suspend fun internetIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetIp = mapped
    }

    /**
     * @param value The role of Tunnel.
     */
    @JvmName("yuxewrmqqiypxxap")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The state of Tunnel.
     */
    @JvmName("iqvvolcroffsgqkt")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The negotiation status of Tunnel.
     */
    @JvmName("xhwfqnwcxepjndej")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The bgp config of Tunnel. See `tunnel_bgp_config` below.
     */
    @JvmName("krsxmjcyedjrixlp")
    public suspend fun tunnelBgpConfig(`value`: ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelBgpConfig = mapped
    }

    /**
     * @param argument The bgp config of Tunnel. See `tunnel_bgp_config` below.
     */
    @JvmName("ncbctynugreyowqe")
    public suspend fun tunnelBgpConfig(argument: suspend ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tunnelBgpConfig = mapped
    }

    /**
     * @param value The tunnel ID of IPsec-VPN connection.
     */
    @JvmName("fffnpdnbflrgblig")
    public suspend fun tunnelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelId = mapped
    }

    /**
     * @param value The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
     */
    @JvmName("hqptwifkofaydass")
    public suspend fun tunnelIkeConfig(`value`: ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelIkeConfig = mapped
    }

    /**
     * @param argument The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
     */
    @JvmName("qwqqedtoeamwnqrn")
    public suspend fun tunnelIkeConfig(argument: suspend ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tunnelIkeConfig = mapped
    }

    /**
     * @param value IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
     */
    @JvmName("dcruursigubaqipc")
    public suspend fun tunnelIpsecConfig(`value`: ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelIpsecConfig = mapped
    }

    /**
     * @param argument IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
     */
    @JvmName("rpbspdlfhwjkqxhg")
    public suspend fun tunnelIpsecConfig(argument: suspend ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tunnelIpsecConfig = mapped
    }

    /**
     * @param value The zoneNo of tunnel.
     */
    @JvmName("sobvapymhtiitxgw")
    public suspend fun zoneNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneNo = mapped
    }

    internal fun build(): ConnectionTunnelOptionsSpecificationArgs =
        ConnectionTunnelOptionsSpecificationArgs(
            customerGatewayId = customerGatewayId,
            enableDpd = enableDpd,
            enableNatTraversal = enableNatTraversal,
            internetIp = internetIp,
            role = role,
            state = state,
            status = status,
            tunnelBgpConfig = tunnelBgpConfig,
            tunnelId = tunnelId,
            tunnelIkeConfig = tunnelIkeConfig,
            tunnelIpsecConfig = tunnelIpsecConfig,
            zoneNo = zoneNo,
        )
}
