@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bgpStatus Whether BGP function is turned on.
 * @property localAsn
 * @property localBgpIp
 * @property peerAsn Peer asn.
 * @property peerBgpIp Peer bgp ip.
 * @property tunnelCidr
 */
public data class ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs(
    public val bgpStatus: Output<String>? = null,
    public val localAsn: Output<String>? = null,
    public val localBgpIp: Output<String>? = null,
    public val peerAsn: Output<String>? = null,
    public val peerBgpIp: Output<String>? = null,
    public val tunnelCidr: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs.builder()
            .bgpStatus(bgpStatus?.applyValue({ args0 -> args0 }))
            .localAsn(localAsn?.applyValue({ args0 -> args0 }))
            .localBgpIp(localBgpIp?.applyValue({ args0 -> args0 }))
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 }))
            .peerBgpIp(peerBgpIp?.applyValue({ args0 -> args0 }))
            .tunnelCidr(tunnelCidr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs].
 */
@PulumiTagMarker
public class ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsBuilder internal constructor() {
    private var bgpStatus: Output<String>? = null

    private var localAsn: Output<String>? = null

    private var localBgpIp: Output<String>? = null

    private var peerAsn: Output<String>? = null

    private var peerBgpIp: Output<String>? = null

    private var tunnelCidr: Output<String>? = null

    /**
     * @param value Whether BGP function is turned on.
     */
    @JvmName("lppoghtprmpvnknb")
    public suspend fun bgpStatus(`value`: Output<String>) {
        this.bgpStatus = value
    }

    /**
     * @param value
     */
    @JvmName("qpyqblixvesjksdm")
    public suspend fun localAsn(`value`: Output<String>) {
        this.localAsn = value
    }

    /**
     * @param value
     */
    @JvmName("jihkcewjdihvpbie")
    public suspend fun localBgpIp(`value`: Output<String>) {
        this.localBgpIp = value
    }

    /**
     * @param value Peer asn.
     */
    @JvmName("oeikaamfsopytodg")
    public suspend fun peerAsn(`value`: Output<String>) {
        this.peerAsn = value
    }

    /**
     * @param value Peer bgp ip.
     */
    @JvmName("mpattcvbtbukndnx")
    public suspend fun peerBgpIp(`value`: Output<String>) {
        this.peerBgpIp = value
    }

    /**
     * @param value
     */
    @JvmName("ouwnnxcbjxqntxeb")
    public suspend fun tunnelCidr(`value`: Output<String>) {
        this.tunnelCidr = value
    }

    /**
     * @param value Whether BGP function is turned on.
     */
    @JvmName("uprfidhfpkcxboor")
    public suspend fun bgpStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("woomqgxiuivrbder")
    public suspend fun localAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAsn = mapped
    }

    /**
     * @param value
     */
    @JvmName("lgmfmwuxayokkwcg")
    public suspend fun localBgpIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBgpIp = mapped
    }

    /**
     * @param value Peer asn.
     */
    @JvmName("asxyxtmfhmkgwnhr")
    public suspend fun peerAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value Peer bgp ip.
     */
    @JvmName("iihbopkeainclhil")
    public suspend fun peerBgpIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerBgpIp = mapped
    }

    /**
     * @param value
     */
    @JvmName("guxhljdwvnjiyrkf")
    public suspend fun tunnelCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelCidr = mapped
    }

    internal fun build(): ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs =
        ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs(
            bgpStatus = bgpStatus,
            localAsn = localAsn,
            localBgpIp = localBgpIp,
            peerAsn = peerAsn,
            peerBgpIp = peerBgpIp,
            tunnelCidr = tunnelCidr,
        )
}
