@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ikeAuthAlg
 * @property ikeEncAlg
 * @property ikeLifetime
 * @property ikeMode
 * @property ikePfs
 * @property ikeVersion
 * @property localId The local Id.
 * @property psk
 * @property remoteId Remote ID.
 */
public data class ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs(
    public val ikeAuthAlg: Output<String>? = null,
    public val ikeEncAlg: Output<String>? = null,
    public val ikeLifetime: Output<Int>? = null,
    public val ikeMode: Output<String>? = null,
    public val ikePfs: Output<String>? = null,
    public val ikeVersion: Output<String>? = null,
    public val localId: Output<String>? = null,
    public val psk: Output<String>? = null,
    public val remoteId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs.builder()
            .ikeAuthAlg(ikeAuthAlg?.applyValue({ args0 -> args0 }))
            .ikeEncAlg(ikeEncAlg?.applyValue({ args0 -> args0 }))
            .ikeLifetime(ikeLifetime?.applyValue({ args0 -> args0 }))
            .ikeMode(ikeMode?.applyValue({ args0 -> args0 }))
            .ikePfs(ikePfs?.applyValue({ args0 -> args0 }))
            .ikeVersion(ikeVersion?.applyValue({ args0 -> args0 }))
            .localId(localId?.applyValue({ args0 -> args0 }))
            .psk(psk?.applyValue({ args0 -> args0 }))
            .remoteId(remoteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs].
 */
@PulumiTagMarker
public class ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsBuilder internal constructor() {
    private var ikeAuthAlg: Output<String>? = null

    private var ikeEncAlg: Output<String>? = null

    private var ikeLifetime: Output<Int>? = null

    private var ikeMode: Output<String>? = null

    private var ikePfs: Output<String>? = null

    private var ikeVersion: Output<String>? = null

    private var localId: Output<String>? = null

    private var psk: Output<String>? = null

    private var remoteId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("pinjvsceapckgifw")
    public suspend fun ikeAuthAlg(`value`: Output<String>) {
        this.ikeAuthAlg = value
    }

    /**
     * @param value
     */
    @JvmName("usqqemiyxwekdebr")
    public suspend fun ikeEncAlg(`value`: Output<String>) {
        this.ikeEncAlg = value
    }

    /**
     * @param value
     */
    @JvmName("mcsxfyyceysfauby")
    public suspend fun ikeLifetime(`value`: Output<Int>) {
        this.ikeLifetime = value
    }

    /**
     * @param value
     */
    @JvmName("mlummisugpolwjdk")
    public suspend fun ikeMode(`value`: Output<String>) {
        this.ikeMode = value
    }

    /**
     * @param value
     */
    @JvmName("whbancnttowpvsnh")
    public suspend fun ikePfs(`value`: Output<String>) {
        this.ikePfs = value
    }

    /**
     * @param value
     */
    @JvmName("xrvxyiwkpgofisst")
    public suspend fun ikeVersion(`value`: Output<String>) {
        this.ikeVersion = value
    }

    /**
     * @param value The local Id.
     */
    @JvmName("dvsdndbcnomcswhm")
    public suspend fun localId(`value`: Output<String>) {
        this.localId = value
    }

    /**
     * @param value
     */
    @JvmName("qfpjfreajxnqnceo")
    public suspend fun psk(`value`: Output<String>) {
        this.psk = value
    }

    /**
     * @param value Remote ID.
     */
    @JvmName("avlkernenyrlccok")
    public suspend fun remoteId(`value`: Output<String>) {
        this.remoteId = value
    }

    /**
     * @param value
     */
    @JvmName("jncejlwcdwvohfus")
    public suspend fun ikeAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeAuthAlg = mapped
    }

    /**
     * @param value
     */
    @JvmName("mtdsslffqisiaqcb")
    public suspend fun ikeEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeEncAlg = mapped
    }

    /**
     * @param value
     */
    @JvmName("hhofxxumpfbsnlre")
    public suspend fun ikeLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeLifetime = mapped
    }

    /**
     * @param value
     */
    @JvmName("aluyewyaxlwofbkc")
    public suspend fun ikeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("ilntnamgwtryrwkx")
    public suspend fun ikePfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikePfs = mapped
    }

    /**
     * @param value
     */
    @JvmName("qytalxsujhipgqas")
    public suspend fun ikeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeVersion = mapped
    }

    /**
     * @param value The local Id.
     */
    @JvmName("toidhkaajhpgrupk")
    public suspend fun localId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localId = mapped
    }

    /**
     * @param value
     */
    @JvmName("esqctrcvbxqdtkbh")
    public suspend fun psk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.psk = mapped
    }

    /**
     * @param value Remote ID.
     */
    @JvmName("adiavkjugepdhoci")
    public suspend fun remoteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteId = mapped
    }

    internal fun build(): ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs =
        ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs(
            ikeAuthAlg = ikeAuthAlg,
            ikeEncAlg = ikeEncAlg,
            ikeLifetime = ikeLifetime,
            ikeMode = ikeMode,
            ikePfs = ikePfs,
            ikeVersion = ikeVersion,
            localId = localId,
            psk = psk,
            remoteId = remoteId,
        )
}
