@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipsecAuthAlg
 * @property ipsecEncAlg
 * @property ipsecLifetime
 * @property ipsecPfs
 */
public data class ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs(
    public val ipsecAuthAlg: Output<String>? = null,
    public val ipsecEncAlg: Output<String>? = null,
    public val ipsecLifetime: Output<Int>? = null,
    public val ipsecPfs: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs =
        com.pulumi.alicloud.vpn.inputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs.builder()
            .ipsecAuthAlg(ipsecAuthAlg?.applyValue({ args0 -> args0 }))
            .ipsecEncAlg(ipsecEncAlg?.applyValue({ args0 -> args0 }))
            .ipsecLifetime(ipsecLifetime?.applyValue({ args0 -> args0 }))
            .ipsecPfs(ipsecPfs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs].
 */
@PulumiTagMarker
public class ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsBuilder internal constructor() {
    private var ipsecAuthAlg: Output<String>? = null

    private var ipsecEncAlg: Output<String>? = null

    private var ipsecLifetime: Output<Int>? = null

    private var ipsecPfs: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qxasqyvbijcvdamq")
    public suspend fun ipsecAuthAlg(`value`: Output<String>) {
        this.ipsecAuthAlg = value
    }

    /**
     * @param value
     */
    @JvmName("hhqyhhmddfivqfme")
    public suspend fun ipsecEncAlg(`value`: Output<String>) {
        this.ipsecEncAlg = value
    }

    /**
     * @param value
     */
    @JvmName("ppmjiaptfgmcsmxt")
    public suspend fun ipsecLifetime(`value`: Output<Int>) {
        this.ipsecLifetime = value
    }

    /**
     * @param value
     */
    @JvmName("bxqogdwjfsgohmmq")
    public suspend fun ipsecPfs(`value`: Output<String>) {
        this.ipsecPfs = value
    }

    /**
     * @param value
     */
    @JvmName("jfyhmrlutcikiuyo")
    public suspend fun ipsecAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecAuthAlg = mapped
    }

    /**
     * @param value
     */
    @JvmName("kpbflefyjkacvheo")
    public suspend fun ipsecEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecEncAlg = mapped
    }

    /**
     * @param value
     */
    @JvmName("fnuofjhxwstgkdru")
    public suspend fun ipsecLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecLifetime = mapped
    }

    /**
     * @param value
     */
    @JvmName("sihmqvhltwtglhva")
    public suspend fun ipsecPfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPfs = mapped
    }

    internal fun build(): ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs =
        ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs(
            ipsecAuthAlg = ipsecAuthAlg,
            ipsecEncAlg = ipsecEncAlg,
            ipsecLifetime = ipsecLifetime,
            ipsecPfs = ipsecPfs,
        )
}
