@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable Whether to enable BGP.
 * @property localAsn The ASN on the Alibaba Cloud side.
 * @property localBgpIp The BGP IP address on the Alibaba Cloud side.
 * @property tunnelCidr The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
 */
public data class GatewayVpnAttachmentBgpConfigArgs(
    public val enable: Output<Boolean>? = null,
    public val localAsn: Output<Int>? = null,
    public val localBgpIp: Output<String>? = null,
    public val tunnelCidr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs =
        com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .localAsn(localAsn?.applyValue({ args0 -> args0 }))
            .localBgpIp(localBgpIp?.applyValue({ args0 -> args0 }))
            .tunnelCidr(tunnelCidr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayVpnAttachmentBgpConfigArgs].
 */
@PulumiTagMarker
public class GatewayVpnAttachmentBgpConfigArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var localAsn: Output<Int>? = null

    private var localBgpIp: Output<String>? = null

    private var tunnelCidr: Output<String>? = null

    /**
     * @param value Whether to enable BGP.
     */
    @JvmName("gftkxwjjwhgbtijv")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The ASN on the Alibaba Cloud side.
     */
    @JvmName("mrdtxxmaggydryhx")
    public suspend fun localAsn(`value`: Output<Int>) {
        this.localAsn = value
    }

    /**
     * @param value The BGP IP address on the Alibaba Cloud side.
     */
    @JvmName("gsbkoudilqwsqkbl")
    public suspend fun localBgpIp(`value`: Output<String>) {
        this.localBgpIp = value
    }

    /**
     * @param value The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
     */
    @JvmName("ulxkhonrhkhqtrdd")
    public suspend fun tunnelCidr(`value`: Output<String>) {
        this.tunnelCidr = value
    }

    /**
     * @param value Whether to enable BGP.
     */
    @JvmName("wgjtdpbupenujgit")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The ASN on the Alibaba Cloud side.
     */
    @JvmName("gxhvggmerkhkvncl")
    public suspend fun localAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAsn = mapped
    }

    /**
     * @param value The BGP IP address on the Alibaba Cloud side.
     */
    @JvmName("xilovmvymuqptrnf")
    public suspend fun localBgpIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBgpIp = mapped
    }

    /**
     * @param value The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
     */
    @JvmName("stdyqrwgycwccnfu")
    public suspend fun tunnelCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelCidr = mapped
    }

    internal fun build(): GatewayVpnAttachmentBgpConfigArgs = GatewayVpnAttachmentBgpConfigArgs(
        enable = enable,
        localAsn = localAsn,
        localBgpIp = localBgpIp,
        tunnelCidr = tunnelCidr,
    )
}
