@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dip The destination IP address that is used for health checks.
 * @property enable Specifies whether to enable health checks.
 * @property interval The interval between two consecutive health checks. Unit: seconds.
 * @property policy Whether to revoke the published route when the health check fails. Valid values: `revoke_route` or `reserve_route`.
 * @property retry The maximum number of health check retries.
 * @property sip The source IP address that is used for health checks.
 */
public data class GatewayVpnAttachmentHealthCheckConfigArgs(
    public val dip: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val interval: Output<Int>? = null,
    public val policy: Output<String>? = null,
    public val retry: Output<Int>? = null,
    public val sip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs =
        com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs.builder()
            .dip(dip?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .retry(retry?.applyValue({ args0 -> args0 }))
            .sip(sip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayVpnAttachmentHealthCheckConfigArgs].
 */
@PulumiTagMarker
public class GatewayVpnAttachmentHealthCheckConfigArgsBuilder internal constructor() {
    private var dip: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var interval: Output<Int>? = null

    private var policy: Output<String>? = null

    private var retry: Output<Int>? = null

    private var sip: Output<String>? = null

    /**
     * @param value The destination IP address that is used for health checks.
     */
    @JvmName("dgleyrvftmeepbvl")
    public suspend fun dip(`value`: Output<String>) {
        this.dip = value
    }

    /**
     * @param value Specifies whether to enable health checks.
     */
    @JvmName("ydabyqqqjitknypk")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The interval between two consecutive health checks. Unit: seconds.
     */
    @JvmName("mnkpjrjjidjmgext")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Whether to revoke the published route when the health check fails. Valid values: `revoke_route` or `reserve_route`.
     */
    @JvmName("hddpddsocmpxnsrq")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The maximum number of health check retries.
     */
    @JvmName("ximpeamohqaurftv")
    public suspend fun retry(`value`: Output<Int>) {
        this.retry = value
    }

    /**
     * @param value The source IP address that is used for health checks.
     */
    @JvmName("lmglgfatpejdyubq")
    public suspend fun sip(`value`: Output<String>) {
        this.sip = value
    }

    /**
     * @param value The destination IP address that is used for health checks.
     */
    @JvmName("yucwgardotrrebti")
    public suspend fun dip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dip = mapped
    }

    /**
     * @param value Specifies whether to enable health checks.
     */
    @JvmName("wadalxrjlmmoxdon")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The interval between two consecutive health checks. Unit: seconds.
     */
    @JvmName("mmbkhbmgcglgelxl")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Whether to revoke the published route when the health check fails. Valid values: `revoke_route` or `reserve_route`.
     */
    @JvmName("gnvtaqivrohfvaph")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The maximum number of health check retries.
     */
    @JvmName("tbsxhhhsulrlmqme")
    public suspend fun retry(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retry = mapped
    }

    /**
     * @param value The source IP address that is used for health checks.
     */
    @JvmName("vsiabbmnjetgaite")
    public suspend fun sip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sip = mapped
    }

    internal fun build(): GatewayVpnAttachmentHealthCheckConfigArgs =
        GatewayVpnAttachmentHealthCheckConfigArgs(
            dip = dip,
            enable = enable,
            interval = interval,
            policy = policy,
            retry = retry,
            sip = sip,
        )
}
