@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ikeAuthAlg IKE authentication algorithm supports sha1 and MD5.
 * @property ikeEncAlg The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes.
 * @property ikeLifetime The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
 * @property ikeMode The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: `main`.
 * @property ikePfs The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
 * @property ikeVersion The version of the IKE protocol. Valid value: `ikev1`, `ikev2`. Default value: `ikev1`.
 * @property localId The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default.
 * @property psk Used for authentication between the IPsec VPN gateway and the customer gateway.
 * @property remoteId The peer ID, which supports FQDN and IP formats. By default, the IP address of the currently selected user gateway.
 */
public data class GatewayVpnAttachmentIkeConfigArgs(
    public val ikeAuthAlg: Output<String>? = null,
    public val ikeEncAlg: Output<String>? = null,
    public val ikeLifetime: Output<Int>? = null,
    public val ikeMode: Output<String>? = null,
    public val ikePfs: Output<String>? = null,
    public val ikeVersion: Output<String>? = null,
    public val localId: Output<String>? = null,
    public val psk: Output<String>? = null,
    public val remoteId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs =
        com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs.builder()
            .ikeAuthAlg(ikeAuthAlg?.applyValue({ args0 -> args0 }))
            .ikeEncAlg(ikeEncAlg?.applyValue({ args0 -> args0 }))
            .ikeLifetime(ikeLifetime?.applyValue({ args0 -> args0 }))
            .ikeMode(ikeMode?.applyValue({ args0 -> args0 }))
            .ikePfs(ikePfs?.applyValue({ args0 -> args0 }))
            .ikeVersion(ikeVersion?.applyValue({ args0 -> args0 }))
            .localId(localId?.applyValue({ args0 -> args0 }))
            .psk(psk?.applyValue({ args0 -> args0 }))
            .remoteId(remoteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayVpnAttachmentIkeConfigArgs].
 */
@PulumiTagMarker
public class GatewayVpnAttachmentIkeConfigArgsBuilder internal constructor() {
    private var ikeAuthAlg: Output<String>? = null

    private var ikeEncAlg: Output<String>? = null

    private var ikeLifetime: Output<Int>? = null

    private var ikeMode: Output<String>? = null

    private var ikePfs: Output<String>? = null

    private var ikeVersion: Output<String>? = null

    private var localId: Output<String>? = null

    private var psk: Output<String>? = null

    private var remoteId: Output<String>? = null

    /**
     * @param value IKE authentication algorithm supports sha1 and MD5.
     */
    @JvmName("gmxxevhnkhrocvqt")
    public suspend fun ikeAuthAlg(`value`: Output<String>) {
        this.ikeAuthAlg = value
    }

    /**
     * @param value The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes.
     */
    @JvmName("jkpjcrmqmymecmlg")
    public suspend fun ikeEncAlg(`value`: Output<String>) {
        this.ikeEncAlg = value
    }

    /**
     * @param value The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
     */
    @JvmName("umhncohfomuxqtir")
    public suspend fun ikeLifetime(`value`: Output<Int>) {
        this.ikeLifetime = value
    }

    /**
     * @param value The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: `main`.
     */
    @JvmName("yshljsctvjqxmsvu")
    public suspend fun ikeMode(`value`: Output<String>) {
        this.ikeMode = value
    }

    /**
     * @param value The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
     */
    @JvmName("icxqmqcbgahqbvim")
    public suspend fun ikePfs(`value`: Output<String>) {
        this.ikePfs = value
    }

    /**
     * @param value The version of the IKE protocol. Valid value: `ikev1`, `ikev2`. Default value: `ikev1`.
     */
    @JvmName("ncgpiqrexecyriyg")
    public suspend fun ikeVersion(`value`: Output<String>) {
        this.ikeVersion = value
    }

    /**
     * @param value The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default.
     */
    @JvmName("oijtdoqjtaffntjj")
    public suspend fun localId(`value`: Output<String>) {
        this.localId = value
    }

    /**
     * @param value Used for authentication between the IPsec VPN gateway and the customer gateway.
     */
    @JvmName("ipwdayksergnjfdu")
    public suspend fun psk(`value`: Output<String>) {
        this.psk = value
    }

    /**
     * @param value The peer ID, which supports FQDN and IP formats. By default, the IP address of the currently selected user gateway.
     */
    @JvmName("yunkwtsrfmkbydvp")
    public suspend fun remoteId(`value`: Output<String>) {
        this.remoteId = value
    }

    /**
     * @param value IKE authentication algorithm supports sha1 and MD5.
     */
    @JvmName("yadgscydymampgha")
    public suspend fun ikeAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeAuthAlg = mapped
    }

    /**
     * @param value The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes.
     */
    @JvmName("vsgrkfxvfkxkutxy")
    public suspend fun ikeEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeEncAlg = mapped
    }

    /**
     * @param value The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
     */
    @JvmName("iamtfhjdvtgrewbb")
    public suspend fun ikeLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeLifetime = mapped
    }

    /**
     * @param value The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: `main`.
     */
    @JvmName("goawplwegnufugda")
    public suspend fun ikeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeMode = mapped
    }

    /**
     * @param value The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
     */
    @JvmName("yfuigxtghkoavkbe")
    public suspend fun ikePfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikePfs = mapped
    }

    /**
     * @param value The version of the IKE protocol. Valid value: `ikev1`, `ikev2`. Default value: `ikev1`.
     */
    @JvmName("yxyvaqlbpsljnsuu")
    public suspend fun ikeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeVersion = mapped
    }

    /**
     * @param value The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default.
     */
    @JvmName("nrnsljydqmefprtu")
    public suspend fun localId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localId = mapped
    }

    /**
     * @param value Used for authentication between the IPsec VPN gateway and the customer gateway.
     */
    @JvmName("bwloluccfecqhlre")
    public suspend fun psk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.psk = mapped
    }

    /**
     * @param value The peer ID, which supports FQDN and IP formats. By default, the IP address of the currently selected user gateway.
     */
    @JvmName("ndcpaojcffjxaqdk")
    public suspend fun remoteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteId = mapped
    }

    internal fun build(): GatewayVpnAttachmentIkeConfigArgs = GatewayVpnAttachmentIkeConfigArgs(
        ikeAuthAlg = ikeAuthAlg,
        ikeEncAlg = ikeEncAlg,
        ikeLifetime = ikeLifetime,
        ikeMode = ikeMode,
        ikePfs = ikePfs,
        ikeVersion = ikeVersion,
        localId = localId,
        psk = psk,
        remoteId = remoteId,
    )
}
