@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipsecAuthAlg The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
 * @property ipsecEncAlg The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
 * @property ipsecLifetime The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
 * @property ipsecPfs The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
 */
public data class GatewayVpnAttachmentIpsecConfigArgs(
    public val ipsecAuthAlg: Output<String>? = null,
    public val ipsecEncAlg: Output<String>? = null,
    public val ipsecLifetime: Output<Int>? = null,
    public val ipsecPfs: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs =
        com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs.builder()
            .ipsecAuthAlg(ipsecAuthAlg?.applyValue({ args0 -> args0 }))
            .ipsecEncAlg(ipsecEncAlg?.applyValue({ args0 -> args0 }))
            .ipsecLifetime(ipsecLifetime?.applyValue({ args0 -> args0 }))
            .ipsecPfs(ipsecPfs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayVpnAttachmentIpsecConfigArgs].
 */
@PulumiTagMarker
public class GatewayVpnAttachmentIpsecConfigArgsBuilder internal constructor() {
    private var ipsecAuthAlg: Output<String>? = null

    private var ipsecEncAlg: Output<String>? = null

    private var ipsecLifetime: Output<Int>? = null

    private var ipsecPfs: Output<String>? = null

    /**
     * @param value The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
     */
    @JvmName("vlunwtqibkkmlbpw")
    public suspend fun ipsecAuthAlg(`value`: Output<String>) {
        this.ipsecAuthAlg = value
    }

    /**
     * @param value The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
     */
    @JvmName("qqqkisqqekbranvq")
    public suspend fun ipsecEncAlg(`value`: Output<String>) {
        this.ipsecEncAlg = value
    }

    /**
     * @param value The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
     */
    @JvmName("gueqhavhooenoxft")
    public suspend fun ipsecLifetime(`value`: Output<Int>) {
        this.ipsecLifetime = value
    }

    /**
     * @param value The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
     */
    @JvmName("dmjujxlvmecnsnmb")
    public suspend fun ipsecPfs(`value`: Output<String>) {
        this.ipsecPfs = value
    }

    /**
     * @param value The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
     */
    @JvmName("bceueeqhsaoyxphj")
    public suspend fun ipsecAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecAuthAlg = mapped
    }

    /**
     * @param value The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
     */
    @JvmName("oadvcinfavwhfgpi")
    public suspend fun ipsecEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecEncAlg = mapped
    }

    /**
     * @param value The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
     */
    @JvmName("irmmxrlaagsijyqg")
    public suspend fun ipsecLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecLifetime = mapped
    }

    /**
     * @param value The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
     */
    @JvmName("vnqsahvljhlsjafh")
    public suspend fun ipsecPfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPfs = mapped
    }

    internal fun build(): GatewayVpnAttachmentIpsecConfigArgs = GatewayVpnAttachmentIpsecConfigArgs(
        ipsecAuthAlg = ipsecAuthAlg,
        ipsecEncAlg = ipsecEncAlg,
        ipsecLifetime = ipsecLifetime,
        ipsecPfs = ipsecPfs,
    )
}
