@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GetConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnections.
 * @property customerGatewayId Use the VPN customer gateway ID as the search key.
 * @property ids IDs of the VPN connections.
 * @property nameRegex A regex string of VPN connection name.
 * @property outputFile Save the result to the file.
 * @property vpnGatewayId Use the VPN gateway ID as the search key.
 */
public data class GetConnectionsPlainArgs(
    public val customerGatewayId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val vpnGatewayId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GetConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GetConnectionsPlainArgs =
        com.pulumi.alicloud.vpn.inputs.GetConnectionsPlainArgs.builder()
            .customerGatewayId(customerGatewayId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionsPlainArgsBuilder internal constructor() {
    private var customerGatewayId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var vpnGatewayId: String? = null

    /**
     * @param value Use the VPN customer gateway ID as the search key.
     */
    @JvmName("fqgfxpsleelpnasq")
    public suspend fun customerGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customerGatewayId = mapped
    }

    /**
     * @param value IDs of the VPN connections.
     */
    @JvmName("nvcigaxwpotjxwvc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values IDs of the VPN connections.
     */
    @JvmName("dgqttveuulpyhfry")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string of VPN connection name.
     */
    @JvmName("crxpbrhnpmtbxnsp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Save the result to the file.
     */
    @JvmName("xkxfquqnivsnpchq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Use the VPN gateway ID as the search key.
     */
    @JvmName("rpqesjdcqfjjhyrb")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnGatewayId = mapped
    }

    internal fun build(): GetConnectionsPlainArgs = GetConnectionsPlainArgs(
        customerGatewayId = customerGatewayId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        vpnGatewayId = vpnGatewayId,
    )
}
