@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GetCustomerGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomerGateways.
 * @property ids ID of the VPN customer gateways.
 * @property nameRegex A regex string of VPN customer gateways name.
 * @property outputFile Save the result to the file.
 */
public data class GetCustomerGatewaysPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GetCustomerGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GetCustomerGatewaysPlainArgs =
        com.pulumi.alicloud.vpn.inputs.GetCustomerGatewaysPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomerGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetCustomerGatewaysPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value ID of the VPN customer gateways.
     */
    @JvmName("ppuvyrsgbsbfdllw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values ID of the VPN customer gateways.
     */
    @JvmName("jvpykcknssuaeevh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string of VPN customer gateways name.
     */
    @JvmName("rfjcvkyebxqkvyaa")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Save the result to the file.
     */
    @JvmName("bnlydkaoqmpwtfpt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetCustomerGatewaysPlainArgs = GetCustomerGatewaysPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
