@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GetGatewayVcoRoutesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewayVcoRoutes.
 * @property ids A list of Vco Route IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property routeEntryType The Routing input type. Valid values: `custom`, `bgp`.
 * @property status The status of the vpn route entry. Valid values: `normal`, `published`.
 * @property vpnConnectionId The id of the vpn connection.
 */
public data class GetGatewayVcoRoutesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val routeEntryType: String? = null,
    public val status: String? = null,
    public val vpnConnectionId: String,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GetGatewayVcoRoutesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GetGatewayVcoRoutesPlainArgs =
        com.pulumi.alicloud.vpn.inputs.GetGatewayVcoRoutesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .routeEntryType(routeEntryType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpnConnectionId(vpnConnectionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayVcoRoutesPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayVcoRoutesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var routeEntryType: String? = null

    private var status: String? = null

    private var vpnConnectionId: String? = null

    /**
     * @param value A list of Vco Route IDs.
     */
    @JvmName("jkpwrruckalwebem")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vco Route IDs.
     */
    @JvmName("kiinxpwvpxriwogt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mmaoldjpiqohcerr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ntkgwenciejruona")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("dtlcrwrtrofwmksr")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The Routing input type. Valid values: `custom`, `bgp`.
     */
    @JvmName("hpwojmuubhynxdbq")
    public suspend fun routeEntryType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routeEntryType = mapped
    }

    /**
     * @param value The status of the vpn route entry. Valid values: `normal`, `published`.
     */
    @JvmName("emrfoirwvcaugnlj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The id of the vpn connection.
     */
    @JvmName("yvdhdefvaqhakyml")
    public suspend fun vpnConnectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpnConnectionId = mapped
    }

    internal fun build(): GetGatewayVcoRoutesPlainArgs = GetGatewayVcoRoutesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        routeEntryType = routeEntryType,
        status = status,
        vpnConnectionId = vpnConnectionId ?: throw PulumiNullFieldException("vpnConnectionId"),
    )
}
