@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GetGatewayVpnAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewayVpnAttachments.
 * @property ids A list of Vpn Attachment IDs.
 * @property nameRegex A regex string to filter results by Vpn Attachment name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
 * @property vpnGatewayId The parameter 'vpn_gateway_id' has been deprecated from 1.194.0.
 */
public data class GetGatewayVpnAttachmentsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    @Deprecated(
        message = """
  The parameter 'vpn_gateway_id' has been deprecated from 1.194.0.
  """,
    )
    public val vpnGatewayId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GetGatewayVpnAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GetGatewayVpnAttachmentsPlainArgs =
        com.pulumi.alicloud.vpn.inputs.GetGatewayVpnAttachmentsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayVpnAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayVpnAttachmentsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    private var vpnGatewayId: String? = null

    /**
     * @param value A list of Vpn Attachment IDs.
     */
    @JvmName("cknjuhnofiklyhdo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpn Attachment IDs.
     */
    @JvmName("eqyfabxwpemdfvly")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Vpn Attachment name.
     */
    @JvmName("fqxsydxenvomqqbk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ideioqopsljowafx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("vldbbgxspluqpnwg")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("mgqquxpirdbyfwbm")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `init`, `active`, `attaching`, `attached`, `detaching`, `financialLocked`, `provisioning`, `updating`, `upgrading`, `deleted`.
     */
    @JvmName("jadpownlxtshkqdh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The parameter 'vpn_gateway_id' has been deprecated from 1.194.0.
     */
    @Deprecated(
        message = """
  The parameter 'vpn_gateway_id' has been deprecated from 1.194.0.
  """,
    )
    @JvmName("lpvjbltebomhvqvs")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnGatewayId = mapped
    }

    internal fun build(): GetGatewayVpnAttachmentsPlainArgs = GetGatewayVpnAttachmentsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
        vpnGatewayId = vpnGatewayId,
    )
}
