@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GetGatewayZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewayZones.
 * @property ids A list of Zone IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property spec Bandwidth specification.-If an IPsec connection is bound to a VPN gateway instance, this parameter indicates the Bandwidth specification of the VPN gateway instance.-If an IPsec connection is bound to a forwarding router, this parameter indicates the bandwidth that you expect the IPsec connection to support.Different bandwidth specifications may affect the zone information that is found. Value:
 * - `5M`
 * - `10M`
 * - `20M`
 * - `50M`
 * - `100M`
 * - `200M`
 * - `500M`
 * - `1000M`
 */
public data class GetGatewayZonesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val spec: String,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GetGatewayZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GetGatewayZonesPlainArgs =
        com.pulumi.alicloud.vpn.inputs.GetGatewayZonesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .spec(spec.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayZonesPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayZonesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var spec: String? = null

    /**
     * @param value A list of Zone IDs.
     */
    @JvmName("aehjfokjkfooewnu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Zone IDs.
     */
    @JvmName("jteulftuheioaohd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("urxqkjuoxklreuhb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Bandwidth specification.-If an IPsec connection is bound to a VPN gateway instance, this parameter indicates the Bandwidth specification of the VPN gateway instance.-If an IPsec connection is bound to a forwarding router, this parameter indicates the bandwidth that you expect the IPsec connection to support.Different bandwidth specifications may affect the zone information that is found. Value:
     * - `5M`
     * - `10M`
     * - `20M`
     * - `50M`
     * - `100M`
     * - `200M`
     * - `500M`
     * - `1000M`
     */
    @JvmName("sqovvaljvdnvvfck")
    public suspend fun spec(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spec = mapped
    }

    internal fun build(): GetGatewayZonesPlainArgs = GetGatewayZonesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        spec = spec ?: throw PulumiNullFieldException("spec"),
    )
}
