@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.GetGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGateways.
 * @property businessStatus Limit search to specific business status - valid value is "Normal", "FinancialLocked".
 * @property enableIpsec Indicates whether the IPsec-VPN feature is enabled.
 * @property ids IDs of the VPN.
 * @property includeReservationData Include ineffective ordering data.
 * @property nameRegex A regex string of VPN name.
 * @property outputFile Save the result to the file.
 * @property status Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
 * @property vpcId Use the VPC ID as the search key.
 */
public data class GetGatewaysPlainArgs(
    public val businessStatus: String? = null,
    @Deprecated(
        message = """
  Field 'enable_ipsec' has been deprecated from provider version 1.193.0 and it will be removed in
      the future version.
  """,
    )
    public val enableIpsec: Boolean? = null,
    public val ids: List<String>? = null,
    public val includeReservationData: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.GetGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.GetGatewaysPlainArgs =
        com.pulumi.alicloud.vpn.inputs.GetGatewaysPlainArgs.builder()
            .businessStatus(businessStatus?.let({ args0 -> args0 }))
            .enableIpsec(enableIpsec?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeReservationData(includeReservationData?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetGatewaysPlainArgsBuilder internal constructor() {
    private var businessStatus: String? = null

    private var enableIpsec: Boolean? = null

    private var ids: List<String>? = null

    private var includeReservationData: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    /**
     * @param value Limit search to specific business status - valid value is "Normal", "FinancialLocked".
     */
    @JvmName("uyroxdjqnccrebej")
    public suspend fun businessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.businessStatus = mapped
    }

    /**
     * @param value Indicates whether the IPsec-VPN feature is enabled.
     */
    @Deprecated(
        message = """
  Field 'enable_ipsec' has been deprecated from provider version 1.193.0 and it will be removed in
      the future version.
  """,
    )
    @JvmName("kvqumswiptlywnmx")
    public suspend fun enableIpsec(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableIpsec = mapped
    }

    /**
     * @param value IDs of the VPN.
     */
    @JvmName("qovgungdlbksrpuk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values IDs of the VPN.
     */
    @JvmName("radtgaugamfntfmw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Include ineffective ordering data.
     */
    @JvmName("bchhppvvhtgfkjvv")
    public suspend fun includeReservationData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeReservationData = mapped
    }

    /**
     * @param value A regex string of VPN name.
     */
    @JvmName("ylrwrikuvcshhryb")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Save the result to the file.
     */
    @JvmName("glvykqnrbvmsopbq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
     */
    @JvmName("fcwbhckyvhmpfvwo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Use the VPC ID as the search key.
     */
    @JvmName("kfapthuywnldkxll")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetGatewaysPlainArgs = GetGatewaysPlainArgs(
        businessStatus = businessStatus,
        enableIpsec = enableIpsec,
        ids = ids,
        includeReservationData = includeReservationData,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        vpcId = vpcId,
    )
}
