@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.IpsecServerIkeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ikeAuthAlg The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
 * @property ikeEncAlg The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
 * @property ikeLifetime IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
 * @property ikeMode The IKE negotiation mode. Default value: `main`.
 * @property ikePfs The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
 * @property ikeVersion The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
 * @property localId The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
 * @property remoteId The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
 */
public data class IpsecServerIkeConfigArgs(
    public val ikeAuthAlg: Output<String>? = null,
    public val ikeEncAlg: Output<String>? = null,
    public val ikeLifetime: Output<Int>? = null,
    public val ikeMode: Output<String>? = null,
    public val ikePfs: Output<String>? = null,
    public val ikeVersion: Output<String>? = null,
    public val localId: Output<String>? = null,
    public val remoteId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.IpsecServerIkeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.IpsecServerIkeConfigArgs =
        com.pulumi.alicloud.vpn.inputs.IpsecServerIkeConfigArgs.builder()
            .ikeAuthAlg(ikeAuthAlg?.applyValue({ args0 -> args0 }))
            .ikeEncAlg(ikeEncAlg?.applyValue({ args0 -> args0 }))
            .ikeLifetime(ikeLifetime?.applyValue({ args0 -> args0 }))
            .ikeMode(ikeMode?.applyValue({ args0 -> args0 }))
            .ikePfs(ikePfs?.applyValue({ args0 -> args0 }))
            .ikeVersion(ikeVersion?.applyValue({ args0 -> args0 }))
            .localId(localId?.applyValue({ args0 -> args0 }))
            .remoteId(remoteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpsecServerIkeConfigArgs].
 */
@PulumiTagMarker
public class IpsecServerIkeConfigArgsBuilder internal constructor() {
    private var ikeAuthAlg: Output<String>? = null

    private var ikeEncAlg: Output<String>? = null

    private var ikeLifetime: Output<Int>? = null

    private var ikeMode: Output<String>? = null

    private var ikePfs: Output<String>? = null

    private var ikeVersion: Output<String>? = null

    private var localId: Output<String>? = null

    private var remoteId: Output<String>? = null

    /**
     * @param value The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
     */
    @JvmName("cvokfyhyormqgtij")
    public suspend fun ikeAuthAlg(`value`: Output<String>) {
        this.ikeAuthAlg = value
    }

    /**
     * @param value The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
     */
    @JvmName("kixvwejqooqtqatt")
    public suspend fun ikeEncAlg(`value`: Output<String>) {
        this.ikeEncAlg = value
    }

    /**
     * @param value IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
     */
    @JvmName("gpbleubjmyytqeki")
    public suspend fun ikeLifetime(`value`: Output<Int>) {
        this.ikeLifetime = value
    }

    /**
     * @param value The IKE negotiation mode. Default value: `main`.
     */
    @JvmName("gtjqtfdmokgquarx")
    public suspend fun ikeMode(`value`: Output<String>) {
        this.ikeMode = value
    }

    /**
     * @param value The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
     */
    @JvmName("gqhrjekjsstugojs")
    public suspend fun ikePfs(`value`: Output<String>) {
        this.ikePfs = value
    }

    /**
     * @param value The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
     */
    @JvmName("afcqgyiblcgemget")
    public suspend fun ikeVersion(`value`: Output<String>) {
        this.ikeVersion = value
    }

    /**
     * @param value The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
     */
    @JvmName("mkrntjburublnrkv")
    public suspend fun localId(`value`: Output<String>) {
        this.localId = value
    }

    /**
     * @param value The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
     */
    @JvmName("kjudqahscrblwgnf")
    public suspend fun remoteId(`value`: Output<String>) {
        this.remoteId = value
    }

    /**
     * @param value The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
     */
    @JvmName("kqhkgxoixlgthgwb")
    public suspend fun ikeAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeAuthAlg = mapped
    }

    /**
     * @param value The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
     */
    @JvmName("yprstcejapbnafmj")
    public suspend fun ikeEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeEncAlg = mapped
    }

    /**
     * @param value IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
     */
    @JvmName("kyyxgauvsmteteyp")
    public suspend fun ikeLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeLifetime = mapped
    }

    /**
     * @param value The IKE negotiation mode. Default value: `main`.
     */
    @JvmName("eanpyrashuhegxgq")
    public suspend fun ikeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeMode = mapped
    }

    /**
     * @param value The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
     */
    @JvmName("bruvqexwjelqwikp")
    public suspend fun ikePfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikePfs = mapped
    }

    /**
     * @param value The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
     */
    @JvmName("odvnatnbycynbmnp")
    public suspend fun ikeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ikeVersion = mapped
    }

    /**
     * @param value The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
     */
    @JvmName("oihbxbalovyklocn")
    public suspend fun localId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localId = mapped
    }

    /**
     * @param value The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
     */
    @JvmName("tsqamstpmkyruqnh")
    public suspend fun remoteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteId = mapped
    }

    internal fun build(): IpsecServerIkeConfigArgs = IpsecServerIkeConfigArgs(
        ikeAuthAlg = ikeAuthAlg,
        ikeEncAlg = ikeEncAlg,
        ikeLifetime = ikeLifetime,
        ikeMode = ikeMode,
        ikePfs = ikePfs,
        ikeVersion = ikeVersion,
        localId = localId,
        remoteId = remoteId,
    )
}
