@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.inputs

import com.pulumi.alicloud.vpn.inputs.IpsecServerIpsecConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipsecAuthAlg The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
 * @property ipsecEncAlg The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
 * @property ipsecLifetime The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
 * @property ipsecPfs Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
 */
public data class IpsecServerIpsecConfigArgs(
    public val ipsecAuthAlg: Output<String>? = null,
    public val ipsecEncAlg: Output<String>? = null,
    public val ipsecLifetime: Output<Int>? = null,
    public val ipsecPfs: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpn.inputs.IpsecServerIpsecConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.vpn.inputs.IpsecServerIpsecConfigArgs =
        com.pulumi.alicloud.vpn.inputs.IpsecServerIpsecConfigArgs.builder()
            .ipsecAuthAlg(ipsecAuthAlg?.applyValue({ args0 -> args0 }))
            .ipsecEncAlg(ipsecEncAlg?.applyValue({ args0 -> args0 }))
            .ipsecLifetime(ipsecLifetime?.applyValue({ args0 -> args0 }))
            .ipsecPfs(ipsecPfs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpsecServerIpsecConfigArgs].
 */
@PulumiTagMarker
public class IpsecServerIpsecConfigArgsBuilder internal constructor() {
    private var ipsecAuthAlg: Output<String>? = null

    private var ipsecEncAlg: Output<String>? = null

    private var ipsecLifetime: Output<Int>? = null

    private var ipsecPfs: Output<String>? = null

    /**
     * @param value The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
     */
    @JvmName("vfrjvjdmmuxblbqb")
    public suspend fun ipsecAuthAlg(`value`: Output<String>) {
        this.ipsecAuthAlg = value
    }

    /**
     * @param value The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
     */
    @JvmName("pdbmwfhxcifqobhw")
    public suspend fun ipsecEncAlg(`value`: Output<String>) {
        this.ipsecEncAlg = value
    }

    /**
     * @param value The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
     */
    @JvmName("nslfwaesgvqatdta")
    public suspend fun ipsecLifetime(`value`: Output<Int>) {
        this.ipsecLifetime = value
    }

    /**
     * @param value Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
     */
    @JvmName("huadypldkgitxcbu")
    public suspend fun ipsecPfs(`value`: Output<String>) {
        this.ipsecPfs = value
    }

    /**
     * @param value The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
     */
    @JvmName("gmoyexyllissxdej")
    public suspend fun ipsecAuthAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecAuthAlg = mapped
    }

    /**
     * @param value The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
     */
    @JvmName("celcvgdnrphibmoa")
    public suspend fun ipsecEncAlg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecEncAlg = mapped
    }

    /**
     * @param value The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
     */
    @JvmName("bibkrwhimimbampj")
    public suspend fun ipsecLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecLifetime = mapped
    }

    /**
     * @param value Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
     */
    @JvmName("ncnvalmtsndeierh")
    public suspend fun ipsecPfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPfs = mapped
    }

    internal fun build(): IpsecServerIpsecConfigArgs = IpsecServerIpsecConfigArgs(
        ipsecAuthAlg = ipsecAuthAlg,
        ipsecEncAlg = ipsecEncAlg,
        ipsecLifetime = ipsecLifetime,
        ipsecPfs = ipsecPfs,
    )
}
