@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enable Bgp enable.
 * @property localAsn Local asn.
 * @property localBgpIp Local bgp IP.
 * @property status The negotiation status of Tunnel.
 * @property tunnelCidr IPSec tunnel Cidr.
 */
public data class ConnectionBgpConfig(
    public val enable: Boolean? = null,
    public val localAsn: String? = null,
    public val localBgpIp: String? = null,
    public val status: String? = null,
    public val tunnelCidr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.ConnectionBgpConfig): ConnectionBgpConfig = ConnectionBgpConfig(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            localAsn = javaType.localAsn().map({ args0 -> args0 }).orElse(null),
            localBgpIp = javaType.localBgpIp().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tunnelCidr = javaType.tunnelCidr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
