@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dip Destination IP.
 * @property enable Specifies whether to enable healthcheck.
 * @property interval Retry interval.
 * @property retry retry times.
 * @property sip Source IP.
 */
public data class ConnectionHealthCheckConfig(
    public val dip: String? = null,
    public val enable: Boolean? = null,
    public val interval: Int? = null,
    public val retry: Int? = null,
    public val sip: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.ConnectionHealthCheckConfig): ConnectionHealthCheckConfig = ConnectionHealthCheckConfig(
            dip = javaType.dip().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            retry = javaType.retry().map({ args0 -> args0 }).orElse(null),
            sip = javaType.sip().map({ args0 -> args0 }).orElse(null),
        )
    }
}
